package io.qt.script;


/**
 * <p>Iterator interface for custom Qt Script objects</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html">QScriptClassPropertyIterator</a></p>
 */
public abstract class QScriptClassPropertyIterator extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QScriptClassPropertyIterator {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public boolean hasNext(){
            return hasNext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean hasNext_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean hasPrevious(){
            return hasPrevious_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean hasPrevious_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.script.QScriptString name(){
            return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.script.QScriptString name_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void next(){
            next_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void next_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void previous(){
            previous_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void previous_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void toBack(){
            toBack_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void toBack_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void toFront(){
            toFront_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void toFront_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#QScriptClassPropertyIterator">QScriptClassPropertyIterator::QScriptClassPropertyIterator(QScriptValue)</a></p>
     */
    protected QScriptClassPropertyIterator(io.qt.script.QScriptValue object){
        super((QPrivateConstructor)null);
        initialize_native(this, object);
    }
    
    private native static void initialize_native(QScriptClassPropertyIterator instance, io.qt.script.QScriptValue object);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#object">QScriptClassPropertyIterator::object()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue object(){
        return object_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue object_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#flags">QScriptClassPropertyIterator::flags()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.script.QScriptValue.PropertyFlags flags(){
        return new io.qt.script.QScriptValue.PropertyFlags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#hasNext">QScriptClassPropertyIterator::hasNext()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean hasNext();
    
    @io.qt.QtUninvokable
    private native boolean hasNext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#hasPrevious">QScriptClassPropertyIterator::hasPrevious()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean hasPrevious();
    
    @io.qt.QtUninvokable
    private native boolean hasPrevious_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#id">QScriptClassPropertyIterator::id()const</a></p>
     */
    @io.qt.QtUninvokable
    public int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#name">QScriptClassPropertyIterator::name()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.script.QScriptString name();
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptString name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#next">QScriptClassPropertyIterator::next()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void next();
    
    @io.qt.QtUninvokable
    private native void next_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#previous">QScriptClassPropertyIterator::previous()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void previous();
    
    @io.qt.QtUninvokable
    private native void previous_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#toBack">QScriptClassPropertyIterator::toBack()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void toBack();
    
    @io.qt.QtUninvokable
    private native void toBack_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptclasspropertyiterator.html#toFront">QScriptClassPropertyIterator::toFront()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void toFront();
    
    @io.qt.QtUninvokable
    private native void toFront_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScriptClassPropertyIterator(QPrivateConstructor p) { super(p); } 
    
}
