package io.qt.script;


/**
 * <p>Access to the Qt Script environment from Qt C++ member functions</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qscriptable.html">QScriptable</a></p>
 */
public interface QScriptable extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.script.QScriptable}</p>
     */
    public static class Impl extends io.qt.QtObject
        implements io.qt.script.QScriptable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QScriptable instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#argument">QScriptable::</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.script.QScriptValue argument(int index){
            return argument_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
        }
        
        private native static io.qt.script.QScriptValue argument_native_int_constfct(long __this__nativeId, int index);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#argumentCount">QScriptable::</a></p>
         */
        @io.qt.QtUninvokable
        public final int argumentCount(){
            return argumentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static int argumentCount_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#context">QScriptable::</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.script.QScriptContext context(){
            return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.script.QScriptContext context_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#engine">QScriptable::</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.script.QScriptEngine engine(){
            return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#thisObject">QScriptable::</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.script.QScriptValue thisObject(){
            return thisObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static io.qt.script.QScriptValue thisObject_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#argument">QScriptable::argument(int)const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.script.QScriptValue argument(int index){
        return Impl.argument_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#argumentCount">QScriptable::argumentCount()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default int argumentCount(){
        return Impl.argumentCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#context">QScriptable::context()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.script.QScriptContext context(){
        return Impl.context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#engine">QScriptable::engine()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.script.QScriptEngine engine(){
        return Impl.engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptable.html#thisObject">QScriptable::thisObject()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.script.QScriptValue thisObject(){
        return Impl.thisObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
}
