package io.qt.script;


/**
 * <p>Acts as a container for the Qt Script data types</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qscriptvalue.html">QScriptValue</a></p>
 */
public class QScriptValue extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptvalue.html#PropertyFlag-enum">QScriptValue::PropertyFlag</a></p>
     * 
     * @see PropertyFlags
     */
    public enum PropertyFlag implements io.qt.QtFlagEnumerator {
        ReadOnly(1),
        Undeletable(2),
        SkipInEnumeration(4),
        PropertyGetter(8),
        PropertySetter(16),
        QObjectMember(32),
        KeepExistingFlags(2048),
        UserRange(-16777216);

        private PropertyFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public PropertyFlags asFlags() {
            return new PropertyFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public PropertyFlags combined(PropertyFlag e) {
            return new PropertyFlags(this, e);
        }

        /**
         * Creates a new {@link PropertyFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static PropertyFlags flags(PropertyFlag ... values) {
            return new PropertyFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PropertyFlag resolve(int value) {
            switch (value) {
            case 1: return ReadOnly;
            case 2: return Undeletable;
            case 4: return SkipInEnumeration;
            case 8: return PropertyGetter;
            case 16: return PropertySetter;
            case 32: return QObjectMember;
            case 2048: return KeepExistingFlags;
            case -16777216: return UserRange;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link PropertyFlag}
     */
    public static final class PropertyFlags extends io.qt.QFlags<PropertyFlag> implements Comparable<PropertyFlags> {
        private static final long serialVersionUID = 0xc15141a73ea3ed05L;

        /**
         * Creates a new PropertyFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public PropertyFlags(PropertyFlag ... args){
            super(args);
        }

        /**
         * Creates a new PropertyFlags with given <code>value</code>.
         * @param value
         */
        public PropertyFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new PropertyFlags
         */
        @Override
        public final PropertyFlags combined(PropertyFlag e){
            return new PropertyFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final PropertyFlags setFlag(PropertyFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final PropertyFlags setFlag(PropertyFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this PropertyFlags.
         * @return array of enum entries
         */
        @Override
        public final PropertyFlag[] flags(){
            return super.flags(PropertyFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final PropertyFlags clone(){
            return new PropertyFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(PropertyFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptvalue.html#ResolveFlag-enum">QScriptValue::ResolveFlag</a></p>
     * 
     * @see ResolveFlags
     */
    public enum ResolveFlag implements io.qt.QtFlagEnumerator {
        ResolveLocal(0),
        ResolvePrototype(1),
        ResolveScope(2),
        ResolveFull(3);

        private ResolveFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ResolveFlags asFlags() {
            return new ResolveFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ResolveFlags combined(ResolveFlag e) {
            return new ResolveFlags(this, e);
        }

        /**
         * Creates a new {@link ResolveFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ResolveFlags flags(ResolveFlag ... values) {
            return new ResolveFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ResolveFlag resolve(int value) {
            switch (value) {
            case 0: return ResolveLocal;
            case 1: return ResolvePrototype;
            case 2: return ResolveScope;
            case 3: return ResolveFull;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ResolveFlag}
     */
    public static final class ResolveFlags extends io.qt.QFlags<ResolveFlag> implements Comparable<ResolveFlags> {
        private static final long serialVersionUID = 0x3cc119ddc5828ef8L;

        /**
         * Creates a new ResolveFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ResolveFlags(ResolveFlag ... args){
            super(args);
        }

        /**
         * Creates a new ResolveFlags with given <code>value</code>.
         * @param value
         */
        public ResolveFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ResolveFlags
         */
        @Override
        public final ResolveFlags combined(ResolveFlag e){
            return new ResolveFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ResolveFlags setFlag(ResolveFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ResolveFlags setFlag(ResolveFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ResolveFlags.
         * @return array of enum entries
         */
        @Override
        public final ResolveFlag[] flags(){
            return super.flags(ResolveFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ResolveFlags clone(){
            return new ResolveFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ResolveFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qscriptvalue.html#SpecialValue-enum">QScriptValue::SpecialValue</a></p>
     */
    public enum SpecialValue implements io.qt.QtEnumerator {
        NullValue(0),
        UndefinedValue(1);

        private SpecialValue(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SpecialValue resolve(int value) {
            switch (value) {
            case 0: return NullValue;
            case 1: return UndefinedValue;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue">QScriptValue::QScriptValue()</a></p>
     */
    public QScriptValue(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QScriptValue instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-2">QScriptValue::QScriptValue(QScriptEngine*,QScriptValue::SpecialValue)</a></p>
     */
    public QScriptValue(io.qt.script.QScriptEngine engine, io.qt.script.QScriptValue.SpecialValue val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, io.qt.script.QScriptValue.SpecialValue val);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-3">QScriptValue::QScriptValue(QScriptEngine*,bool)</a></p>
     */
    public QScriptValue(io.qt.script.QScriptEngine engine, boolean val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, boolean val);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-7">QScriptValue::QScriptValue(QScriptEngine*,QString)</a></p>
     */
    public QScriptValue(io.qt.script.QScriptEngine engine, java.lang.String val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, java.lang.String val);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-6">QScriptValue::QScriptValue(QScriptEngine*,qsreal)</a></p>
     */
    public QScriptValue(io.qt.script.QScriptEngine engine, double val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, double val);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue-obsolete.html#QScriptValue-4">QScriptValue::QScriptValue(QScriptEngine*,int)</a></p>
     */
    public QScriptValue(io.qt.script.QScriptEngine engine, int val){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, val);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptEngine engine, int val);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-9">QScriptValue::QScriptValue(QScriptValue::SpecialValue)</a></p>
     */
    public QScriptValue(io.qt.script.QScriptValue.SpecialValue value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptValue.SpecialValue value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-10">QScriptValue::QScriptValue(bool)</a></p>
     */
    public QScriptValue(boolean value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, boolean value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-1">QScriptValue::QScriptValue(QScriptValue)</a></p>
     */
    public QScriptValue(io.qt.script.QScriptValue other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QScriptValue instance, io.qt.script.QScriptValue other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-14">QScriptValue::QScriptValue(QString)</a></p>
     */
    public QScriptValue(java.lang.String value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-13">QScriptValue::QScriptValue(qsreal)</a></p>
     */
    public QScriptValue(double value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, double value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#QScriptValue-11">QScriptValue::QScriptValue(int)</a></p>
     */
    public QScriptValue(int value){
        super((QPrivateConstructor)null);
        initialize_native(this, value);
    }
    
    private native static void initialize_native(QScriptValue instance, int value);
    
    /**
     * <p>Overloaded function for {@link #call(io.qt.script.QScriptValue, java.util.Collection)}
     *  with <code>args = new java.util.ArrayList&lt;&gt;()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue call(io.qt.script.QScriptValue thisObject) {
        return call(thisObject, new java.util.ArrayList<>());
    }
    
    /**
     * <p>Overloaded function for {@link #call(io.qt.script.QScriptValue, java.util.Collection)}</p>
     * <p>with: </p><ul>
     * <li><code>thisObject = new io.qt.script.QScriptValue()</code></li>
     * <li><code>args = new java.util.ArrayList&lt;&gt;()</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue call() {
        return call(new io.qt.script.QScriptValue(), new java.util.ArrayList<>());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#call">QScriptValue::call(QScriptValue,QScriptValueList)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue call(io.qt.script.QScriptValue thisObject, java.util.Collection<QScriptValue> args){
        return call_native_cref_QScriptValue_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(thisObject), args);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue call_native_cref_QScriptValue_cref_QList(long __this__nativeId, long thisObject, java.util.Collection<QScriptValue> args);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#call-1">QScriptValue::call(QScriptValue,QScriptValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue call(io.qt.script.QScriptValue thisObject, io.qt.script.QScriptValue arguments){
        return call_native_cref_QScriptValue_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(thisObject), QtJambi_LibraryUtilities.internal.checkedNativeId(arguments));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue call_native_cref_QScriptValue_cref_QScriptValue(long __this__nativeId, long thisObject, long arguments);
    
    /**
     * <p>Overloaded function for {@link #construct(java.util.Collection)}
     *  with <code>args = new java.util.ArrayList&lt;&gt;()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue construct() {
        return construct(new java.util.ArrayList<>());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#construct">QScriptValue::construct(QScriptValueList)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue construct(java.util.Collection<QScriptValue> args){
        return construct_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), args);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue construct_native_cref_QList(long __this__nativeId, java.util.Collection<QScriptValue> args);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#construct-1">QScriptValue::construct(QScriptValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue construct(io.qt.script.QScriptValue arguments){
        return construct_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arguments));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue construct_native_cref_QScriptValue(long __this__nativeId, long arguments);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#data">QScriptValue::data()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#engine">QScriptValue::engine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#equals">QScriptValue::equals(QScriptValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean equals(io.qt.script.QScriptValue other){
        return equals_native_cref_QScriptValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean equals_native_cref_QScriptValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#instanceOf">QScriptValue::instanceOf(QScriptValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean instanceOf(io.qt.script.QScriptValue other){
        return instanceOf_native_cref_QScriptValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean instanceOf_native_cref_QScriptValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isArray">QScriptValue::isArray()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isArray(){
        return isArray_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isArray_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isBool">QScriptValue::isBool()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isBoolean(){
        return isBoolean_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isBoolean_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isDate">QScriptValue::isDate()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isDate(){
        return isDate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isError">QScriptValue::isError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isError(){
        return isError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isFunction">QScriptValue::isFunction()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isFunction(){
        return isFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isNull">QScriptValue::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isNumber">QScriptValue::isNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNumber(){
        return isNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isObject">QScriptValue::isObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isObject(){
        return isObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isQObject">QScriptValue::isQObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isQObject(){
        return isQObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isQObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isRegExp">QScriptValue::isRegExp()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isRegExp(){
        return isRegExp_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isRegExp_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isString">QScriptValue::isString()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isString(){
        return isString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isUndefined">QScriptValue::isUndefined()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isUndefined(){
        return isUndefined_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isUndefined_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isValid">QScriptValue::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#isVariant">QScriptValue::isVariant()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isVariant(){
        return isVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isVariant_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#lessThan">QScriptValue::lessThan(QScriptValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean lessThan(io.qt.script.QScriptValue other){
        return lessThan_native_cref_QScriptValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean lessThan_native_cref_QScriptValue_constfct(long __this__nativeId, long other);
    
    @io.qt.QtUninvokable
    public final long objectId(){
        return objectId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long objectId_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #property(io.qt.script.QScriptString, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue property(io.qt.script.QScriptString name, io.qt.script.QScriptValue.ResolveFlag ... mode){
        return property(name, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #property(io.qt.script.QScriptString, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue property(io.qt.script.QScriptString name) {
        return property(name, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#property-2">QScriptValue::property(QScriptString,ResolveFlags)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue property(io.qt.script.QScriptString name, io.qt.script.QScriptValue.ResolveFlags mode){
        return property_native_cref_QScriptString_cref_QFlags_QScriptValue_ResolveFlag__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue property_native_cref_QScriptString_cref_QFlags_QScriptValue_ResolveFlag__constfct(long __this__nativeId, long name, int mode);
    
    /**
     * <p>Overloaded function for {@link #property(java.lang.String, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue property(java.lang.String name, io.qt.script.QScriptValue.ResolveFlag ... mode){
        return property(name, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #property(java.lang.String, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue property(java.lang.String name) {
        return property(name, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#property">QScriptValue::property(QString,ResolveFlags)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue property(java.lang.String name, io.qt.script.QScriptValue.ResolveFlags mode){
        return property_native_cref_QString_cref_QFlags_QScriptValue_ResolveFlag__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, mode.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue property_native_cref_QString_cref_QFlags_QScriptValue_ResolveFlag__constfct(long __this__nativeId, java.lang.String name, int mode);
    
    /**
     * <p>Overloaded function for {@link #property(int, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue property(int arrayIndex, io.qt.script.QScriptValue.ResolveFlag ... mode){
        return property(arrayIndex, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #property(int, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue property(int arrayIndex) {
        return property(arrayIndex, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#property-1">QScriptValue::property(quint32,ResolveFlags)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue property(int arrayIndex, io.qt.script.QScriptValue.ResolveFlags mode){
        return property_native_unsigned_int_cref_QFlags_QScriptValue_ResolveFlag__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex, mode.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue property_native_unsigned_int_cref_QFlags_QScriptValue_ResolveFlag__constfct(long __this__nativeId, int arrayIndex, int mode);
    
    /**
     * <p>Overloaded function for {@link #propertyFlags(io.qt.script.QScriptString, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue.PropertyFlags propertyFlags(io.qt.script.QScriptString name, io.qt.script.QScriptValue.ResolveFlag ... mode){
        return propertyFlags(name, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #propertyFlags(io.qt.script.QScriptString, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue.PropertyFlags propertyFlags(io.qt.script.QScriptString name) {
        return propertyFlags(name, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#propertyFlags-1">QScriptValue::propertyFlags(QScriptString,ResolveFlags)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue.PropertyFlags propertyFlags(io.qt.script.QScriptString name, io.qt.script.QScriptValue.ResolveFlags mode){
        return new io.qt.script.QScriptValue.PropertyFlags(propertyFlags_native_cref_QScriptString_cref_QFlags_QScriptValue_ResolveFlag__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), mode.value()));
    }
    
    @io.qt.QtUninvokable
    private native int propertyFlags_native_cref_QScriptString_cref_QFlags_QScriptValue_ResolveFlag__constfct(long __this__nativeId, long name, int mode);
    
    /**
     * <p>Overloaded function for {@link #propertyFlags(java.lang.String, io.qt.script.QScriptValue.ResolveFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue.PropertyFlags propertyFlags(java.lang.String name, io.qt.script.QScriptValue.ResolveFlag ... mode){
        return propertyFlags(name, new io.qt.script.QScriptValue.ResolveFlags(mode));
    }
    
    /**
     * <p>Overloaded function for {@link #propertyFlags(java.lang.String, io.qt.script.QScriptValue.ResolveFlags)}
     *  with <code>mode = new io.qt.script.QScriptValue.ResolveFlags(1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue.PropertyFlags propertyFlags(java.lang.String name) {
        return propertyFlags(name, new io.qt.script.QScriptValue.ResolveFlags(1));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#propertyFlags">QScriptValue::propertyFlags(QString,ResolveFlags)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue.PropertyFlags propertyFlags(java.lang.String name, io.qt.script.QScriptValue.ResolveFlags mode){
        return new io.qt.script.QScriptValue.PropertyFlags(propertyFlags_native_cref_QString_cref_QFlags_QScriptValue_ResolveFlag__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, mode.value()));
    }
    
    @io.qt.QtUninvokable
    private native int propertyFlags_native_cref_QString_cref_QFlags_QScriptValue_ResolveFlag__constfct(long __this__nativeId, java.lang.String name, int mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#prototype">QScriptValue::prototype()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue prototype(){
        return prototype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue prototype_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptValue scope(){
        return scope_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptValue scope_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#scriptClass">QScriptValue::scriptClass()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.script.QScriptClass scriptClass(){
        return scriptClass_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.script.QScriptClass scriptClass_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#setData">QScriptValue::setData(QScriptValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setData(io.qt.script.QScriptValue data){
        setData_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @io.qt.QtUninvokable
    private native void setData_native_cref_QScriptValue(long __this__nativeId, long data);
    
    /**
     * <p>Overloaded function for {@link #setProperty(io.qt.script.QScriptString, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(io.qt.script.QScriptString name, io.qt.script.QScriptValue value, io.qt.script.QScriptValue.PropertyFlag ... flags){
        setProperty(name, value, new io.qt.script.QScriptValue.PropertyFlags(flags));
    }
    
    /**
     * <p>Overloaded function for {@link #setProperty(io.qt.script.QScriptString, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}
     *  with <code>flags = new io.qt.script.QScriptValue.PropertyFlags(2048)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(io.qt.script.QScriptString name, io.qt.script.QScriptValue value) {
        setProperty(name, value, new io.qt.script.QScriptValue.PropertyFlags(2048));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#setProperty-2">QScriptValue::setProperty(QScriptString,QScriptValue,PropertyFlags)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(io.qt.script.QScriptString name, io.qt.script.QScriptValue value, io.qt.script.QScriptValue.PropertyFlags flags){
        setProperty_native_cref_QScriptString_cref_QScriptValue_cref_QFlags_QScriptValue_PropertyFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(value), flags.value());
    }
    
    @io.qt.QtUninvokable
    private native void setProperty_native_cref_QScriptString_cref_QScriptValue_cref_QFlags_QScriptValue_PropertyFlag_(long __this__nativeId, long name, long value, int flags);
    
    /**
     * <p>Overloaded function for {@link #setProperty(java.lang.String, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, io.qt.script.QScriptValue value, io.qt.script.QScriptValue.PropertyFlag ... flags){
        setProperty(name, value, new io.qt.script.QScriptValue.PropertyFlags(flags));
    }
    
    /**
     * <p>Overloaded function for {@link #setProperty(java.lang.String, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}
     *  with <code>flags = new io.qt.script.QScriptValue.PropertyFlags(2048)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, io.qt.script.QScriptValue value) {
        setProperty(name, value, new io.qt.script.QScriptValue.PropertyFlags(2048));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#setProperty">QScriptValue::setProperty(QString,QScriptValue,PropertyFlags)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(java.lang.String name, io.qt.script.QScriptValue value, io.qt.script.QScriptValue.PropertyFlags flags){
        setProperty_native_cref_QString_cref_QScriptValue_cref_QFlags_QScriptValue_PropertyFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value), flags.value());
    }
    
    @io.qt.QtUninvokable
    private native void setProperty_native_cref_QString_cref_QScriptValue_cref_QFlags_QScriptValue_PropertyFlag_(long __this__nativeId, java.lang.String name, long value, int flags);
    
    /**
     * <p>Overloaded function for {@link #setProperty(int, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, io.qt.script.QScriptValue value, io.qt.script.QScriptValue.PropertyFlag ... flags){
        setProperty(arrayIndex, value, new io.qt.script.QScriptValue.PropertyFlags(flags));
    }
    
    /**
     * <p>Overloaded function for {@link #setProperty(int, io.qt.script.QScriptValue, io.qt.script.QScriptValue.PropertyFlags)}
     *  with <code>flags = new io.qt.script.QScriptValue.PropertyFlags(2048)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, io.qt.script.QScriptValue value) {
        setProperty(arrayIndex, value, new io.qt.script.QScriptValue.PropertyFlags(2048));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#setProperty-1">QScriptValue::setProperty(quint32,QScriptValue,PropertyFlags)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProperty(int arrayIndex, io.qt.script.QScriptValue value, io.qt.script.QScriptValue.PropertyFlags flags){
        setProperty_native_unsigned_int_cref_QScriptValue_cref_QFlags_QScriptValue_PropertyFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), arrayIndex, QtJambi_LibraryUtilities.internal.checkedNativeId(value), flags.value());
    }
    
    @io.qt.QtUninvokable
    private native void setProperty_native_unsigned_int_cref_QScriptValue_cref_QFlags_QScriptValue_PropertyFlag_(long __this__nativeId, int arrayIndex, long value, int flags);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#setPrototype">QScriptValue::setPrototype(QScriptValue)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPrototype(io.qt.script.QScriptValue prototype){
        setPrototype_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(prototype));
    }
    
    @io.qt.QtUninvokable
    private native void setPrototype_native_cref_QScriptValue(long __this__nativeId, long prototype);
    
    @io.qt.QtUninvokable
    public final void setScope(io.qt.script.QScriptValue scope){
        setScope_native_cref_QScriptValue(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scope));
    }
    
    @io.qt.QtUninvokable
    private native void setScope_native_cref_QScriptValue(long __this__nativeId, long scope);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#setScriptClass">QScriptValue::setScriptClass(QScriptClass*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setScriptClass(io.qt.script.QScriptClass scriptClass){
        setScriptClass_native_QScriptClass_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scriptClass));
    }
    
    @io.qt.QtUninvokable
    private native void setScriptClass_native_QScriptClass_ptr(long __this__nativeId, long scriptClass);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#strictlyEquals">QScriptValue::strictlyEquals(QScriptValue)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean strictlyEquals(io.qt.script.QScriptValue other){
        return strictlyEquals_native_cref_QScriptValue_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean strictlyEquals_native_cref_QScriptValue_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toBool">QScriptValue::toBool()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean toBoolean(){
        return toBoolean_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean toBoolean_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toDateTime">QScriptValue::toDateTime()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QDateTime toDateTime(){
        return toDateTime_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QDateTime toDateTime_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toInt32">QScriptValue::toInt32()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int toInt(){
        return toInt_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int toInt_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toInteger">QScriptValue::toInteger()const</a></p>
     */
    @io.qt.QtUninvokable
    private final double private_toInteger(){
        return private_toInteger_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double private_toInteger_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toNumber">QScriptValue::toNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double toDouble(){
        return toDouble_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double toDouble_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toQObject">QScriptValue::toQObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QObject toQObject(){
        return toQObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject toQObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toRegExp">QScriptValue::toRegExp()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRegExp toRegExp(){
        return toRegExp_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRegExp toRegExp_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toString">QScriptValue::toString()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toUInt16">QScriptValue::toUInt16()const</a></p>
     */
    @io.qt.QtUninvokable
    public final short toShort(){
        return toShort_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native short toShort_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qscriptvalue.html#toVariant">QScriptValue::toVariant()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.Object toVariant(){
        return toVariant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object toVariant_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScriptValue(QPrivateConstructor p) { super(p); } 
    
    @io.qt.QtUninvokable
    public final Integer toInteger() {
          if(Double.isNaN(private_toInteger())){
              return null;
          }else{
              return toInt();
          }
    }
    
    @Override
    public QScriptValue clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QScriptValue clone_native(long __this_nativeId);
}
