package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>A node on a Qt Remote Objects network</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html">QRemoteObjectNode</a></code></p>
 */
public class QRemoteObjectNode extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcHostSideConnection;
    @QtPropertyMember(enabled=false)
    private Object __rcPersistedStore = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRemoteObjectNode.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::ErrorCode</a></code></p>
     */
    public enum ErrorCode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>RegistryNotAcquired</a></code></p>
         */
        RegistryNotAcquired(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>RegistryAlreadyHosted</a></code></p>
         */
        RegistryAlreadyHosted(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>NodeIsNoServer</a></code></p>
         */
        NodeIsNoServer(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>ServerAlreadyCreated</a></code></p>
         */
        ServerAlreadyCreated(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>UnintendedRegistryHosting</a></code></p>
         */
        UnintendedRegistryHosting(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>OperationNotValidOnClientNode</a></code></p>
         */
        OperationNotValidOnClientNode(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>SourceNotRegistered</a></code></p>
         */
        SourceNotRegistered(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>MissingObjectName</a></code></p>
         */
        MissingObjectName(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>HostUrlInvalid</a></code></p>
         */
        HostUrlInvalid(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>ProtocolMismatch</a></code></p>
         */
        ProtocolMismatch(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::<wbr>ListenFailed</a></code></p>
         */
        ListenFailed(11);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ErrorCode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ErrorCode resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return RegistryNotAcquired;
            case 2: return RegistryAlreadyHosted;
            case 3: return NodeIsNoServer;
            case 4: return ServerAlreadyCreated;
            case 5: return UnintendedRegistryHosting;
            case 6: return OperationNotValidOnClientNode;
            case 7: return SourceNotRegistered;
            case 8: return MissingObjectName;
            case 9: return HostUrlInvalid;
            case 10: return ProtocolMismatch;
            case 11: return ListenFailed;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt callable <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#RemoteObjectSchemaHandler-typedef">QRemoteObjectNode::RemoteObjectSchemaHandler</a></code></p>
     */
    @FunctionalInterface
    public interface RemoteObjectSchemaHandler extends QtObjectInterface, java.util.function.Consumer<io.qt.core.@NonNull QUrl> {

        @Override
        public void accept(io.qt.core.@NonNull QUrl arg__1);

        /**
         * @hidden
         * <p>Implementor class for interface {@link RemoteObjectSchemaHandler}</p>
         */
        public static abstract class Impl extends QtObject implements RemoteObjectSchemaHandler{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(RemoteObjectSchemaHandler instance);

            @NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public void accept(io.qt.core.@NonNull QUrl arg__1){
                    accept_native(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
                }

                private native void accept_native(long arg__1);
            }

        }
    }


    /**
     * <p>See <code>QRemoteObjectNode::<wbr>error(QRemoteObjectNode::ErrorCode)</code></p>
     */
    public final @NonNull Signal1<io.qt.remoteobjects.QRemoteObjectNode.@NonNull ErrorCode> error = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#heartbeatInterval-prop">QRemoteObjectNode::<wbr>heartbeatIntervalChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="heartbeatInterval")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> heartbeatIntervalChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#remoteObjectAdded">QRemoteObjectNode::<wbr>remoteObjectAdded(QRemoteObjectSourceLocation)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QPair<java.lang.@NonNull String, io.qt.remoteobjects.@NonNull QRemoteObjectSourceLocationInfo>> remoteObjectAdded = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#remoteObjectRemoved">QRemoteObjectNode::<wbr>remoteObjectRemoved(QRemoteObjectSourceLocation)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QPair<java.lang.@NonNull String, io.qt.remoteobjects.@NonNull QRemoteObjectSourceLocationInfo>> remoteObjectRemoved = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#QRemoteObjectNode">QRemoteObjectNode::<wbr>QRemoteObjectNode(QObject*)</a></code></p>
     */
    public QRemoteObjectNode(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRemoteObjectNode instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#QRemoteObjectNode-1">QRemoteObjectNode::<wbr>QRemoteObjectNode(QUrl,<wbr>QObject*)</a></code></p>
     */
    public QRemoteObjectNode(io.qt.core.@NonNull QUrl registryAddress, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, registryAddress, parent);
    }
    
    private native static void initialize_native(QRemoteObjectNode instance, io.qt.core.QUrl registryAddress, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#acquireDynamic">QRemoteObjectNode::<wbr>acquireDynamic(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QRemoteObjectDynamicReplica acquireDynamic(java.lang.@NonNull String name){
        return acquireDynamic_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectDynamicReplica acquireDynamic_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#acquireModel">QRemoteObjectNode::<wbr>acquireModel(QString,<wbr>QtRemoteObjects::InitialAction,<wbr>QList&lt;int&gt;)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QAbstractItemModelReplica acquireModel(java.lang.@NonNull String name, io.qt.remoteobjects.QtRemoteObjects.@NonNull InitialAction action, java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> rolesHint){
        return acquireModel_native_cref_QString_QtRemoteObjects_InitialAction_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), name, action.value(), rolesHint);
    }
    
    @QtUninvokable
    private native io.qt.remoteobjects.QAbstractItemModelReplica acquireModel_native_cref_QString_QtRemoteObjects_InitialAction_cref_QList(long __this__nativeId, java.lang.String name, int action, java.util.Collection<java.lang.@QtPrimitiveType Integer> rolesHint);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#addClientSideConnection">QRemoteObjectNode::<wbr>addClientSideConnection(QIODevice*)</a></code></p>
     */
    @QtUninvokable
    public final void addClientSideConnection(io.qt.core.@Nullable QIODevice ioDevice){
        addClientSideConnection_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ioDevice));
        if (ioDevice != null) {
            if(__rcHostSideConnection==null)
                __rcHostSideConnection = QtJambi_LibraryUtilities.internal.newRCList();
            __rcHostSideConnection.add(ioDevice);
        }
    }
    
    @QtUninvokable
    private native void addClientSideConnection_native_QIODevice_ptr(long __this__nativeId, long ioDevice);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#connectToNode">QRemoteObjectNode::<wbr>connectToNode(QUrl)</a></code></p>
     */
    public final boolean connectToNode(io.qt.core.@NonNull QUrl address){
        return connectToNode_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(address));
    }
    
    private native boolean connectToNode_native_cref_QUrl(long __this__nativeId, long address);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#heartbeatInterval-prop">QRemoteObjectNode::<wbr>heartbeatInterval()const</a></code></p>
     */
    @QtPropertyReader(name="heartbeatInterval")
    @QtUninvokable
    public final int heartbeatInterval(){
        return heartbeatInterval_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int heartbeatInterval_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#instances-1">QRemoteObjectNode::<wbr>instances(QStringView)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList instances(java.lang.@NonNull String typeName){
        return instances_native_QStringView_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), typeName);
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList instances_native_QStringView_constfct(long __this__nativeId, java.lang.String typeName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#lastError">QRemoteObjectNode::<wbr>lastError()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.remoteobjects.QRemoteObjectNode.@NonNull ErrorCode lastError(){
        return io.qt.remoteobjects.QRemoteObjectNode.ErrorCode.resolve(lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#persistedStore-prop">QRemoteObjectNode::<wbr>persistedStore()const</a></code></p>
     */
    @QtPropertyReader(name="persistedStore")
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QRemoteObjectAbstractPersistedStore persistedStore(){
        return persistedStore_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectAbstractPersistedStore persistedStore_native_constfct(long __this__nativeId);
    
    /**
     * <p>Provide a custom method to handle externally provided schemas</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#registerExternalSchema">QRemoteObjectNode::<wbr>registerExternalSchema(QString,<wbr>QRemoteObjectNode::RemoteObjectSchemaHandler)</a></code></p>
     */
    @QtUninvokable
    public final void registerExternalSchema(java.lang.@NonNull String schema, io.qt.remoteobjects.QRemoteObjectNode.@Nullable RemoteObjectSchemaHandler handler){
        registerExternalSchema_native_cref_QString_QRemoteObjectNode_RemoteObjectSchemaHandler(QtJambi_LibraryUtilities.internal.nativeId(this), schema, handler);
    }
    
    @QtUninvokable
    private native void registerExternalSchema_native_cref_QString_QRemoteObjectNode_RemoteObjectSchemaHandler(long __this__nativeId, java.lang.String schema, io.qt.remoteobjects.QRemoteObjectNode.RemoteObjectSchemaHandler handler);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#registry">QRemoteObjectNode::<wbr>registry()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QRemoteObjectRegistry registry(){
        return registry_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectRegistry registry_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#registryUrl-prop">QRemoteObjectNode::<wbr>registryUrl()const</a></code></p>
     */
    @QtPropertyReader(name="registryUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl registryUrl(){
        return registryUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl registryUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#heartbeatInterval-prop">QRemoteObjectNode::<wbr>setHeartbeatInterval(int)</a></code></p>
     */
    @QtPropertyWriter(name="heartbeatInterval")
    @QtUninvokable
    public final void setHeartbeatInterval(int interval){
        setHeartbeatInterval_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), interval);
    }
    
    @QtUninvokable
    private native void setHeartbeatInterval_native_int(long __this__nativeId, int interval);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#persistedStore-prop">QRemoteObjectNode::<wbr>setPersistedStore(QRemoteObjectAbstractPersistedStore*)</a></code></p>
     */
    @QtPropertyWriter(name="persistedStore")
    @QtUninvokable
    public final void setPersistedStore(io.qt.remoteobjects.@Nullable QRemoteObjectAbstractPersistedStore persistedStore){
        setPersistedStore_native_QRemoteObjectAbstractPersistedStore_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(persistedStore));
        __rcPersistedStore = persistedStore;
    }
    
    @QtUninvokable
    private native void setPersistedStore_native_QRemoteObjectAbstractPersistedStore_ptr(long __this__nativeId, long persistedStore);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#waitForRegistry">QRemoteObjectNode::<wbr>waitForRegistry(int)</a></code></p>
     */
    @QtUninvokable
    public final boolean waitForRegistry(int timeout){
        return waitForRegistry_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    @QtUninvokable
    private native boolean waitForRegistry_native_int(long __this__nativeId, int timeout);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#setName">QRemoteObjectNode::<wbr>setName(QString)</a></code></p>
     */
    @QtUninvokable
    public void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qremoteobjectnode.html#registryUrl-prop">QRemoteObjectNode::<wbr>setRegistryUrl(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="registryUrl")
    @QtUninvokable
    public boolean setRegistryUrl(io.qt.core.@NonNull QUrl registryAddress){
        return setRegistryUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(registryAddress));
    }
    
    @QtUninvokable
    private native boolean setRegistryUrl_native_cref_QUrl(long __this__nativeId, long registryAddress);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#timerEvent">QObject::<wbr>timerEvent(QTimerEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void timerEvent(io.qt.core.@Nullable QTimerEvent arg__1){
        timerEvent_native_QTimerEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void timerEvent_native_QTimerEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRemoteObjectNode(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRemoteObjectNode(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRemoteObjectNode instance, QDeclarativeConstructor constructor);
    
    /**
     * <p>Overloaded function for {@link #acquireModel(java.lang.String, io.qt.remoteobjects.QtRemoteObjects.InitialAction, java.util.Collection)}</p>
     * <p>with: </p><ul>
     * <li><code>action = io.qt.remoteobjects.QtRemoteObjects.InitialAction.FetchRootSize</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.remoteobjects.QAbstractItemModelReplica acquireModel(java.lang.String name, int...rolesHint) {
        return acquireModel(name, io.qt.remoteobjects.QtRemoteObjects.InitialAction.FetchRootSize, rolesHint);
    }
    
    /**
     * <p>Overloaded function for {@link #acquireModel(java.lang.String, io.qt.remoteobjects.QtRemoteObjects.InitialAction, java.util.Collection)}.
     */
    @QtUninvokable
    public final io.qt.remoteobjects.QAbstractItemModelReplica acquireModel(java.lang.String name, io.qt.remoteobjects.QtRemoteObjects.InitialAction action, int...rolesHint) {
        java.util.List<Integer> _rolesHint = new java.util.ArrayList<>();
        for (int hint : rolesHint) {
            _rolesHint.add(hint);
        }
        return acquireModel(name, action, _rolesHint);
    }
    
    @QtUninvokable
    public final io.qt.core.QStringList instances(Class<? extends io.qt.core.QObject> type){
        for(io.qt.core.QPair<String, String> info : io.qt.core.QMetaObject.forType(type).classInfos()) {
            if("RemoteObject Type".equals(info.first)) {
                return instances(info.second);
            }
        }
        return new io.qt.core.QStringList();
    }
    
    @QtUninvokable
    public final <T extends QRemoteObjectReplica> T acquire(java.util.function.BiFunction<QRemoteObjectNode, String, T> replicaConstructor) {
        return acquire(replicaConstructor, null);
    }
    
    @QtUninvokable
    public final <T extends QRemoteObjectReplica> T acquire(java.util.function.BiFunction<QRemoteObjectNode, String, T> replicaConstructor, String name) {
        return replicaConstructor.apply(this, name);
    }
    
    @QtUninvokable
    public final <T extends QRemoteObjectReplica> T acquire(Class<T> type) throws NoSuchMethodException{
        return acquire(type, null);
    }
    
    @QtUninvokable
    public final <T extends QRemoteObjectReplica> T acquire(Class<T> type, java.lang.String name) throws NoSuchMethodException{
        if(type==QRemoteObjectDynamicReplica.class) {
            return type.cast(acquireDynamic(name));
        }
        java.lang.reflect.Constructor<T> constructor = type.getConstructor(QRemoteObjectNode.class, String.class);
        try {
    			return QtJambi_LibraryUtilities.internal.invokeContructor(constructor, this, name);
        } catch (java.lang.reflect.InvocationTargetException e) {
            if(e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }else if(e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }catch(RuntimeException | Error e) {
    			throw e;
        }catch(Throwable e) {
            throw new RuntimeException(e);
        }
    }    
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectNode(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRemoteObjectNode() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectNode(io.qt.core.QUrl, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRemoteObjectNode(io.qt.core.@NonNull QUrl registryAddress) {
        this(registryAddress, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #acquireModel(java.lang.String, io.qt.remoteobjects.QtRemoteObjects.InitialAction, java.util.Collection)}
     *  with <code>rolesHint = new java.util.ArrayList&lt;&gt;()</code>.</p>
     */
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QAbstractItemModelReplica acquireModel(java.lang.@NonNull String name, io.qt.remoteobjects.QtRemoteObjects.@NonNull InitialAction action) {
        return acquireModel(name, action, new java.util.ArrayList<>());
    }
    
    /**
     * <p>Overloaded function for {@link #acquireModel(java.lang.String, io.qt.remoteobjects.QtRemoteObjects.InitialAction, java.util.Collection)}</p>
     * <p>with: </p><ul>
     * <li><code>action = io.qt.remoteobjects.QtRemoteObjects.InitialAction.FetchRootSize</code></li>
     * <li><code>rolesHint = new java.util.ArrayList&lt;&gt;()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QAbstractItemModelReplica acquireModel(java.lang.@NonNull String name) {
        return acquireModel(name, io.qt.remoteobjects.QtRemoteObjects.InitialAction.FetchRootSize, new java.util.ArrayList<>());
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #heartbeatInterval()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getHeartbeatInterval() {
        return heartbeatInterval();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #persistedStore()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QRemoteObjectAbstractPersistedStore getPersistedStore() {
        return persistedStore();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #registryUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getRegistryUrl() {
        return registryUrl();
    }
    
    /**
     * <p>Overloaded function for {@link #waitForRegistry(int)}
     *  with <code>timeout = 30000</code>.</p>
     */
    @QtUninvokable
    public final boolean waitForRegistry() {
        return waitForRegistry((int)30000);
    }
}
