package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>Serves as a convenience class for Replicas of Sources based on QAbstractItemModel</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qabstractitemmodelreplica.html">QAbstractItemModelReplica</a></code></p>
 */
public final class QAbstractItemModelReplica extends io.qt.core.QAbstractItemModel
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractItemModelReplica.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodelreplica.html#initialized">QAbstractItemModelReplica::<wbr>initialized()</a></code></p>
     */
    public final @NonNull Signal0 initialized = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodelreplica.html#availableRoles">QAbstractItemModelReplica::<wbr>availableRoles()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> availableRoles(){
        return availableRoles_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> availableRoles_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#data">QAbstractItemModel::<wbr>data(QModelIndex,<wbr>int)const</a></code></p>
     */
    public final java.lang.Object data(io.qt.core.@NonNull QModelIndex index, int role){
        return data_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index), role);
    }
    
    private native java.lang.Object data_native_cref_QModelIndex_int_constfct(long __this__nativeId, long index, int role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodelreplica.html#hasData">QAbstractItemModelReplica::<wbr>hasData(QModelIndex,<wbr>int)const</a></code></p>
     */
    @QtUninvokable
    public final boolean hasData(io.qt.core.@NonNull QModelIndex index, int role){
        return hasData_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index), role);
    }
    
    @QtUninvokable
    private native boolean hasData_native_cref_QModelIndex_int_constfct(long __this__nativeId, long index, int role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodelreplica.html#isInitialized">QAbstractItemModelReplica::<wbr>isInitialized()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isInitialized(){
        return isInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isInitialized_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodelreplica.html#rootCacheSize">QAbstractItemModelReplica::<wbr>rootCacheSize()const</a></code></p>
     */
    @QtUninvokable
    public final long rootCacheSize(){
        return rootCacheSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long rootCacheSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodelreplica.html#selectionModel">QAbstractItemModelReplica::<wbr>selectionModel()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QItemSelectionModel selectionModel(){
        return selectionModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QItemSelectionModel selectionModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodelreplica.html#setRootCacheSize">QAbstractItemModelReplica::<wbr>setRootCacheSize(size_t)</a></code></p>
     */
    @QtUninvokable
    public final void setRootCacheSize(long rootCacheSize){
        setRootCacheSize_native_size_t(QtJambi_LibraryUtilities.internal.nativeId(this), rootCacheSize);
    }
    
    @QtUninvokable
    private native void setRootCacheSize_native_size_t(long __this__nativeId, long rootCacheSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#columnCount">QAbstractItemModel::<wbr>columnCount(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public int columnCount(io.qt.core.@NonNull QModelIndex parent){
        return columnCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native int columnCount_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#flags">QAbstractItemModel::<wbr>flags(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.core.Qt.@NonNull ItemFlags flags(io.qt.core.@NonNull QModelIndex index){
        return new io.qt.core.Qt.ItemFlags(flags_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index)));
    }
    
    @QtUninvokable
    private native int flags_native_cref_QModelIndex_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#hasChildren">QAbstractItemModel::<wbr>hasChildren(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public boolean hasChildren(io.qt.core.@NonNull QModelIndex parent){
        return hasChildren_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native boolean hasChildren_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#headerData">QAbstractItemModel::<wbr>headerData(int,<wbr>Qt::Orientation,<wbr>int)const</a></code></p>
     */
    @QtUninvokable
    public java.lang.Object headerData(int section, io.qt.core.Qt.@NonNull Orientation orientation, int role){
        return headerData_native_int_Qt_Orientation_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), section, orientation.value(), role);
    }
    
    @QtUninvokable
    private native java.lang.Object headerData_native_int_Qt_Orientation_int_constfct(long __this__nativeId, int section, int orientation, int role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#index">QAbstractItemModel::<wbr>index(int,<wbr>int,<wbr>QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.core.@NonNull QModelIndex index(int row, int column, io.qt.core.@NonNull QModelIndex parent){
        return index_native_int_int_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), row, column, QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native io.qt.core.QModelIndex index_native_int_int_cref_QModelIndex_constfct(long __this__nativeId, int row, int column, long parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#multiData">QAbstractItemModel::<wbr>multiData(QModelIndex,<wbr>QModelRoleDataSpan)const</a></code></p>
     */
    @QtUninvokable
    public void multiData(io.qt.core.@NonNull QModelIndex index, java.util.@NonNull Map<Integer,Object> roleDataSpan){
        multiData_native_cref_QModelIndex_QModelRoleDataSpan_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index), roleDataSpan);
    }
    
    @QtUninvokable
    private native void multiData_native_cref_QModelIndex_QModelRoleDataSpan_constfct(long __this__nativeId, long index, java.util.Map<Integer,Object> roleDataSpan);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#parent">QAbstractItemModel::<wbr>parent(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public io.qt.core.@NonNull QModelIndex parent(io.qt.core.@NonNull QModelIndex index){
        return parent_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index));
    }
    
    @QtUninvokable
    private native io.qt.core.QModelIndex parent_native_cref_QModelIndex_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#roleNames">QAbstractItemModel::<wbr>roleNames()const</a></code></p>
     */
    @QtUninvokable
    public java.util.@NonNull Map<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.core.@NonNull QByteArray> roleNames(){
        return roleNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.util.Map<java.lang.@QtPrimitiveType Integer, io.qt.core.QByteArray> roleNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#rowCount">QAbstractItemModel::<wbr>rowCount(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public int rowCount(io.qt.core.@NonNull QModelIndex parent){
        return rowCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native int rowCount_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#setData">QAbstractItemModel::<wbr>setData(QModelIndex,<wbr>QVariant,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public boolean setData(io.qt.core.@NonNull QModelIndex index, java.lang.Object value, int role){
        return setData_native_cref_QModelIndex_cref_QVariant_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index), value, role);
    }
    
    @QtUninvokable
    private native boolean setData_native_cref_QModelIndex_cref_QVariant_int(long __this__nativeId, long index, java.lang.Object value, int role);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractItemModelReplica(QPrivateConstructor p) { super(p); } 
    
}
