package io.qt.remoteobjects;


/**
 * <p>Base functionality common to Host and RegistryHost classes</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qremoteobjecthostbase.html">QRemoteObjectHostBase</a></p>
 */
public class QRemoteObjectHostBase extends io.qt.remoteobjects.QRemoteObjectNode
{
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcHostSideConnection;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRemoteObjectHostBase.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qremoteobjecthostbase.html#AllowedSchemas-enum">QRemoteObjectHostBase::AllowedSchemas</a></p>
     */
    public enum AllowedSchemas implements io.qt.QtEnumerator {
        BuiltInSchemasOnly(0),
        AllowExternalRegistration(1);

        private AllowedSchemas(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AllowedSchemas resolve(int value) {
            switch (value) {
            case 0: return BuiltInSchemasOnly;
            case 1: return AllowExternalRegistration;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt function pointer QRemoteObjectHostBase::RemoteObjectNameFilter</p>
     */
    @FunctionalInterface
    public interface RemoteObjectNameFilter extends io.qt.QtObjectInterface, java.util.function.BiPredicate<java.lang.String, java.lang.String> {

        @Override
        public boolean test(java.lang.String arg__1, java.lang.String arg__2);

        /**
         * <p>Implementor class for interface {@link RemoteObjectNameFilter}</p>
         */
        public static abstract class Impl extends io.qt.QtObject implements RemoteObjectNameFilter{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(RemoteObjectNameFilter instance);

            @io.qt.NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public native boolean test(java.lang.String arg__1, java.lang.String arg__2);
            }

        }
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjecthostbase.html#addHostSideConnection">QRemoteObjectHostBase::addHostSideConnection(QIODevice*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addHostSideConnection(io.qt.core.QIODevice ioDevice){
        addHostSideConnection_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ioDevice));
        if (ioDevice != null) {
            if(__rcHostSideConnection==null)
                __rcHostSideConnection = QtJambi_LibraryUtilities.internal.newRCList();
            __rcHostSideConnection.add(ioDevice);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addHostSideConnection_native_QIODevice_ptr(long __this__nativeId, long ioDevice);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjecthostbase.html#disableRemoting">QRemoteObjectHostBase::disableRemoting(QObject*)</a></p>
     */
    public final boolean disableRemoting(io.qt.core.QObject remoteObject){
        return disableRemoting_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(remoteObject));
    }
    
    private native boolean disableRemoting_native_QObject_ptr(long __this__nativeId, long remoteObject);
    
    /**
     * <p>Overloaded function for {@link #enableRemoting(io.qt.core.QAbstractItemModel, java.lang.String, java.util.Collection, io.qt.core.QItemSelectionModel)}
     *  with <code>selectionModel = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean enableRemoting(io.qt.core.QAbstractItemModel model, java.lang.String name, java.util.Collection<java.lang.Integer> roles) {
        return enableRemoting(model, name, roles, (io.qt.core.QItemSelectionModel)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjecthostbase.html#enableRemoting-2">QRemoteObjectHostBase::enableRemoting(QAbstractItemModel*,QString,QList&lt;int&gt;,QItemSelectionModel*)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean enableRemoting(io.qt.core.QAbstractItemModel model, java.lang.String name, java.util.Collection<java.lang.Integer> roles, io.qt.core.QItemSelectionModel selectionModel){
        return enableRemoting_native_QAbstractItemModel_ptr_cref_QString_const_QList_QItemSelectionModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(model), name, roles, QtJambi_LibraryUtilities.internal.checkedNativeId(selectionModel));
    }
    
    @io.qt.QtUninvokable
    private native boolean enableRemoting_native_QAbstractItemModel_ptr_cref_QString_const_QList_QItemSelectionModel_ptr(long __this__nativeId, long model, java.lang.String name, java.util.Collection<java.lang.Integer> roles, long selectionModel);
    
    /**
     * <p>Overloaded function for {@link #enableRemoting(io.qt.core.QObject, java.lang.String)}
     *  with <code>name = (String)null</code>.</p>
     */
    public final boolean enableRemoting(io.qt.core.QObject object) {
        return enableRemoting(object, (String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjecthostbase.html#enableRemoting-1">QRemoteObjectHostBase::enableRemoting(QObject*,QString)</a></p>
     */
    public final boolean enableRemoting(io.qt.core.QObject object, java.lang.String name){
        return enableRemoting_native_QObject_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), name);
    }
    
    private native boolean enableRemoting_native_QObject_ptr_cref_QString(long __this__nativeId, long object, java.lang.String name);
    
    /**
     * <p>Overloaded function for {@link #proxy(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}
     *  with <code>filter = (a,b)-&gt;true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean proxy(io.qt.core.QUrl registryUrl, io.qt.core.QUrl hostUrl) {
        return proxy(registryUrl, hostUrl, (a,b)->true);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}</p>
     * <p>with: </p><ul>
     * <li><code>hostUrl = new io.qt.core.QUrl()</code></li>
     * <li><code>filter = (a,b)-&gt;true</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final boolean proxy(io.qt.core.QUrl registryUrl) {
        return proxy(registryUrl, new io.qt.core.QUrl(), (a,b)->true);
    }
    
    /**
     * <p>Forward Remote Objects from another network</p>
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjecthostbase.html#proxy">QRemoteObjectHostBase::proxy(QUrl,QUrl,QRemoteObjectHostBase::RemoteObjectNameFilter)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean proxy(io.qt.core.QUrl registryUrl, io.qt.core.QUrl hostUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter filter){
        return proxy_native_cref_QUrl_cref_QUrl_QRemoteObjectHostBase_RemoteObjectNameFilter(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(registryUrl), QtJambi_LibraryUtilities.internal.checkedNativeId(hostUrl), filter);
    }
    
    @io.qt.QtUninvokable
    private native boolean proxy_native_cref_QUrl_cref_QUrl_QRemoteObjectHostBase_RemoteObjectNameFilter(long __this__nativeId, long registryUrl, long hostUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter filter);
    
    /**
     * <p>Overloaded function for {@link #reverseProxy(io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}
     *  with <code>filter = (a,b)-&gt;true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean reverseProxy() {
        return reverseProxy((a,b)->true);
    }
    
    /**
     * <p>Forwards remote objects to another network</p>
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjecthostbase.html#reverseProxy">QRemoteObjectHostBase::reverseProxy(QRemoteObjectHostBase::RemoteObjectNameFilter)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean reverseProxy(io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter filter){
        return reverseProxy_native_QRemoteObjectHostBase_RemoteObjectNameFilter(QtJambi_LibraryUtilities.internal.nativeId(this), filter);
    }
    
    @io.qt.QtUninvokable
    private native boolean reverseProxy_native_QRemoteObjectHostBase_RemoteObjectNameFilter(long __this__nativeId, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter filter);
    
    @io.qt.QtUninvokable
    protected io.qt.core.QUrl hostUrl(){
        return hostUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl hostUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setHostUrl(io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas)}
     *  with <code>allowedSchemas = io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly</code>.</p>
     */
    @io.qt.QtUninvokable
    protected final boolean setHostUrl(io.qt.core.QUrl hostAddress) {
        return setHostUrl(hostAddress, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly);
    }
    
    @io.qt.QtUninvokable
    protected boolean setHostUrl(io.qt.core.QUrl hostAddress, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas allowedSchemas){
        return setHostUrl_native_cref_QUrl_QRemoteObjectHostBase_AllowedSchemas(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(hostAddress), allowedSchemas.value());
    }
    
    @io.qt.QtUninvokable
    private native boolean setHostUrl_native_cref_QUrl_QRemoteObjectHostBase_AllowedSchemas(long __this__nativeId, long hostAddress, int allowedSchemas);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectnode.html#setName">QRemoteObjectNode::setName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QRemoteObjectHostBase(QPrivateConstructor p) { super(p); } 
    
}
