package io.qt.remoteobjects;


/**
 * <p>Encapsulates the result of an asynchronous method call</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html">QRemoteObjectPendingCall</a></p>
 */
public interface QRemoteObjectPendingCall extends io.qt.QtObjectInterface
{
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#Error-enum">QRemoteObjectPendingCall::Error</a></p>
     */
    public enum Error implements io.qt.QtEnumerator {
        NoError(0),
        InvalidMessage(1);

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return InvalidMessage;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Implementor class for interface {@link io.qt.remoteobjects.QRemoteObjectPendingCall}</p>
     */
    public static class Impl extends io.qt.QtObject
        implements io.qt.remoteobjects.QRemoteObjectPendingCall,
                java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QRemoteObjectPendingCall instance);
        
        public Impl(io.qt.remoteobjects.QRemoteObjectPendingCall other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(QRemoteObjectPendingCall instance, io.qt.remoteobjects.QRemoteObjectPendingCall other);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#error">QRemoteObjectPendingCall::error()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.remoteobjects.QRemoteObjectPendingCall.Error error(){
            return io.qt.remoteobjects.QRemoteObjectPendingCall.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        private native static int error_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#isFinished">QRemoteObjectPendingCall::isFinished()const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isFinished(){
            return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isFinished_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#returnValue">QRemoteObjectPendingCall::returnValue()const</a></p>
         */
        @io.qt.QtUninvokable
        public final java.lang.Object returnValue(){
            return returnValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static java.lang.Object returnValue_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#waitForFinished">QRemoteObjectPendingCall::waitForFinished(int)</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean waitForFinished(int timeout){
            return waitForFinished_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
        }
        
        private native static boolean waitForFinished_native_int(long __this__nativeId, int timeout);
        
        private native static io.qt.remoteobjects.QRemoteObjectPendingCall fromCompletedCall(java.lang.Object returnValue);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public Impl clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native Impl clone_native(long __this_nativeId);
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#error">QRemoteObjectPendingCall::error()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default io.qt.remoteobjects.QRemoteObjectPendingCall.Error error(){
        return io.qt.remoteobjects.QRemoteObjectPendingCall.Error.resolve(Impl.error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#isFinished">QRemoteObjectPendingCall::isFinished()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default boolean isFinished(){
        return Impl.isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#returnValue">QRemoteObjectPendingCall::returnValue()const</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default java.lang.Object returnValue(){
        return Impl.returnValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#waitForFinished">QRemoteObjectPendingCall::waitForFinished(int)</a></p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default boolean waitForFinished(int timeout){
        return Impl.waitForFinished_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    public static io.qt.remoteobjects.QRemoteObjectPendingCall fromCompletedCall(java.lang.Object returnValue){
        return Impl.fromCompletedCall(returnValue);
    }
    
    /**
     * <p>Overloaded function for {@link #waitForFinished(int)}
     *  with <code>timeout = 30000</code>.</p>
     */
    @io.qt.QtDeclaredFinal
    @io.qt.QtUninvokable
    public default void waitForFinished() {
        waitForFinished((int)30000);
    }
}
