package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>A class holding information about Source objects available on the Qt Remote Objects network</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qremoteobjectregistry.html">QRemoteObjectRegistry</a></p>
 */
public final class QRemoteObjectRegistry extends io.qt.remoteobjects.QRemoteObjectReplica
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRemoteObjectRegistry.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectregistry.html#remoteObjectAdded">QRemoteObjectRegistry::remoteObjectAdded(QRemoteObjectSourceLocation)</a></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QPair<java.lang.@NonNull String, io.qt.remoteobjects.@NonNull QRemoteObjectSourceLocationInfo>> remoteObjectAdded = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectregistry.html#remoteObjectRemoved">QRemoteObjectRegistry::remoteObjectRemoved(QRemoteObjectSourceLocation)</a></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QPair<java.lang.@NonNull String, io.qt.remoteobjects.@NonNull QRemoteObjectSourceLocationInfo>> remoteObjectRemoved = new Signal1<>();
    
    /**
     * <p>Set of sources known to the registry</p>
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectregistry.html#sourceLocations-prop">QRemoteObjectRegistry::bindableSourceLocations()const</a></p>
     */
    @QtPropertyBindable(name="sourceLocations")
    @QtUninvokable
    public final io.qt.core.@NonNull QBindable<java.util.@NonNull Map<java.lang.@NonNull String, io.qt.remoteobjects.@NonNull QRemoteObjectSourceLocationInfo>> bindableSourceLocations(){
        return bindableSourceLocations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QBindable<java.util.Map<java.lang.String, io.qt.remoteobjects.QRemoteObjectSourceLocationInfo>> bindableSourceLocations_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sourceLocations()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QHash<java.lang.@NonNull String, io.qt.remoteobjects.@NonNull QRemoteObjectSourceLocationInfo> getSourceLocations() {
        return sourceLocations();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectregistry.html#sourceLocations">QRemoteObjectRegistry::sourceLocations()const</a></p>
     */
    @QtPropertyReader(name="sourceLocations")
    @QtPropertyStored("false")
    @QtUninvokable
    public final io.qt.core.@NonNull QHash<java.lang.@NonNull String, io.qt.remoteobjects.@NonNull QRemoteObjectSourceLocationInfo> sourceLocations(){
        return sourceLocations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QHash<java.lang.String, io.qt.remoteobjects.QRemoteObjectSourceLocationInfo> sourceLocations_native_constfct(long __this__nativeId);
    
    public native static void registerMetatypes();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QRemoteObjectRegistry(QPrivateConstructor p) { super(p); } 
    
}
