package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>Encapsulates the result of an asynchronous method call</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html">QRemoteObjectPendingCall</a></p>
 */
public interface QRemoteObjectPendingCall extends QtObjectInterface
{
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#Error-enum">QRemoteObjectPendingCall::Error</a></p>
     */
    public enum Error implements QtEnumerator {
        NoError(0),
        InvalidMessage(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return InvalidMessage;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Implementor class for interface {@link io.qt.remoteobjects.QRemoteObjectPendingCall}</p>
     */
    public static class Impl extends QtObject
        implements io.qt.remoteobjects.QRemoteObjectPendingCall,
                java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QRemoteObjectPendingCall instance);
        
        public Impl(io.qt.remoteobjects.@NonNull QRemoteObjectPendingCall other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(QRemoteObjectPendingCall instance, io.qt.remoteobjects.QRemoteObjectPendingCall other);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#error">QRemoteObjectPendingCall::error()const</a></p>
         */
        @QtUninvokable
        public final io.qt.remoteobjects.QRemoteObjectPendingCall.@NonNull Error error(){
            return io.qt.remoteobjects.QRemoteObjectPendingCall.Error.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        private native static int error_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#isFinished">QRemoteObjectPendingCall::isFinished()const</a></p>
         */
        @QtUninvokable
        public final boolean isFinished(){
            return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static boolean isFinished_native_constfct(long __this__nativeId);
        
        @QtUninvokable
        public final void assign(io.qt.remoteobjects.@NonNull QRemoteObjectPendingCall other){
            assign_native_cref_QRemoteObjectPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        }
        
        private native static void assign_native_cref_QRemoteObjectPendingCall(long __this__nativeId, long other);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#returnValue">QRemoteObjectPendingCall::returnValue()const</a></p>
         */
        @QtUninvokable
        public final java.lang.Object returnValue(){
            return returnValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        private native static java.lang.Object returnValue_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#waitForFinished">QRemoteObjectPendingCall::waitForFinished(int)</a></p>
         */
        @QtUninvokable
        public final boolean waitForFinished(int timeout){
            return waitForFinished_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
        }
        
        private native static boolean waitForFinished_native_int(long __this__nativeId, int timeout);
        
        private native static io.qt.remoteobjects.@NonNull QRemoteObjectPendingCall fromCompletedCall(java.lang.Object returnValue);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
        
        @QtUninvokable
        @Override
        public Impl clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native Impl clone_native(long __this_nativeId);
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#error">QRemoteObjectPendingCall::error()const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default io.qt.remoteobjects.QRemoteObjectPendingCall.@NonNull Error error(){
        return io.qt.remoteobjects.QRemoteObjectPendingCall.Error.resolve(Impl.error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#isFinished">QRemoteObjectPendingCall::isFinished()const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default boolean isFinished(){
        return Impl.isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtDeclaredFinal
    @QtUninvokable
    public default void assign(io.qt.remoteobjects.@NonNull QRemoteObjectPendingCall other){
        Impl.assign_native_cref_QRemoteObjectPendingCall(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#returnValue">QRemoteObjectPendingCall::returnValue()const</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default java.lang.Object returnValue(){
        return Impl.returnValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qremoteobjectpendingcall.html#waitForFinished">QRemoteObjectPendingCall::waitForFinished(int)</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default boolean waitForFinished(int timeout){
        return Impl.waitForFinished_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    public static io.qt.remoteobjects.@NonNull QRemoteObjectPendingCall fromCompletedCall(java.lang.Object returnValue){
        return Impl.fromCompletedCall(returnValue);
    }
    
    /**
     * <p>Overloaded function for {@link #waitForFinished(int)}
     *  with <code>timeout = 30000</code>.</p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public default void waitForFinished() {
        waitForFinished((int)30000);
    }
}
