package io.qt.remoteobjects;


/**
 * <p>A node on a Qt Remote Objects network</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html">QRemoteObjectNode</a></p>
 */
public class QRemoteObjectNode extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcPersistedStore = null;
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcHostSideConnection;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRemoteObjectNode.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#ErrorCode-enum">QRemoteObjectNode::ErrorCode</a></p>
     */
    public enum ErrorCode implements io.qt.QtEnumerator {
        NoError(0),
        RegistryNotAcquired(1),
        RegistryAlreadyHosted(2),
        NodeIsNoServer(3),
        ServerAlreadyCreated(4),
        UnintendedRegistryHosting(5),
        OperationNotValidOnClientNode(6),
        SourceNotRegistered(7),
        MissingObjectName(8),
        HostUrlInvalid(9),
        ProtocolMismatch(10),
        ListenFailed(11);

        private ErrorCode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ErrorCode resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return RegistryNotAcquired;
            case 2: return RegistryAlreadyHosted;
            case 3: return NodeIsNoServer;
            case 4: return ServerAlreadyCreated;
            case 5: return UnintendedRegistryHosting;
            case 6: return OperationNotValidOnClientNode;
            case 7: return SourceNotRegistered;
            case 8: return MissingObjectName;
            case 9: return HostUrlInvalid;
            case 10: return ProtocolMismatch;
            case 11: return ListenFailed;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt function pointer <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#RemoteObjectSchemaHandler-typedef">QRemoteObjectNode::RemoteObjectSchemaHandler</a></p>
     */
    @FunctionalInterface
    public interface RemoteObjectSchemaHandler extends io.qt.QtObjectInterface, java.util.function.Consumer<io.qt.core.QUrl> {

        @Override
        public void accept(io.qt.core.QUrl arg__1);

        /**
         * <p>Implementor class for interface {@link RemoteObjectSchemaHandler}</p>
         */
        public static abstract class Impl extends io.qt.QtObject implements RemoteObjectSchemaHandler{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(RemoteObjectSchemaHandler instance);

            @io.qt.NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public void accept(io.qt.core.QUrl arg__1){
                    accept_native(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
                }

                private native void accept_native(long arg__1);
            }

        }
    }


    public final Signal1<io.qt.remoteobjects.QRemoteObjectNode.ErrorCode> error = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#heartbeatInterval-prop">QRemoteObjectNode::heartbeatIntervalChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="heartbeatInterval")
    public final Signal1<@io.qt.QtPrimitiveType Integer> heartbeatIntervalChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#remoteObjectAdded">QRemoteObjectNode::remoteObjectAdded(QRemoteObjectSourceLocation)</a></p>
     */
    public final Signal1<io.qt.core.QPair<java.lang.String, io.qt.remoteobjects.QRemoteObjectSourceLocationInfo>> remoteObjectAdded = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#remoteObjectRemoved">QRemoteObjectNode::remoteObjectRemoved(QRemoteObjectSourceLocation)</a></p>
     */
    public final Signal1<io.qt.core.QPair<java.lang.String, io.qt.remoteobjects.QRemoteObjectSourceLocationInfo>> remoteObjectRemoved = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectNode(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRemoteObjectNode() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#QRemoteObjectNode">QRemoteObjectNode::QRemoteObjectNode(QObject*)</a></p>
     */
    public QRemoteObjectNode(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRemoteObjectNode instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectNode(io.qt.core.QUrl, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRemoteObjectNode(io.qt.core.QUrl registryAddress) {
        this(registryAddress, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#QRemoteObjectNode-1">QRemoteObjectNode::QRemoteObjectNode(QUrl,QObject*)</a></p>
     */
    public QRemoteObjectNode(io.qt.core.QUrl registryAddress, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, registryAddress, parent);
    }
    
    private native static void initialize_native(QRemoteObjectNode instance, io.qt.core.QUrl registryAddress, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#acquireDynamic">QRemoteObjectNode::acquireDynamic(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.remoteobjects.QRemoteObjectDynamicReplica acquireDynamic(java.lang.String name){
        return acquireDynamic_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectDynamicReplica acquireDynamic_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>Overloaded function for {@link #acquireModel(java.lang.String, io.qt.remoteobjects.QtRemoteObjects.InitialAction, java.util.Collection)}
     *  with <code>rolesHint = new java.util.ArrayList&lt;&gt;()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.remoteobjects.QAbstractItemModelReplica acquireModel(java.lang.String name, io.qt.remoteobjects.QtRemoteObjects.InitialAction action) {
        return acquireModel(name, action, new java.util.ArrayList<>());
    }
    
    /**
     * <p>Overloaded function for {@link #acquireModel(java.lang.String, io.qt.remoteobjects.QtRemoteObjects.InitialAction, java.util.Collection)}</p>
     * <p>with: </p><ul>
     * <li><code>action = io.qt.remoteobjects.QtRemoteObjects.InitialAction.FetchRootSize</code></li>
     * <li><code>rolesHint = new java.util.ArrayList&lt;&gt;()</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.remoteobjects.QAbstractItemModelReplica acquireModel(java.lang.String name) {
        return acquireModel(name, io.qt.remoteobjects.QtRemoteObjects.InitialAction.FetchRootSize, new java.util.ArrayList<>());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#acquireModel">QRemoteObjectNode::acquireModel(QString,QtRemoteObjects::InitialAction,QVector&lt;int&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.remoteobjects.QAbstractItemModelReplica acquireModel(java.lang.String name, io.qt.remoteobjects.QtRemoteObjects.InitialAction action, java.util.Collection<java.lang.Integer> rolesHint){
        return acquireModel_native_cref_QString_QtRemoteObjects_InitialAction_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), name, action.value(), rolesHint);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.remoteobjects.QAbstractItemModelReplica acquireModel_native_cref_QString_QtRemoteObjects_InitialAction_cref_QVector(long __this__nativeId, java.lang.String name, int action, java.util.Collection<java.lang.Integer> rolesHint);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#addClientSideConnection">QRemoteObjectNode::addClientSideConnection(QIODevice*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addClientSideConnection(io.qt.core.QIODevice ioDevice){
        addClientSideConnection_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ioDevice));
        if (ioDevice != null) {
            if(__rcHostSideConnection==null)
                __rcHostSideConnection = QtJambi_LibraryUtilities.internal.newRCList();
            __rcHostSideConnection.add(ioDevice);
        }
    }
    
    @io.qt.QtUninvokable
    private native void addClientSideConnection_native_QIODevice_ptr(long __this__nativeId, long ioDevice);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#connectToNode">QRemoteObjectNode::connectToNode(QUrl)</a></p>
     */
    public final boolean connectToNode(io.qt.core.QUrl address){
        return connectToNode_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(address));
    }
    
    private native boolean connectToNode_native_cref_QUrl(long __this__nativeId, long address);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#heartbeatInterval-prop">QRemoteObjectNode::heartbeatInterval()const</a></p>
     */
    @io.qt.QtPropertyReader(name="heartbeatInterval")
    @io.qt.QtUninvokable
    public final int heartbeatInterval(){
        return heartbeatInterval_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int heartbeatInterval_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#instances-1">QRemoteObjectNode::instances(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList instances(java.lang.String typeName){
        return instances_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), typeName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList instances_native_cref_QString_constfct(long __this__nativeId, java.lang.String typeName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#lastError">QRemoteObjectNode::lastError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.remoteobjects.QRemoteObjectNode.ErrorCode lastError(){
        return io.qt.remoteobjects.QRemoteObjectNode.ErrorCode.resolve(lastError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int lastError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#persistedStore-prop">QRemoteObjectNode::persistedStore()const</a></p>
     */
    @io.qt.QtPropertyReader(name="persistedStore")
    @io.qt.QtUninvokable
    public final io.qt.remoteobjects.QRemoteObjectAbstractPersistedStore persistedStore(){
        return persistedStore_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectAbstractPersistedStore persistedStore_native_constfct(long __this__nativeId);
    
    /**
     * <p>Provide a custom method to handle externally provided schemas</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#registerExternalSchema">QRemoteObjectNode::registerExternalSchema(QString,QRemoteObjectNode::RemoteObjectSchemaHandler)</a></p>
     */
    @io.qt.QtUninvokable
    public final void registerExternalSchema(java.lang.String schema, io.qt.remoteobjects.QRemoteObjectNode.RemoteObjectSchemaHandler handler){
        registerExternalSchema_native_cref_QString_QRemoteObjectNode_RemoteObjectSchemaHandler(QtJambi_LibraryUtilities.internal.nativeId(this), schema, handler);
    }
    
    @io.qt.QtUninvokable
    private native void registerExternalSchema_native_cref_QString_QRemoteObjectNode_RemoteObjectSchemaHandler(long __this__nativeId, java.lang.String schema, io.qt.remoteobjects.QRemoteObjectNode.RemoteObjectSchemaHandler handler);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#registry">QRemoteObjectNode::registry()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.remoteobjects.QRemoteObjectRegistry registry(){
        return registry_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectRegistry registry_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#registryUrl-prop">QRemoteObjectNode::registryUrl()const</a></p>
     */
    @io.qt.QtPropertyReader(name="registryUrl")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl registryUrl(){
        return registryUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl registryUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#heartbeatInterval-prop">QRemoteObjectNode::setHeartbeatInterval(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="heartbeatInterval")
    @io.qt.QtUninvokable
    public final void setHeartbeatInterval(int interval){
        setHeartbeatInterval_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), interval);
    }
    
    @io.qt.QtUninvokable
    private native void setHeartbeatInterval_native_int(long __this__nativeId, int interval);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#persistedStore-prop">QRemoteObjectNode::setPersistedStore(QRemoteObjectAbstractPersistedStore*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="persistedStore")
    @io.qt.QtUninvokable
    public final void setPersistedStore(io.qt.remoteobjects.QRemoteObjectAbstractPersistedStore persistedStore){
        setPersistedStore_native_QRemoteObjectAbstractPersistedStore_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(persistedStore));
        __rcPersistedStore = persistedStore;
    }
    
    @io.qt.QtUninvokable
    private native void setPersistedStore_native_QRemoteObjectAbstractPersistedStore_ptr(long __this__nativeId, long persistedStore);
    
    /**
     * <p>Overloaded function for {@link #waitForRegistry(int)}
     *  with <code>timeout = 30000</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean waitForRegistry() {
        return waitForRegistry((int)30000);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#waitForRegistry">QRemoteObjectNode::waitForRegistry(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean waitForRegistry(int timeout){
        return waitForRegistry_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    @io.qt.QtUninvokable
    private native boolean waitForRegistry_native_int(long __this__nativeId, int timeout);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#setName">QRemoteObjectNode::setName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#registryUrl-prop">QRemoteObjectNode::setRegistryUrl(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="registryUrl")
    @io.qt.QtUninvokable
    public boolean setRegistryUrl(io.qt.core.QUrl registryAddress){
        return setRegistryUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(registryAddress));
    }
    
    @io.qt.QtUninvokable
    private native boolean setRegistryUrl_native_cref_QUrl(long __this__nativeId, long registryAddress);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#timerEvent">QObject::timerEvent(QTimerEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void timerEvent(io.qt.core.QTimerEvent arg__1){
        timerEvent_native_QTimerEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void timerEvent_native_QTimerEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QRemoteObjectNode(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QRemoteObjectNode(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QRemoteObjectNode instance, QDeclarativeConstructor constructor);
    
    /**
     * <p>Overloaded function for {@link #acquireModel(java.lang.String, io.qt.remoteobjects.QtRemoteObjects.InitialAction, java.util.Collection)}</p>
     * <p>with: </p><ul>
     * <li><code>action = io.qt.remoteobjects.QtRemoteObjects.InitialAction.FetchRootSize</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.remoteobjects.QAbstractItemModelReplica acquireModel(java.lang.String name, int...rolesHint) {
        return acquireModel(name, io.qt.remoteobjects.QtRemoteObjects.InitialAction.FetchRootSize, rolesHint);
    }
    
    /**
     * <p>Overloaded function for {@link #acquireModel(java.lang.String, io.qt.remoteobjects.QtRemoteObjects.InitialAction, java.util.Collection)}.
     */
    @io.qt.QtUninvokable
    public final io.qt.remoteobjects.QAbstractItemModelReplica acquireModel(java.lang.String name, io.qt.remoteobjects.QtRemoteObjects.InitialAction action, int...rolesHint) {
        java.util.List<Integer> _rolesHint = new java.util.ArrayList<>();
        for (int hint : rolesHint) {
            _rolesHint.add(hint);
        }
        return acquireModel(name, action, _rolesHint);
    }
    
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList instances(Class<? extends io.qt.core.QObject> type){
        for(io.qt.core.QPair<String, String> info : io.qt.core.QMetaObject.forType(type).classInfos()) {
            if("RemoteObject Type".equals(info.first)) {
                return instances(info.second);
            }
        }
        return new io.qt.core.QStringList();
    }
    
    @io.qt.QtUninvokable
    public final <T extends QRemoteObjectReplica> T acquire(java.util.function.BiFunction<QRemoteObjectNode, String, T> replicaConstructor) {
        return acquire(replicaConstructor, null);
    }
    
    @io.qt.QtUninvokable
    public final <T extends QRemoteObjectReplica> T acquire(java.util.function.BiFunction<QRemoteObjectNode, String, T> replicaConstructor, String name) {
        return replicaConstructor.apply(this, name);
    }
    
    @io.qt.QtUninvokable
    public final <T extends QRemoteObjectReplica> T acquire(Class<T> type) throws NoSuchMethodException{
        return acquire(type, null);
    }
    
    @io.qt.QtUninvokable
    public final <T extends QRemoteObjectReplica> T acquire(Class<T> type, java.lang.String name) throws NoSuchMethodException{
        if(type==QRemoteObjectDynamicReplica.class) {
            return type.cast(acquireDynamic(name));
        }
        java.lang.reflect.Constructor<T> constructor = type.getConstructor(QRemoteObjectNode.class, String.class);
        try {
            return constructor.newInstance(this, name);
        } catch (InstantiationException | IllegalAccessException | IllegalArgumentException e) {
            return acquire(type, constructor, name);
        } catch (java.lang.reflect.InvocationTargetException e) {
            if(e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }else if(e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
    }
    private native final <T extends QRemoteObjectReplica> T acquire(Class<T> type, java.lang.reflect.Constructor<T> constructor, java.lang.String name);
}
