package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>Base functionality common to Host and RegistryHost classes</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html">QRemoteObjectHostBase</a></code></p>
 */
public class QRemoteObjectHostBase extends io.qt.remoteobjects.QRemoteObjectNode
{
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcHostSideConnection;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRemoteObjectHostBase.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html#AllowedSchemas-enum">QRemoteObjectHostBase::AllowedSchemas</a></code></p>
     */
    public enum AllowedSchemas implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html#AllowedSchemas-enum">QRemoteObjectHostBase::<wbr/>BuiltInSchemasOnly</a></code></p>
         */
        BuiltInSchemasOnly(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html#AllowedSchemas-enum">QRemoteObjectHostBase::<wbr/>AllowExternalRegistration</a></code></p>
         */
        AllowExternalRegistration(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AllowedSchemas(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AllowedSchemas resolve(int value) {
            switch (value) {
            case 0: return BuiltInSchemasOnly;
            case 1: return AllowExternalRegistration;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt callable <code>QRemoteObjectHostBase::RemoteObjectNameFilter</code></p>
     */
    @FunctionalInterface
    public interface RemoteObjectNameFilter extends QtObjectInterface, java.util.function.BiPredicate<java.lang.@NonNull String, java.lang.@NonNull String> {

        @Override
        public boolean test(java.lang.@NonNull String arg__1, java.lang.@NonNull String arg__2);

        /**
         * @hidden
         * <p>Implementor class for interface {@link RemoteObjectNameFilter}</p>
         */
        public static abstract class Impl extends QtObject implements RemoteObjectNameFilter{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(RemoteObjectNameFilter instance);

            @NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public native boolean test(java.lang.@NonNull String arg__1, java.lang.@NonNull String arg__2);
            }

        }
    }

    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html#addHostSideConnection">QRemoteObjectHostBase::<wbr/>addHostSideConnection(QIODevice*)</a></code></p>
     */
    @QtUninvokable
    public final void addHostSideConnection(io.qt.core.@Nullable QIODevice ioDevice){
        addHostSideConnection_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ioDevice));
        if (ioDevice != null) {
            if(__rcHostSideConnection==null)
                __rcHostSideConnection = QtJambi_LibraryUtilities.internal.newRCList();
            __rcHostSideConnection.add(ioDevice);
        }
    }
    
    @QtUninvokable
    private native void addHostSideConnection_native_QIODevice_ptr(long __this__nativeId, long ioDevice);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html#disableRemoting">QRemoteObjectHostBase::<wbr/>disableRemoting(QObject*)</a></code></p>
     */
    public final boolean disableRemoting(io.qt.core.@Nullable QObject remoteObject){
        return disableRemoting_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(remoteObject));
    }
    
    private native boolean disableRemoting_native_QObject_ptr(long __this__nativeId, long remoteObject);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html#enableRemoting-2">QRemoteObjectHostBase::<wbr/>enableRemoting(QAbstractItemModel*,<wbr/>QString,<wbr/>QVector&lt;int&gt;,<wbr/>QItemSelectionModel*)</a></code></p>
     */
    @QtUninvokable
    public final boolean enableRemoting(io.qt.core.@Nullable QAbstractItemModel model, java.lang.@NonNull String name, java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> roles, io.qt.core.@Nullable QItemSelectionModel selectionModel){
        return enableRemoting_native_QAbstractItemModel_ptr_cref_QString_const_QVector_QItemSelectionModel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(model), name, roles, QtJambi_LibraryUtilities.internal.checkedNativeId(selectionModel));
    }
    
    @QtUninvokable
    private native boolean enableRemoting_native_QAbstractItemModel_ptr_cref_QString_const_QVector_QItemSelectionModel_ptr(long __this__nativeId, long model, java.lang.String name, java.util.Collection<java.lang.@QtPrimitiveType Integer> roles, long selectionModel);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html#enableRemoting-1">QRemoteObjectHostBase::<wbr/>enableRemoting(QObject*,<wbr/>QString)</a></code></p>
     */
    public final boolean enableRemoting(io.qt.core.@Nullable QObject object, java.lang.@NonNull String name){
        return enableRemoting_native_QObject_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), name);
    }
    
    private native boolean enableRemoting_native_QObject_ptr_cref_QString(long __this__nativeId, long object, java.lang.String name);
    
    /**
     * <p>Forward Remote Objects from another network</p>
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html#proxy">QRemoteObjectHostBase::<wbr/>proxy(QUrl,<wbr/>QUrl,<wbr/>QRemoteObjectHostBase::RemoteObjectNameFilter)</a></code></p>
     */
    @QtUninvokable
    public final boolean proxy(io.qt.core.@NonNull QUrl registryUrl, io.qt.core.@NonNull QUrl hostUrl, io.qt.remoteobjects.QRemoteObjectHostBase.@Nullable RemoteObjectNameFilter filter){
        return proxy_native_cref_QUrl_cref_QUrl_QRemoteObjectHostBase_RemoteObjectNameFilter(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(registryUrl), QtJambi_LibraryUtilities.internal.checkedNativeId(hostUrl), filter);
    }
    
    @QtUninvokable
    private native boolean proxy_native_cref_QUrl_cref_QUrl_QRemoteObjectHostBase_RemoteObjectNameFilter(long __this__nativeId, long registryUrl, long hostUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter filter);
    
    /**
     * <p>Forwards remote objects to another network</p>
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthostbase.html#reverseProxy">QRemoteObjectHostBase::<wbr/>reverseProxy(QRemoteObjectHostBase::RemoteObjectNameFilter)</a></code></p>
     */
    @QtUninvokable
    public final boolean reverseProxy(io.qt.remoteobjects.QRemoteObjectHostBase.@Nullable RemoteObjectNameFilter filter){
        return reverseProxy_native_QRemoteObjectHostBase_RemoteObjectNameFilter(QtJambi_LibraryUtilities.internal.nativeId(this), filter);
    }
    
    @QtUninvokable
    private native boolean reverseProxy_native_QRemoteObjectHostBase_RemoteObjectNameFilter(long __this__nativeId, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter filter);
    
    /**
     * <p>See <code>QRemoteObjectHostBase::<wbr/>hostUrl()const</code></p>
     */
    @QtUninvokable
    protected io.qt.core.@NonNull QUrl hostUrl(){
        return hostUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl hostUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QRemoteObjectHostBase::<wbr/>setHostUrl(QUrl,<wbr/>QRemoteObjectHostBase::AllowedSchemas)</code></p>
     */
    @QtUninvokable
    protected boolean setHostUrl(io.qt.core.@NonNull QUrl hostAddress, io.qt.remoteobjects.QRemoteObjectHostBase.@NonNull AllowedSchemas allowedSchemas){
        return setHostUrl_native_cref_QUrl_QRemoteObjectHostBase_AllowedSchemas(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(hostAddress), allowedSchemas.value());
    }
    
    @QtUninvokable
    private native boolean setHostUrl_native_cref_QUrl_QRemoteObjectHostBase_AllowedSchemas(long __this__nativeId, long hostAddress, int allowedSchemas);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#setName">QRemoteObjectNode::<wbr/>setName(QString)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRemoteObjectHostBase(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #enableRemoting(io.qt.core.QAbstractItemModel, java.lang.String, java.util.Collection, io.qt.core.QItemSelectionModel)}
     *  with <code>selectionModel = null</code>.</p>
     */
    @QtUninvokable
    public final boolean enableRemoting(io.qt.core.@Nullable QAbstractItemModel model, java.lang.@NonNull String name, java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> roles) {
        return enableRemoting(model, name, roles, (io.qt.core.QItemSelectionModel)null);
    }
    
    /**
     * <p>Overloaded function for {@link #enableRemoting(io.qt.core.QObject, java.lang.String)}
     *  with <code>name = (String)null</code>.</p>
     */
    public final boolean enableRemoting(io.qt.core.@Nullable QObject object) {
        return enableRemoting(object, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}
     *  with <code>filter = (a,b)-&gt;true</code>.</p>
     */
    @QtUninvokable
    public final boolean proxy(io.qt.core.@NonNull QUrl registryUrl, io.qt.core.@NonNull QUrl hostUrl) {
        return proxy(registryUrl, hostUrl, (a,b)->true);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}</p>
     * <p>with: </p><ul>
     * <li><code>hostUrl = new io.qt.core.QUrl()</code></li>
     * <li><code>filter = (a,b)-&gt;true</code></li>
     * </ul>
     */
    @QtUninvokable
    public final boolean proxy(io.qt.core.@NonNull QUrl registryUrl) {
        return proxy(registryUrl, new io.qt.core.QUrl(), (a,b)->true);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(java.lang.String, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}
     *  with <code>filter = (a,b)-&gt;true</code>.</p>
     */
    @QtUninvokable
    public final boolean proxy(java.lang.@NonNull String registryUrl, io.qt.core.@NonNull QUrl hostUrl) {
        return proxy(registryUrl, hostUrl, (a,b)->true);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(java.lang.String, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}</p>
     * <p>with: </p><ul>
     * <li><code>hostUrl = new io.qt.core.QUrl()</code></li>
     * <li><code>filter = (a,b)-&gt;true</code></li>
     * </ul>
     */
    @QtUninvokable
    public final boolean proxy(java.lang.@NonNull String registryUrl) {
        return proxy(registryUrl, new io.qt.core.QUrl(), (a,b)->true);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}.</p>
     */
    @QtUninvokable
    public final boolean proxy(java.lang.@NonNull String registryUrl, io.qt.core.@NonNull QUrl hostUrl, io.qt.remoteobjects.QRemoteObjectHostBase.@Nullable RemoteObjectNameFilter filter) {
        return proxy(new io.qt.core.QUrl(registryUrl), hostUrl, filter);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(io.qt.core.QUrl, java.lang.String, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}
     *  with <code>filter = (a,b)-&gt;true</code>.</p>
     */
    @QtUninvokable
    public final boolean proxy(io.qt.core.@NonNull QUrl registryUrl, java.lang.@NonNull String hostUrl) {
        return proxy(registryUrl, hostUrl, (a,b)->true);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}.</p>
     */
    @QtUninvokable
    public final boolean proxy(io.qt.core.@NonNull QUrl registryUrl, java.lang.@NonNull String hostUrl, io.qt.remoteobjects.QRemoteObjectHostBase.@Nullable RemoteObjectNameFilter filter) {
        return proxy(registryUrl, new io.qt.core.QUrl(hostUrl), filter);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(java.lang.String, java.lang.String, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}
     *  with <code>filter = (a,b)-&gt;true</code>.</p>
     */
    @QtUninvokable
    public final boolean proxy(java.lang.@NonNull String registryUrl, java.lang.@NonNull String hostUrl) {
        return proxy(registryUrl, hostUrl, (a,b)->true);
    }
    
    /**
     * <p>Overloaded function for {@link #proxy(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}.</p>
     */
    @QtUninvokable
    public final boolean proxy(java.lang.@NonNull String registryUrl, java.lang.@NonNull String hostUrl, io.qt.remoteobjects.QRemoteObjectHostBase.@Nullable RemoteObjectNameFilter filter) {
        return proxy(new io.qt.core.QUrl(registryUrl), new io.qt.core.QUrl(hostUrl), filter);
    }
    
    /**
     * <p>Overloaded function for {@link #reverseProxy(io.qt.remoteobjects.QRemoteObjectHostBase.RemoteObjectNameFilter)}
     *  with <code>filter = (a,b)-&gt;true</code>.</p>
     */
    @QtUninvokable
    public final boolean reverseProxy() {
        return reverseProxy((a,b)->true);
    }
    
    /**
     * <p>Overloaded function for {@link #setHostUrl(io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas)}
     *  with <code>allowedSchemas = io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly</code>.</p>
     */
    @QtUninvokable
    protected final boolean setHostUrl(io.qt.core.@NonNull QUrl hostAddress) {
        return setHostUrl(hostAddress, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly);
    }
    
    /**
     * <p>Overloaded function for {@link #setHostUrl(java.lang.String, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas)}
     *  with <code>allowedSchemas = io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly</code>.</p>
     */
    @QtUninvokable
    protected final boolean setHostUrl(java.lang.@NonNull String hostAddress) {
        return setHostUrl(hostAddress, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly);
    }
    
    /**
     * <p>Overloaded function for {@link #setHostUrl(io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas)}.</p>
     */
    @QtUninvokable
    protected final boolean setHostUrl(java.lang.@NonNull String hostAddress, io.qt.remoteobjects.QRemoteObjectHostBase.@NonNull AllowedSchemas allowedSchemas) {
        return setHostUrl(new io.qt.core.QUrl(hostAddress), allowedSchemas);
    }
}
