package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>A class interacting with (but not implementing) a Qt API on the Remote Object network</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html">QRemoteObjectReplica</a></code></p>
 */
public class QRemoteObjectReplica extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcNode = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRemoteObjectReplica.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>QRemoteObjectReplica::ConstructorType</code></p>
     */
    @QtUnlistedEnum
    protected enum ConstructorType implements QtEnumerator {
        /**
         * <p>Representing <code>QRemoteObjectReplica::<wbr>DefaultConstructor</code></p>
         */
        DefaultConstructor(0),
        /**
         * <p>Representing <code>QRemoteObjectReplica::<wbr>ConstructWithNode</code></p>
         */
        ConstructWithNode(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ConstructorType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ConstructorType resolve(int value) {
            switch (value) {
            case 0: return DefaultConstructor;
            case 1: return ConstructWithNode;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#State-enum">QRemoteObjectReplica::State</a></code></p>
     */
    public enum State implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#State-enum">QRemoteObjectReplica::<wbr>Uninitialized</a></code></p>
         */
        Uninitialized(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#State-enum">QRemoteObjectReplica::<wbr>Default</a></code></p>
         */
        Default(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#State-enum">QRemoteObjectReplica::<wbr>Valid</a></code></p>
         */
        Valid(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#State-enum">QRemoteObjectReplica::<wbr>Suspect</a></code></p>
         */
        Suspect(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#State-enum">QRemoteObjectReplica::<wbr>SignatureMismatch</a></code></p>
         */
        SignatureMismatch(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private State(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull State resolve(int value) {
            switch (value) {
            case 0: return Uninitialized;
            case 1: return Default;
            case 2: return Valid;
            case 3: return Suspect;
            case 4: return SignatureMismatch;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#initialized">QRemoteObjectReplica::<wbr>initialized()</a></code></p>
     */
    public final @NonNull Signal0 initialized = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#notified">QRemoteObjectReplica::<wbr>notified()</a></code></p>
     */
    public final @NonNull Signal0 notified = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#stateChanged">QRemoteObjectReplica::<wbr>stateChanged(QRemoteObjectReplica::State,<wbr>QRemoteObjectReplica::State)</a></code></p>
     */
    @QtPropertyNotify(name="state")
    public final @NonNull Signal2<io.qt.remoteobjects.QRemoteObjectReplica.@NonNull State, io.qt.remoteobjects.QRemoteObjectReplica.@NonNull State> stateChanged = new Signal2<>();
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>QRemoteObjectReplica(QRemoteObjectReplica::ConstructorType)</code></p>
     */
    protected QRemoteObjectReplica(io.qt.remoteobjects.QRemoteObjectReplica.@NonNull ConstructorType t){
        super((QPrivateConstructor)null);
        initialize_native(this, t);
    }
    
    private native static void initialize_native(QRemoteObjectReplica instance, io.qt.remoteobjects.QRemoteObjectReplica.ConstructorType t);
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>initializeNode(QRemoteObjectNode*,<wbr>QString)</code></p>
     */
    @QtUninvokable
    protected final void initializeNode(io.qt.remoteobjects.@Nullable QRemoteObjectNode node, java.lang.@NonNull String name){
        initializeNode_native_QRemoteObjectNode_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node), name);
    }
    
    @QtUninvokable
    private native void initializeNode_native_QRemoteObjectNode_ptr_cref_QString(long __this__nativeId, long node, java.lang.String name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#isInitialized">QRemoteObjectReplica::<wbr>isInitialized()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isInitialized(){
        return isInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isInitialized_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#isReplicaValid">QRemoteObjectReplica::<wbr>isReplicaValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isReplicaValid(){
        return isReplicaValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isReplicaValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#node-prop">QRemoteObjectReplica::<wbr>node()const</a></code></p>
     */
    @QtPropertyReader(name="node")
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QRemoteObjectNode node(){
        return node_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectNode node_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>persistProperties(QString,<wbr>QByteArray,<wbr>QVariantList)const</code></p>
     */
    @QtUninvokable
    protected final void persistProperties(java.lang.@NonNull String repName, io.qt.core.@NonNull QByteArray repSig, java.util.@NonNull Collection<? extends java.lang.Object> props){
        persistProperties_native_cref_QString_cref_QByteArray_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), repName, QtJambi_LibraryUtilities.internal.checkedNativeId(repSig), props);
    }
    
    @QtUninvokable
    private native void persistProperties_native_cref_QString_cref_QByteArray_cref_QList_constfct(long __this__nativeId, java.lang.String repName, long repSig, java.util.Collection<? extends java.lang.Object> props);
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>propAsVariant(int)const</code></p>
     */
    @QtUninvokable
    protected final java.lang.Object propAsVariant(int i){
        return propAsVariant_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native java.lang.Object propAsVariant_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>retrieveProperties(QString,<wbr>QByteArray)const</code></p>
     */
    @QtUninvokable
    protected final io.qt.core.@NonNull QList<java.lang.Object> retrieveProperties(java.lang.@NonNull String repName, io.qt.core.@NonNull QByteArray repSig){
        return retrieveProperties_native_cref_QString_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), repName, QtJambi_LibraryUtilities.internal.checkedNativeId(repSig));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.Object> retrieveProperties_native_cref_QString_cref_QByteArray_constfct(long __this__nativeId, java.lang.String repName, long repSig);
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>send(QMetaObject::Call,<wbr>int,<wbr>QVariantList)</code></p>
     */
    @QtUninvokable
    protected final void send(io.qt.core.QMetaObject.@NonNull Call call, int index, java.util.@NonNull Collection<? extends java.lang.Object> args){
        send_native_QMetaObject_Call_int_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), call.value(), index, args);
    }
    
    @QtUninvokable
    private native void send_native_QMetaObject_Call_int_cref_QList(long __this__nativeId, int call, int index, java.util.Collection<? extends java.lang.Object> args);
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>sendWithReply(QMetaObject::Call,<wbr>int,<wbr>QVariantList)</code></p>
     */
    @QtUninvokable
    protected final io.qt.remoteobjects.@NonNull QRemoteObjectPendingCall sendWithReply(io.qt.core.QMetaObject.@NonNull Call call, int index, java.util.@NonNull Collection<? extends java.lang.Object> args){
        return sendWithReply_native_QMetaObject_Call_int_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), call.value(), index, args);
    }
    
    @QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectPendingCall sendWithReply_native_QMetaObject_Call_int_cref_QList(long __this__nativeId, int call, int index, java.util.Collection<? extends java.lang.Object> args);
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>setChild(int,<wbr>QVariant)</code></p>
     */
    @QtUninvokable
    protected final void setChild(int i, java.lang.Object arg__2){
        setChild_native_int_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), i, arg__2);
    }
    
    @QtUninvokable
    private native void setChild_native_int_cref_QVariant(long __this__nativeId, int i, java.lang.Object arg__2);
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>setProperties(QVariantList)</code></p>
     */
    @QtUninvokable
    protected final void setProperties(java.util.@NonNull Collection<? extends java.lang.Object> arg__1){
        setProperties_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setProperties_native_cref_QList(long __this__nativeId, java.util.Collection<? extends java.lang.Object> arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#state">QRemoteObjectReplica::<wbr>state()const</a></code></p>
     */
    @QtPropertyReader(name="state")
    @QtUninvokable
    public final io.qt.remoteobjects.QRemoteObjectReplica.@NonNull State state(){
        return io.qt.remoteobjects.QRemoteObjectReplica.State.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#waitForSource">QRemoteObjectReplica::<wbr>waitForSource(int)</a></code></p>
     */
    @QtUninvokable
    public final boolean waitForSource(int timeout){
        return waitForSource_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    @QtUninvokable
    private native boolean waitForSource_native_int(long __this__nativeId, int timeout);
    
    /**
     * <p>See <code>QRemoteObjectReplica::<wbr>initialize()</code></p>
     */
    @QtUninvokable
    protected void initialize(){
        initialize_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void initialize_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#node-prop">QRemoteObjectReplica::<wbr>setNode(QRemoteObjectNode*)</a></code></p>
     */
    @QtPropertyWriter(name="node")
    @QtUninvokable
    public void setNode(io.qt.remoteobjects.@Nullable QRemoteObjectNode node){
        setNode_native_QRemoteObjectNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node));
        __rcNode = node;
    }
    
    @QtUninvokable
    private native void setNode_native_QRemoteObjectNode_ptr(long __this__nativeId, long node);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRemoteObjectReplica(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRemoteObjectReplica(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRemoteObjectReplica instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectReplica(io.qt.remoteobjects.QRemoteObjectReplica.ConstructorType)}
     *  with <code>t = io.qt.remoteobjects.QRemoteObjectReplica.ConstructorType.DefaultConstructor</code>.</p>
     */
    protected QRemoteObjectReplica() {
        this(io.qt.remoteobjects.QRemoteObjectReplica.ConstructorType.DefaultConstructor);
    }
    
    /**
     * <p>Overloaded function for {@link #initializeNode(io.qt.remoteobjects.QRemoteObjectNode, java.lang.String)}
     *  with <code>name = (String)null</code>.</p>
     */
    @QtUninvokable
    protected final void initializeNode(io.qt.remoteobjects.@Nullable QRemoteObjectNode node) {
        initializeNode(node, (String)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #node()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QRemoteObjectNode getNode() {
        return node();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #state()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.remoteobjects.QRemoteObjectReplica.@NonNull State getState() {
        return state();
    }
    
    /**
     * <p>Overloaded function for {@link #waitForSource(int)}
     *  with <code>timeout = 30000</code>.</p>
     */
    @QtUninvokable
    public final boolean waitForSource() {
        return waitForSource((int)30000);
    }
}
