package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>A (Host/Registry) node on a Qt Remote Objects network</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qremoteobjectregistryhost.html">QRemoteObjectRegistryHost</a></code></p>
 */
public class QRemoteObjectRegistryHost extends io.qt.remoteobjects.QRemoteObjectHostBase
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRemoteObjectRegistryHost.class);
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectregistryhost.html#QRemoteObjectRegistryHost">QRemoteObjectRegistryHost::<wbr>QRemoteObjectRegistryHost(QUrl,<wbr>QObject*)</a></code></p>
     */
    public QRemoteObjectRegistryHost(io.qt.core.@NonNull QUrl registryAddress, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, registryAddress, parent);
    }
    
    private native static void initialize_native(QRemoteObjectRegistryHost instance, io.qt.core.QUrl registryAddress, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjectnode.html#registryUrl-prop">QRemoteObjectNode::<wbr>setRegistryUrl(QUrl)</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean setRegistryUrl(io.qt.core.@NonNull QUrl registryUrl){
        return setRegistryUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(registryUrl));
    }
    
    @QtUninvokable
    private native boolean setRegistryUrl_native_cref_QUrl(long __this__nativeId, long registryUrl);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRemoteObjectRegistryHost(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRemoteObjectRegistryHost(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRemoteObjectRegistryHost instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectRegistryHost(io.qt.core.QUrl, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRemoteObjectRegistryHost(io.qt.core.@NonNull QUrl registryAddress) {
        this(registryAddress, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectRegistryHost(io.qt.core.QUrl, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>registryAddress = new io.qt.core.QUrl()</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QRemoteObjectRegistryHost() {
        this(new io.qt.core.QUrl(), (io.qt.core.QObject)null);
    }
}
