package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>A (Host) Node on a Qt Remote Objects network</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qremoteobjecthost.html">QRemoteObjectHost</a></code></p>
 */
public class QRemoteObjectHost extends io.qt.remoteobjects.QRemoteObjectHostBase
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRemoteObjectHost.class);
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthost.html#hostUrl-prop">QRemoteObjectHost::<wbr>hostUrlChanged()</a></code></p>
     */
    @QtPropertyNotify(name="hostUrl")
    public final @NonNull Signal0 hostUrlChanged = new Signal0();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthost.html#QRemoteObjectHost">QRemoteObjectHost::<wbr>QRemoteObjectHost(QObject*)</a></code></p>
     */
    public QRemoteObjectHost(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRemoteObjectHost instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthost.html#QRemoteObjectHost-2">QRemoteObjectHost::<wbr>QRemoteObjectHost(QUrl,<wbr>QObject*)</a></code></p>
     */
    public QRemoteObjectHost(io.qt.core.@NonNull QUrl address, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, address, parent);
    }
    
    private native static void initialize_native(QRemoteObjectHost instance, io.qt.core.QUrl address, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qremoteobjecthost.html#QRemoteObjectHost-1">QRemoteObjectHost::<wbr>QRemoteObjectHost(QUrl,<wbr>QUrl,<wbr>QRemoteObjectHostBase::AllowedSchemas,<wbr>QObject*)</a></code></p>
     */
    public QRemoteObjectHost(io.qt.core.@NonNull QUrl address, io.qt.core.@NonNull QUrl registryAddress, io.qt.remoteobjects.QRemoteObjectHostBase.@NonNull AllowedSchemas allowedSchemas, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, address, registryAddress, allowedSchemas, parent);
    }
    
    private native static void initialize_native(QRemoteObjectHost instance, io.qt.core.QUrl address, io.qt.core.QUrl registryAddress, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas allowedSchemas, io.qt.core.QObject parent);
    
    /**
     * <p>See <code>QRemoteObjectHostBase::<wbr>hostUrl()const</code></p>
     */
    @QtPropertyReader(name="hostUrl")
    @QtUninvokable
    @Override
    protected io.qt.core.@NonNull QUrl hostUrl(){
        return hostUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl hostUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QRemoteObjectHostBase::<wbr>setHostUrl(QUrl,<wbr>QRemoteObjectHostBase::AllowedSchemas)</code></p>
     */
    @QtPropertyWriter(name="hostUrl")
    @QtUninvokable
    @Override
    protected boolean setHostUrl(io.qt.core.@NonNull QUrl hostAddress, io.qt.remoteobjects.QRemoteObjectHostBase.@NonNull AllowedSchemas allowedSchemas){
        return setHostUrl_native_cref_QUrl_QRemoteObjectHostBase_AllowedSchemas(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(hostAddress), allowedSchemas.value());
    }
    
    @QtUninvokable
    private native boolean setHostUrl_native_cref_QUrl_QRemoteObjectHostBase_AllowedSchemas(long __this__nativeId, long hostAddress, int allowedSchemas);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRemoteObjectHost(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRemoteObjectHost(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRemoteObjectHost instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectHost(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRemoteObjectHost() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectHost(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRemoteObjectHost(io.qt.core.@NonNull QUrl address, io.qt.core.@NonNull QUrl registryAddress, io.qt.remoteobjects.QRemoteObjectHostBase.@NonNull AllowedSchemas allowedSchemas) {
        this(address, registryAddress, allowedSchemas, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectHost(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>allowedSchemas = io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QRemoteObjectHost(io.qt.core.@NonNull QUrl address, io.qt.core.@NonNull QUrl registryAddress) {
        this(address, registryAddress, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QRemoteObjectHost(io.qt.core.QUrl, io.qt.core.QUrl, io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>registryAddress = new io.qt.core.QUrl()</code></li>
     * <li><code>allowedSchemas = io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QRemoteObjectHost(io.qt.core.@NonNull QUrl address) {
        this(address, new io.qt.core.QUrl(), io.qt.remoteobjects.QRemoteObjectHostBase.AllowedSchemas.BuiltInSchemasOnly, (io.qt.core.QObject)null);
    }
}
