package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>Java wrapper for Qt header file <code>QtRemoteObjects</code></p>
 */
public final class QtRemoteObjects
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtRemoteObjects() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtRemoteObjects."); }
    
    /**
     * <p>Java wrapper for Qt enum <code>QtRemoteObjects::InitialAction</code></p>
     */
    public enum InitialAction implements QtEnumerator {
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>FetchRootSize</code></p>
         */
        FetchRootSize(0),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>PrefetchData</code></p>
         */
        PrefetchData(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private InitialAction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull InitialAction resolve(int value) {
            switch (value) {
            case 0: return FetchRootSize;
            case 1: return PrefetchData;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QtRemoteObjects::QRemoteObjectPacketTypeEnum</code></p>
     */
    public enum QRemoteObjectPacketTypeEnum implements QtEnumerator {
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>Invalid</code></p>
         */
        Invalid(0),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>Handshake</code></p>
         */
        Handshake(1),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>InitPacket</code></p>
         */
        InitPacket(2),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>InitDynamicPacket</code></p>
         */
        InitDynamicPacket(3),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>AddObject</code></p>
         */
        AddObject(4),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>RemoveObject</code></p>
         */
        RemoveObject(5),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>InvokePacket</code></p>
         */
        InvokePacket(6),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>InvokeReplyPacket</code></p>
         */
        InvokeReplyPacket(7),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>PropertyChangePacket</code></p>
         */
        PropertyChangePacket(8),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>ObjectList</code></p>
         */
        ObjectList(9),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>Ping</code></p>
         */
        Ping(10),
        /**
         * <p>Representing <code>QtRemoteObjects::<wbr>Pong</code></p>
         */
        Pong(11);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private QRemoteObjectPacketTypeEnum(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull QRemoteObjectPacketTypeEnum resolve(int value) {
            switch (value) {
            case 0: return Invalid;
            case 1: return Handshake;
            case 2: return InitPacket;
            case 3: return InitDynamicPacket;
            case 4: return AddObject;
            case 5: return RemoveObject;
            case 6: return InvokePacket;
            case 7: return InvokeReplyPacket;
            case 8: return PropertyChangePacket;
            case 9: return ObjectList;
            case 10: return Ping;
            case 11: return Pong;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QtRemoteObjects::<wbr>copyStoredProperties(QDataStream&amp;,<wbr>T*)</code></p>
     */
    public static <T> void copyStoredProperties(java.lang.Class<T> type, io.qt.core.@StrictNonNull QDataStream src, T dst){
        java.util.Objects.requireNonNull(src, "Argument 'src': null not expected.");
        copyStoredProperties_native_ref_QDataStream__jobject_ptr(type, QtJambi_LibraryUtilities.internal.checkedNativeId(src), dst);
    }
    
    private native static <T> void copyStoredProperties_native_ref_QDataStream__jobject_ptr(java.lang.Class<T> type, long src, T dst);
    
    /**
     * <p>See <code>QtRemoteObjects::<wbr>copyStoredProperties(const T*,<wbr>QDataStream&amp;)</code></p>
     */
    public static <T> void copyStoredProperties(java.lang.Class<T> type, T src, io.qt.core.@StrictNonNull QDataStream dst){
        java.util.Objects.requireNonNull(dst, "Argument 'dst': null not expected.");
        copyStoredProperties_native_const__jobject_ptr_ref_QDataStream(type, src, QtJambi_LibraryUtilities.internal.checkedNativeId(dst));
    }
    
    private native static <T> void copyStoredProperties_native_const__jobject_ptr_ref_QDataStream(java.lang.Class<T> type, T src, long dst);
    
    /**
     * <p>See <code>QtRemoteObjects::<wbr>copyStoredProperties(const T*,<wbr>T*)</code></p>
     */
    public native static <T> void copyStoredProperties(java.lang.Class<T> type, T src, T dst);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qtroclientfactory.html#qRegisterRemoteObjectsClient">qRegisterRemoteObjectsClient(QString)</a></code></p>
     */
    public native static void qRegisterRemoteObjectsClient(java.lang.@NonNull String id, java.lang.Class<? extends io.qt.remoteobjects.ClientIoDevice> type);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qtroserverfactory.html#qRegisterRemoteObjectsServer">qRegisterRemoteObjectsServer(QString)</a></code></p>
     */
    public native static void qRegisterRemoteObjectsServer(java.lang.@NonNull String id, java.lang.Class<? extends io.qt.remoteobjects.QConnectionAbstractServer> type);
    
    public static class TypeNameAndMetaobject{
        TypeNameAndMetaobject(String typeName, io.qt.core.QMetaObject metaObject) {
            super();
            this.typeName = typeName;
            this.metaObject = metaObject;
        }
        public final java.lang.String typeName;
        public final io.qt.core.QMetaObject metaObject;
    }
    
    @QtUninvokable
    public static TypeNameAndMetaobject getTypeNameAndMetaobjectFromClassInfo(io.qt.core.QMetaObject metaObject){
        String typeName = metaObject.classInfo("RemoteObject Type");
        if (typeName!=null) { //We have an object created from repc or at least with QCLASSINFO defined
            while (metaObject.superClass()!=null) {
                //At the point superclass doesn't have the same QCLASSINFO_REMOTEOBJECT_TYPE,
                //we have the metaobject we should work from
                String _typeName = metaObject.superClass().classInfo("RemoteObject Type");
                if(_typeName!=null) {
                    typeName = _typeName;
                    metaObject = metaObject.superClass();
                }
            }
        }
        return new TypeNameAndMetaobject(typeName, metaObject);
    }
    
    @QtUninvokable
    public static <T> void copyStoredProperties(T src, T dst)
    {
        if(src!=null)QtRemoteObjects.<T>copyStoredProperties(QtJambi_LibraryUtilities.internal.getClass(src), src, dst);
    }
    
    @QtUninvokable
    public static <T> void copyStoredProperties(T src, io.qt.core.QDataStream dst)
    {
        if(src!=null)QtRemoteObjects.<T>copyStoredProperties(QtJambi_LibraryUtilities.internal.getClass(src), src, dst);
    }
    
    @QtUninvokable
    public static <T> void copyStoredProperties(io.qt.core.QDataStream src, T dst)
    {
        if(dst!=null)QtRemoteObjects.<T>copyStoredProperties(QtJambi_LibraryUtilities.internal.getClass(dst), src, dst);
    }
}
