package io.qt.remoteobjects;

import io.qt.*;


/**
 * <p>A class interacting with (but not implementing) a Qt API on the Remote Object network</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html">QRemoteObjectReplica</a></p>
 */
public class QRemoteObjectReplica extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcNode = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRemoteObjectReplica.class);
    
    /**
     * <p>Java wrapper for Qt enum QRemoteObjectReplica::ConstructorType</p>
     */
    @QtUnlistedEnum
    protected enum ConstructorType implements QtEnumerator {
        DefaultConstructor(0),
        ConstructWithNode(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ConstructorType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ConstructorType resolve(int value) {
            switch (value) {
            case 0: return DefaultConstructor;
            case 1: return ConstructWithNode;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#State-enum">QRemoteObjectReplica::State</a></p>
     */
    public enum State implements QtEnumerator {
        Uninitialized(0),
        Default(1),
        Valid(2),
        Suspect(3),
        SignatureMismatch(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private State(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static State resolve(int value) {
            switch (value) {
            case 0: return Uninitialized;
            case 1: return Default;
            case 2: return Valid;
            case 3: return Suspect;
            case 4: return SignatureMismatch;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#initialized">QRemoteObjectReplica::initialized()</a></p>
     */
    public final @NonNull Signal0 initialized = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#notified">QRemoteObjectReplica::notified()</a></p>
     */
    public final @NonNull Signal0 notified = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#stateChanged">QRemoteObjectReplica::stateChanged(QRemoteObjectReplica::State,QRemoteObjectReplica::State)</a></p>
     */
    @QtPropertyNotify(name="state")
    public final @NonNull Signal2<io.qt.remoteobjects.QRemoteObjectReplica.@NonNull State, io.qt.remoteobjects.QRemoteObjectReplica.@NonNull State> stateChanged = new Signal2<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.remoteobjects.QRemoteObjectReplica.ConstructorType)}
     *  with <code>t = io.qt.remoteobjects.QRemoteObjectReplica.ConstructorType.DefaultConstructor</code>.</p>
     */
    protected QRemoteObjectReplica() {
        this(io.qt.remoteobjects.QRemoteObjectReplica.ConstructorType.DefaultConstructor);
    }
    
    protected QRemoteObjectReplica(io.qt.remoteobjects.QRemoteObjectReplica.@NonNull ConstructorType t){
        super((QPrivateConstructor)null);
        initialize_native(this, t);
    }
    
    private native static void initialize_native(QRemoteObjectReplica instance, io.qt.remoteobjects.QRemoteObjectReplica.ConstructorType t);
    
    /**
     * <p>Overloaded function for {@link #initializeNode(io.qt.remoteobjects.QRemoteObjectNode, java.lang.String)}
     *  with <code>name = (String)null</code>.</p>
     */
    @QtUninvokable
    protected final void initializeNode(io.qt.remoteobjects.@Nullable QRemoteObjectNode node) {
        initializeNode(node, (String)null);
    }
    
    @QtUninvokable
    protected final void initializeNode(io.qt.remoteobjects.@Nullable QRemoteObjectNode node, java.lang.@NonNull String name){
        initializeNode_native_QRemoteObjectNode_ptr_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node), name);
    }
    
    @QtUninvokable
    private native void initializeNode_native_QRemoteObjectNode_ptr_cref_QString(long __this__nativeId, long node, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#isInitialized">QRemoteObjectReplica::isInitialized()const</a></p>
     */
    @QtUninvokable
    public final boolean isInitialized(){
        return isInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isInitialized_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#isReplicaValid">QRemoteObjectReplica::isReplicaValid()const</a></p>
     */
    @QtUninvokable
    public final boolean isReplicaValid(){
        return isReplicaValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isReplicaValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #node()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QRemoteObjectNode getNode() {
        return node();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#node-prop">QRemoteObjectReplica::node()const</a></p>
     */
    @QtPropertyReader(name="node")
    @QtUninvokable
    public final io.qt.remoteobjects.@Nullable QRemoteObjectNode node(){
        return node_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectNode node_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    protected final void persistProperties(java.lang.@NonNull String repName, io.qt.core.@NonNull QByteArray repSig, java.util.@NonNull Collection<? extends java.lang.Object> props){
        persistProperties_native_cref_QString_cref_QByteArray_cref_QList_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), repName, QtJambi_LibraryUtilities.internal.checkedNativeId(repSig), props);
    }
    
    @QtUninvokable
    private native void persistProperties_native_cref_QString_cref_QByteArray_cref_QList_constfct(long __this__nativeId, java.lang.String repName, long repSig, java.util.Collection<? extends java.lang.Object> props);
    
    @QtUninvokable
    protected final java.lang.Object propAsVariant(int i){
        return propAsVariant_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native java.lang.Object propAsVariant_native_int_constfct(long __this__nativeId, int i);
    
    @QtUninvokable
    protected final io.qt.core.@NonNull QList<java.lang.Object> retrieveProperties(java.lang.@NonNull String repName, io.qt.core.@NonNull QByteArray repSig){
        return retrieveProperties_native_cref_QString_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), repName, QtJambi_LibraryUtilities.internal.checkedNativeId(repSig));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.Object> retrieveProperties_native_cref_QString_cref_QByteArray_constfct(long __this__nativeId, java.lang.String repName, long repSig);
    
    @QtUninvokable
    protected final void send(io.qt.core.QMetaObject.@NonNull Call call, int index, java.util.@NonNull Collection<? extends java.lang.Object> args){
        send_native_QMetaObject_Call_int_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), call.value(), index, args);
    }
    
    @QtUninvokable
    private native void send_native_QMetaObject_Call_int_cref_QList(long __this__nativeId, int call, int index, java.util.Collection<? extends java.lang.Object> args);
    
    @QtUninvokable
    protected final io.qt.remoteobjects.@NonNull QRemoteObjectPendingCall sendWithReply(io.qt.core.QMetaObject.@NonNull Call call, int index, java.util.@NonNull Collection<? extends java.lang.Object> args){
        return sendWithReply_native_QMetaObject_Call_int_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), call.value(), index, args);
    }
    
    @QtUninvokable
    private native io.qt.remoteobjects.QRemoteObjectPendingCall sendWithReply_native_QMetaObject_Call_int_cref_QList(long __this__nativeId, int call, int index, java.util.Collection<? extends java.lang.Object> args);
    
    @QtUninvokable
    protected final void setChild(int i, java.lang.Object arg__2){
        setChild_native_int_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), i, arg__2);
    }
    
    @QtUninvokable
    private native void setChild_native_int_cref_QVariant(long __this__nativeId, int i, java.lang.Object arg__2);
    
    @QtUninvokable
    protected final void setProperties(java.util.@NonNull Collection<? extends java.lang.Object> arg__1){
        setProperties_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setProperties_native_cref_QList(long __this__nativeId, java.util.Collection<? extends java.lang.Object> arg__1);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #state()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.remoteobjects.QRemoteObjectReplica.@NonNull State getState() {
        return state();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#state">QRemoteObjectReplica::state()const</a></p>
     */
    @QtPropertyReader(name="state")
    @QtUninvokable
    public final io.qt.remoteobjects.QRemoteObjectReplica.@NonNull State state(){
        return io.qt.remoteobjects.QRemoteObjectReplica.State.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #waitForSource(int)}
     *  with <code>timeout = 30000</code>.</p>
     */
    @QtUninvokable
    public final boolean waitForSource() {
        return waitForSource((int)30000);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#waitForSource">QRemoteObjectReplica::waitForSource(int)</a></p>
     */
    @QtUninvokable
    public final boolean waitForSource(int timeout){
        return waitForSource_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    @QtUninvokable
    private native boolean waitForSource_native_int(long __this__nativeId, int timeout);
    
    @QtUninvokable
    protected void initialize(){
        initialize_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void initialize_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qremoteobjectreplica.html#node-prop">QRemoteObjectReplica::setNode(QRemoteObjectNode*)</a></p>
     */
    @QtPropertyWriter(name="node")
    @QtUninvokable
    public void setNode(io.qt.remoteobjects.@Nullable QRemoteObjectNode node){
        setNode_native_QRemoteObjectNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node));
        __rcNode = node;
    }
    
    @QtUninvokable
    private native void setNode_native_QRemoteObjectNode_ptr(long __this__nativeId, long node);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QRemoteObjectReplica(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRemoteObjectReplica(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRemoteObjectReplica instance, QDeclarativeConstructor constructor);
    
}
