package io.qt.remoteobjects;


/**
 * <p>Contains identifiers used in the Remote Objects module, as well as some functions used from code generated by the Replica Compiler (repc)</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qtremoteobjects.html">QtRemoteObjects</a></p>
 */
public final class QtRemoteObjects
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtRemoteObjects() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtRemoteObjects."); }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qtremoteobjects.html#InitialAction-enum">QtRemoteObjects::InitialAction</a></p>
     */
    public enum InitialAction implements io.qt.QtEnumerator {
        FetchRootSize(0),
        PrefetchData(1);

        private InitialAction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static InitialAction resolve(int value) {
            switch (value) {
            case 0: return FetchRootSize;
            case 1: return PrefetchData;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QtRemoteObjects::QRemoteObjectPacketTypeEnum</p>
     */
    public enum QRemoteObjectPacketTypeEnum implements io.qt.QtEnumerator {
        Invalid(0),
        Handshake(1),
        InitPacket(2),
        InitDynamicPacket(3),
        AddObject(4),
        RemoveObject(5),
        InvokePacket(6),
        InvokeReplyPacket(7),
        PropertyChangePacket(8),
        ObjectList(9),
        Ping(10),
        Pong(11);

        private QRemoteObjectPacketTypeEnum(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static QRemoteObjectPacketTypeEnum resolve(int value) {
            switch (value) {
            case 0: return Invalid;
            case 1: return Handshake;
            case 2: return InitPacket;
            case 3: return InitDynamicPacket;
            case 4: return AddObject;
            case 5: return RemoveObject;
            case 6: return InvokePacket;
            case 7: return InvokeReplyPacket;
            case 8: return PropertyChangePacket;
            case 9: return ObjectList;
            case 10: return Ping;
            case 11: return Pong;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public static class TypeNameAndMetaobject{
        TypeNameAndMetaobject(String typeName, io.qt.core.QMetaObject metaObject) {
            super();
            this.typeName = typeName;
            this.metaObject = metaObject;
        }
        public final java.lang.String typeName;
        public final io.qt.core.QMetaObject metaObject;
    }
    
    @io.qt.QtUninvokable
    public static TypeNameAndMetaobject getTypeNameAndMetaobjectFromClassInfo(io.qt.core.QMetaObject metaObject){
        String typeName = metaObject.classInfo("RemoteObject Type");
        if (typeName!=null) { //We have an object created from repc or at least with QCLASSINFO defined
            while (metaObject.superClass()!=null) {
                //At the point superclass doesn't have the same QCLASSINFO_REMOTEOBJECT_TYPE,
                //we have the metaobject we should work from
                String _typeName = metaObject.superClass().classInfo("RemoteObject Type");
                if(_typeName!=null) {
                    typeName = _typeName;
                    metaObject = metaObject.superClass();
                }
            }
        }
        return new TypeNameAndMetaobject(typeName, metaObject);
    }
    
    @io.qt.QtUninvokable
    public static void qRegisterRemoteObjectsServer(java.lang.String id, Class<? extends QConnectionAbstractServer> type){
        try {
            java.lang.reflect.Constructor<?> constructor = type.getConstructor(io.qt.core.QObject.class);
            qRegisterRemoteObjectsServer(id, type, constructor);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
    @io.qt.QtUninvokable
    private static native void qRegisterRemoteObjectsServer(java.lang.String id, Class<? extends QConnectionAbstractServer> type, java.lang.reflect.Constructor<?> constructor);
    
    
    @SuppressWarnings("unchecked")
    @io.qt.QtUninvokable
    public static <T> void copyStoredProperties(T src, T dst)
    {
        if(src!=null)copyStoredProperties((Class<T>)src.getClass(), src, dst);
    }
    
    @SuppressWarnings("unchecked")
    @io.qt.QtUninvokable
    public static <T> void copyStoredProperties(T src, io.qt.core.QDataStream dst)
    {
        if(src!=null)copyStoredProperties((Class<T>)src.getClass(), src, dst);
    }
    
    @SuppressWarnings("unchecked")
    @io.qt.QtUninvokable
    public static <T> void copyStoredProperties(io.qt.core.QDataStream src, T dst)
    {
        if(dst!=null)copyStoredProperties((Class<T>)dst.getClass(), src, dst);
    }
    
    @io.qt.QtUninvokable
    public static <T> void copyStoredProperties(Class<T> type, T src, T dst)
    {
        if(io.qt.core.QObject.class.isAssignableFrom(type))
            throw new IllegalArgumentException("Only gadget types allowed.");
        if(src instanceof io.qt.QtObjectInterface)
            copyStoredProperties(io.qt.core.QMetaObject.forType(type), QtJambi_LibraryUtilities.internal.checkedNativeId((io.qt.QtObjectInterface)src), QtJambi_LibraryUtilities.internal.checkedNativeId((io.qt.QtObjectInterface)dst));
        else
            copyStoredProperties(io.qt.core.QMetaObject.forType(type), src, dst);
    }
    
    @io.qt.QtUninvokable
    public static <T> void copyStoredProperties(Class<T> type, T src, io.qt.core.QDataStream dst)
    {
        java.util.Objects.requireNonNull(dst);
        if(io.qt.core.QObject.class.isAssignableFrom(type))
            throw new IllegalArgumentException("Only gadget types allowed.");
        if(src instanceof io.qt.QtObjectInterface)
            copyStoredPropertiesStreamOut(io.qt.core.QMetaObject.forType(type), QtJambi_LibraryUtilities.internal.checkedNativeId((io.qt.QtObjectInterface)src), QtJambi_LibraryUtilities.internal.checkedNativeId(dst));
        else
            copyStoredPropertiesStreamOut(io.qt.core.QMetaObject.forType(type), src, QtJambi_LibraryUtilities.internal.checkedNativeId(dst));
    }
    
    @io.qt.QtUninvokable
    public static <T> void copyStoredProperties(Class<T> type, io.qt.core.QDataStream src, T dst)
    {
        java.util.Objects.requireNonNull(src);
        if(io.qt.core.QObject.class.isAssignableFrom(type))
            throw new IllegalArgumentException("Only gadget types allowed.");
        if(dst instanceof io.qt.QtObjectInterface)
            copyStoredPropertiesStreamIn(io.qt.core.QMetaObject.forType(type), QtJambi_LibraryUtilities.internal.checkedNativeId(src), QtJambi_LibraryUtilities.internal.checkedNativeId((io.qt.QtObjectInterface)dst));
        else
            copyStoredPropertiesStreamIn(io.qt.core.QMetaObject.forType(type), QtJambi_LibraryUtilities.internal.checkedNativeId(src), dst);
    }
    
    @io.qt.QtUninvokable
    private native static void copyStoredProperties(io.qt.core.QMetaObject type, long src, long dst);
    @io.qt.QtUninvokable
    private native static void copyStoredProperties(io.qt.core.QMetaObject type, Object src, Object dst);
    @io.qt.QtUninvokable
    private native static void copyStoredPropertiesStreamIn(io.qt.core.QMetaObject type, long src, Object dst);
    @io.qt.QtUninvokable
    private native static void copyStoredPropertiesStreamIn(io.qt.core.QMetaObject type, long src, long dst);
    @io.qt.QtUninvokable
    private native static void copyStoredPropertiesStreamOut(io.qt.core.QMetaObject type, Object src, long dst);
    @io.qt.QtUninvokable
    private native static void copyStoredPropertiesStreamOut(io.qt.core.QMetaObject type, long src, long dst);
    @io.qt.QtUninvokable
    public static void qRegisterRemoteObjectsClient(java.lang.String id, Class<? extends QtROClientIoDevice> type){
        try {
            java.lang.reflect.Constructor<?> constructor = type.getConstructor(io.qt.core.QObject.class);
            qRegisterRemoteObjectsClient(id, type, constructor);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
    @io.qt.QtUninvokable
    private static native void qRegisterRemoteObjectsClient(java.lang.String id, Class<? extends QtROClientIoDevice> type, java.lang.reflect.Constructor<?> constructor);
}
