package io.qt.quick.widgets;

import io.qt.*;


/**
 * <p>Widget for displaying a Qt Quick user interface</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qquickwidget.html">QQuickWidget</a></code></p>
 */
public class QQuickWidget extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcQmlComponent = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickWidget.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qquickwidget.html#ResizeMode-enum">QQuickWidget::ResizeMode</a></code></p>
     */
    public enum ResizeMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qquickwidget.html#ResizeMode-enum">QQuickWidget::<wbr/>SizeViewToRootObject</a></code></p>
         */
        SizeViewToRootObject(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qquickwidget.html#ResizeMode-enum">QQuickWidget::<wbr/>SizeRootObjectToView</a></code></p>
         */
        SizeRootObjectToView(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ResizeMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ResizeMode resolve(int value) {
            switch (value) {
            case 0: return SizeViewToRootObject;
            case 1: return SizeRootObjectToView;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qquickwidget.html#Status-enum">QQuickWidget::Status</a></code></p>
     */
    public enum Status implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qquickwidget.html#Status-enum">QQuickWidget::<wbr/>Null</a></code></p>
         */
        Null(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qquickwidget.html#Status-enum">QQuickWidget::<wbr/>Ready</a></code></p>
         */
        Ready(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qquickwidget.html#Status-enum">QQuickWidget::<wbr/>Loading</a></code></p>
         */
        Loading(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qquickwidget.html#Status-enum">QQuickWidget::<wbr/>Error</a></code></p>
         */
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Status resolve(int value) {
            switch (value) {
            case 0: return Null;
            case 1: return Ready;
            case 2: return Loading;
            case 3: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#sceneGraphError">QQuickWidget::<wbr/>sceneGraphError(QQuickWindow::SceneGraphError,<wbr/>QString)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal2<io.qt.quick.QQuickWindow.@NonNull SceneGraphError, java.lang.@NonNull String> sceneGraphError = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#statusChanged">QQuickWidget::<wbr/>statusChanged(QQuickWidget::Status)</a></code></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal1<io.qt.quick.widgets.QQuickWidget.@NonNull Status> statusChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#QQuickWidget-1">QQuickWidget::<wbr/>QQuickWidget(QQmlEngine*,<wbr/>QWidget*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QQuickWidget(io.qt.qml.@Nullable QQmlEngine engine, io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, parent);
    }
    
    private native static void initialize_native(QQuickWidget instance, io.qt.qml.QQmlEngine engine, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#QQuickWidget-2">QQuickWidget::<wbr/>QQuickWidget(QUrl,<wbr/>QWidget*)</a></code></p>
     */
    public QQuickWidget(io.qt.core.@NonNull QUrl source, io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, source, parent);
    }
    
    private native static void initialize_native(QQuickWidget instance, io.qt.core.QUrl source, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#QQuickWidget">QQuickWidget::<wbr/>QQuickWidget(QWidget*)</a></code></p>
     */
    public QQuickWidget(io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickWidget instance, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#engine">QQuickWidget::<wbr/>engine()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qml.@Nullable QQmlEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qml.QQmlEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#errors">QQuickWidget::<wbr/>errors()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qml.@NonNull QQmlError> errors(){
        return errors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qml.QQmlError> errors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#format">QQuickWidget::<wbr/>format()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QSurfaceFormat format(){
        return format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QSurfaceFormat format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#grabFramebuffer">QQuickWidget::<wbr/>grabFramebuffer()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage grabFramebuffer(){
        return grabFramebuffer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage grabFramebuffer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#initialSize">QQuickWidget::<wbr/>initialSize()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QSize initialSize(){
        return initialSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize initialSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#quickWindow">QQuickWidget::<wbr/>quickWindow()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.quick.@Nullable QQuickWindow quickWindow(){
        return quickWindow_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.quick.QQuickWindow quickWindow_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#resizeMode-prop">QQuickWidget::<wbr/>resizeMode()const</a></code></p>
     */
    @QtPropertyReader(name="resizeMode")
    @QtUninvokable
    public final io.qt.quick.widgets.QQuickWidget.@NonNull ResizeMode resizeMode(){
        return io.qt.quick.widgets.QQuickWidget.ResizeMode.resolve(resizeMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int resizeMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#rootContext">QQuickWidget::<wbr/>rootContext()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qml.@Nullable QQmlContext rootContext(){
        return rootContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qml.QQmlContext rootContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#rootObject">QQuickWidget::<wbr/>rootObject()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.quick.@Nullable QQuickItem rootObject(){
        return rootObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.quick.QQuickItem rootObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#setClearColor">QQuickWidget::<wbr/>setClearColor(QColor)</a></code></p>
     */
    @QtUninvokable
    public final void setClearColor(io.qt.gui.@NonNull QColor color){
        setClearColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setClearColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code>QQuickWidget::<wbr/>setContent(QUrl,<wbr/>QQmlComponent*,<wbr/>QObject*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public final void setContent(io.qt.core.@NonNull QUrl url, io.qt.qml.@Nullable QQmlComponent component, io.qt.core.@Nullable QObject item){
        setContent_native_cref_QUrl_QQmlComponent_ptr_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(component), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
        __rcQmlComponent = component;
    }
    
    private native void setContent_native_cref_QUrl_QQmlComponent_ptr_QObject_ptr(long __this__nativeId, long url, long component, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#setFormat">QQuickWidget::<wbr/>setFormat(QSurfaceFormat)</a></code></p>
     */
    @QtUninvokable
    public final void setFormat(io.qt.gui.@NonNull QSurfaceFormat format){
        setFormat_native_cref_QSurfaceFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(format));
    }
    
    @QtUninvokable
    private native void setFormat_native_cref_QSurfaceFormat(long __this__nativeId, long format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#resizeMode-prop">QQuickWidget::<wbr/>setResizeMode(QQuickWidget::ResizeMode)</a></code></p>
     */
    @QtPropertyWriter(name="resizeMode")
    @QtUninvokable
    public final void setResizeMode(io.qt.quick.widgets.QQuickWidget.@NonNull ResizeMode arg__1){
        setResizeMode_native_QQuickWidget_ResizeMode(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setResizeMode_native_QQuickWidget_ResizeMode(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#setSource">QQuickWidget::<wbr/>setSource(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.@NonNull QUrl arg__1){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#source">QQuickWidget::<wbr/>source()const</a></code></p>
     */
    @QtPropertyReader(name="source")
    @QtPropertyDesignable
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qquickwidget.html#status-prop">QQuickWidget::<wbr/>status()const</a></code></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.quick.widgets.QQuickWidget.@NonNull Status status(){
        return io.qt.quick.widgets.QQuickWidget.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#dragEnterEvent">QWidget::<wbr/>dragEnterEvent(QDragEnterEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void dragEnterEvent(io.qt.gui.@Nullable QDragEnterEvent arg__1){
        dragEnterEvent_native_QDragEnterEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void dragEnterEvent_native_QDragEnterEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#dragLeaveEvent">QWidget::<wbr/>dragLeaveEvent(QDragLeaveEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void dragLeaveEvent(io.qt.gui.@Nullable QDragLeaveEvent arg__1){
        dragLeaveEvent_native_QDragLeaveEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void dragLeaveEvent_native_QDragLeaveEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#dragMoveEvent">QWidget::<wbr/>dragMoveEvent(QDragMoveEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void dragMoveEvent(io.qt.gui.@Nullable QDragMoveEvent arg__1){
        dragMoveEvent_native_QDragMoveEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void dragMoveEvent_native_QDragMoveEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#dropEvent">QWidget::<wbr/>dropEvent(QDropEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void dropEvent(io.qt.gui.@Nullable QDropEvent arg__1){
        dropEvent_native_QDropEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void dropEvent_native_QDropEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#event">QObject::<wbr/>event(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean event(io.qt.core.@Nullable QEvent arg__1){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#focusInEvent">QWidget::<wbr/>focusInEvent(QFocusEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void focusInEvent(io.qt.gui.@Nullable QFocusEvent event){
        focusInEvent_native_QFocusEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void focusInEvent_native_QFocusEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#focusNextPrevChild">QWidget::<wbr/>focusNextPrevChild(bool)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected boolean focusNextPrevChild(boolean next){
        return focusNextPrevChild_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), next);
    }
    
    @QtUninvokable
    private native boolean focusNextPrevChild_native_bool(long __this__nativeId, boolean next);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#focusOutEvent">QWidget::<wbr/>focusOutEvent(QFocusEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void focusOutEvent(io.qt.gui.@Nullable QFocusEvent event){
        focusOutEvent_native_QFocusEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void focusOutEvent_native_QFocusEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#hideEvent">QWidget::<wbr/>hideEvent(QHideEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void hideEvent(io.qt.gui.@Nullable QHideEvent arg__1){
        hideEvent_native_QHideEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void hideEvent_native_QHideEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#keyPressEvent">QWidget::<wbr/>keyPressEvent(QKeyEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void keyPressEvent(io.qt.gui.@Nullable QKeyEvent arg__1){
        keyPressEvent_native_QKeyEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void keyPressEvent_native_QKeyEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#keyReleaseEvent">QWidget::<wbr/>keyReleaseEvent(QKeyEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void keyReleaseEvent(io.qt.gui.@Nullable QKeyEvent arg__1){
        keyReleaseEvent_native_QKeyEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void keyReleaseEvent_native_QKeyEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#mouseDoubleClickEvent">QWidget::<wbr/>mouseDoubleClickEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mouseDoubleClickEvent(io.qt.gui.@Nullable QMouseEvent arg__1){
        mouseDoubleClickEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void mouseDoubleClickEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#mouseMoveEvent">QWidget::<wbr/>mouseMoveEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mouseMoveEvent(io.qt.gui.@Nullable QMouseEvent arg__1){
        mouseMoveEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#mousePressEvent">QWidget::<wbr/>mousePressEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mousePressEvent(io.qt.gui.@Nullable QMouseEvent arg__1){
        mousePressEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#mouseReleaseEvent">QWidget::<wbr/>mouseReleaseEvent(QMouseEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void mouseReleaseEvent(io.qt.gui.@Nullable QMouseEvent arg__1){
        mouseReleaseEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#paintEvent">QWidget::<wbr/>paintEvent(QPaintEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void paintEvent(io.qt.gui.@Nullable QPaintEvent event){
        paintEvent_native_QPaintEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void paintEvent_native_QPaintEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#resizeEvent">QWidget::<wbr/>resizeEvent(QResizeEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void resizeEvent(io.qt.gui.@Nullable QResizeEvent arg__1){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#showEvent">QWidget::<wbr/>showEvent(QShowEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void showEvent(io.qt.gui.@Nullable QShowEvent arg__1){
        showEvent_native_QShowEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void showEvent_native_QShowEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#sizeHint-prop">QWidget::<wbr/>sizeHint()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public io.qt.core.@NonNull QSize sizeHint(){
        return sizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize sizeHint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#timerEvent">QObject::<wbr/>timerEvent(QTimerEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void timerEvent(io.qt.core.@Nullable QTimerEvent arg__1){
        timerEvent_native_QTimerEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void timerEvent_native_QTimerEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwidget.html#wheelEvent">QWidget::<wbr/>wheelEvent(QWheelEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void wheelEvent(io.qt.gui.@Nullable QWheelEvent arg__1){
        wheelEvent_native_QWheelEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void wheelEvent_native_QWheelEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QQuickWidget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QQuickWidget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QQuickWidget instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QQuickWidget(io.qt.core.QUrl, io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickWidget(io.qt.core.@NonNull QUrl source) {
        this(source, (io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QQuickWidget(java.lang.String, io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickWidget(java.lang.@NonNull String source) {
        this(source, (io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QQuickWidget(io.qt.core.QUrl, io.qt.widgets.QWidget)}.</p>
     */
    public QQuickWidget(java.lang.@NonNull String source, io.qt.widgets.@Nullable QWidget parent) {
        this(new io.qt.core.QUrl(source), parent);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QQuickWidget(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickWidget() {
        this((io.qt.widgets.QWidget)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #resizeMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.quick.widgets.QQuickWidget.@NonNull ResizeMode getResizeMode() {
        return resizeMode();
    }
    
    /**
     * <p>Overloaded function for {@link #setClearColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setClearColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setClearColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setClearColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setClearColor(io.qt.gui.@NonNull QRgba64 color) {
        setClearColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setClearColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setClearColor(java.lang.@NonNull String color) {
        setClearColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QUrl, io.qt.qml.QQmlComponent, io.qt.core.QObject)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final void setContent(java.lang.@NonNull String url, io.qt.qml.@Nullable QQmlComponent component, io.qt.core.@Nullable QObject item) {
        setContent(new io.qt.core.QUrl(url), component, item);
    }
    
    /**
     * <p>Overloaded function for {@link #setFormat(io.qt.gui.QSurfaceFormat)}.</p>
     */
    @QtUninvokable
    public final void setFormat(io.qt.gui.QSurfaceFormat.@NonNull FormatOptions format) {
        setFormat(new io.qt.gui.QSurfaceFormat(format));
    }
    
    /**
     * <p>Overloaded function for {@link #setSource(io.qt.core.QUrl)}.</p>
     */
    public final void setSource(java.lang.@NonNull String arg__1) {
        setSource(new io.qt.core.QUrl(arg__1));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.quick.widgets.QQuickWidget.@NonNull Status getStatus() {
        return status();
    }
}
