package io.qt.quick3d;


/**
 * <p>Base class for defining custom texture data</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qquick3dtexturedata.html">QQuick3DTextureData</a></p>
 */
public class QQuick3DTextureData extends io.qt.quick3d.QQuick3DObject
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuick3DTextureData.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qquick3dtexturedata.html#Format-enum">QQuick3DTextureData::Format</a></p>
     */
    public enum Format implements io.qt.QtEnumerator {
        None(0),
        RGBA8(1),
        RGBA16F(2),
        RGBA32F(3),
        RGBE8(4),
        R8(5),
        R16(6),
        R16F(7),
        R32F(8),
        BC1(9),
        BC2(10),
        BC3(11),
        BC4(12),
        BC5(13),
        BC6H(14),
        BC7(15),
        DXT1_RGBA(16),
        DXT1_RGB(17),
        DXT3_RGBA(18),
        DXT5_RGBA(19),
        ETC2_RGB8(20),
        ETC2_RGB8A1(21),
        ETC2_RGBA8(22),
        ASTC_4x4(23),
        ASTC_5x4(24),
        ASTC_5x5(25),
        ASTC_6x5(26),
        ASTC_6x6(27),
        ASTC_8x5(28),
        ASTC_8x6(29),
        ASTC_8x8(30),
        ASTC_10x5(31),
        ASTC_10x6(32),
        ASTC_10x8(33),
        ASTC_10x10(34),
        ASTC_12x10(35),
        ASTC_12x12(36);

        private Format(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Format resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return RGBA8;
            case 2: return RGBA16F;
            case 3: return RGBA32F;
            case 4: return RGBE8;
            case 5: return R8;
            case 6: return R16;
            case 7: return R16F;
            case 8: return R32F;
            case 9: return BC1;
            case 10: return BC2;
            case 11: return BC3;
            case 12: return BC4;
            case 13: return BC5;
            case 14: return BC6H;
            case 15: return BC7;
            case 16: return DXT1_RGBA;
            case 17: return DXT1_RGB;
            case 18: return DXT3_RGBA;
            case 19: return DXT5_RGBA;
            case 20: return ETC2_RGB8;
            case 21: return ETC2_RGB8A1;
            case 22: return ETC2_RGBA8;
            case 23: return ASTC_4x4;
            case 24: return ASTC_5x4;
            case 25: return ASTC_5x5;
            case 26: return ASTC_6x5;
            case 27: return ASTC_6x6;
            case 28: return ASTC_8x5;
            case 29: return ASTC_8x6;
            case 30: return ASTC_8x8;
            case 31: return ASTC_10x5;
            case 32: return ASTC_10x6;
            case 33: return ASTC_10x8;
            case 34: return ASTC_10x10;
            case 35: return ASTC_12x10;
            case 36: return ASTC_12x12;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    public final Signal0 textureDataNodeDirty = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QQuick3DTextureData(io.qt.quick3d.QQuick3DObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuick3DTextureData() {
        this((io.qt.quick3d.QQuick3DObject)null);
    }
    
    public QQuick3DTextureData(io.qt.quick3d.QQuick3DObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuick3DTextureData instance, io.qt.quick3d.QQuick3DObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dtexturedata.html#format">QQuick3DTextureData::format()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick3d.QQuick3DTextureData.Format format(){
        return io.qt.quick3d.QQuick3DTextureData.Format.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dtexturedata.html#hasTransparency">QQuick3DTextureData::hasTransparency()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasTransparency(){
        return hasTransparency_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasTransparency_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dtexturedata.html#setFormat">QQuick3DTextureData::setFormat(QQuick3DTextureData::Format)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFormat(io.qt.quick3d.QQuick3DTextureData.Format format){
        setFormat_native_QQuick3DTextureData_Format(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFormat_native_QQuick3DTextureData_Format(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dtexturedata.html#setHasTransparency">QQuick3DTextureData::setHasTransparency(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHasTransparency(boolean hasTransparency){
        setHasTransparency_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), hasTransparency);
    }
    
    @io.qt.QtUninvokable
    private native void setHasTransparency_native_bool(long __this__nativeId, boolean hasTransparency);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dtexturedata.html#setSize">QQuick3DTextureData::setSize(QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSize(io.qt.core.QSize size){
        setSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dtexturedata.html#setTextureData">QQuick3DTextureData::setTextureData(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTextureData(io.qt.core.QByteArray data){
        setTextureData_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @io.qt.QtUninvokable
    private native void setTextureData_native_cref_QByteArray(long __this__nativeId, long data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dtexturedata.html#size">QQuick3DTextureData::size()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QSize size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dtexturedata.html#textureData">QQuick3DTextureData::textureData()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray textureData(){
        return textureData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray textureData_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void markAllDirty(){
        markAllDirty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void markAllDirty_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuick3DTextureData(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuick3DTextureData(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuick3DTextureData instance, QDeclarativeConstructor constructor);
    
}
