package io.qt.quick3d;


/**
 * <p>Base class for defining custom geometry</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qquick3dgeometry.html">QQuick3DGeometry</a></p>
 */
public class QQuick3DGeometry extends io.qt.quick3d.QQuick3DObject
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuick3DGeometry.class);
    
    /**
     * <p>Java wrapper for Qt enum QQuick3DGeometry::PrimitiveType</p>
     */
    @io.qt.QtUnlistedEnum
    public enum PrimitiveType implements io.qt.QtEnumerator {
        Points(0),
        LineStrip(1),
        Lines(2),
        TriangleStrip(3),
        TriangleFan(4),
        Triangles(5);

        private PrimitiveType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PrimitiveType resolve(int value) {
            switch (value) {
            case 0: return Points;
            case 1: return LineStrip;
            case 2: return Lines;
            case 3: return TriangleStrip;
            case 4: return TriangleFan;
            case 5: return Triangles;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt class QQuick3DGeometry::Attribute</p>
     */
    public static class Attribute extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        /**
         * <p>Java wrapper for Qt enum QQuick3DGeometry::Attribute::ComponentType</p>
         */
        public enum ComponentType implements io.qt.QtEnumerator {
            U16Type(0),
            U32Type(1),
            I32Type(2),
            F32Type(3);

            private ComponentType(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static ComponentType resolve(int value) {
                switch (value) {
                case 0: return U16Type;
                case 1: return U32Type;
                case 2: return I32Type;
                case 3: return F32Type;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        /**
         * <p>Java wrapper for Qt enum QQuick3DGeometry::Attribute::Semantic</p>
         */
        @io.qt.QtRejectedEntries({"TexCoord0Semantic"})
        public enum Semantic implements io.qt.QtEnumerator {
            IndexSemantic(0),
            PositionSemantic(1),
            NormalSemantic(2),
            TexCoordSemantic(3),
            TangentSemantic(4),
            BinormalSemantic(5),
            JointSemantic(6),
            WeightSemantic(7),
            ColorSemantic(8),
            TargetPositionSemantic(9),
            TargetNormalSemantic(10),
            TargetTangentSemantic(11),
            TargetBinormalSemantic(12),
            TexCoord1Semantic(13),
            TexCoord0Semantic(3);

            private Semantic(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static Semantic resolve(int value) {
                switch (value) {
                case 0: return IndexSemantic;
                case 1: return PositionSemantic;
                case 2: return NormalSemantic;
                case 3: return TexCoordSemantic;
                case 4: return TangentSemantic;
                case 5: return BinormalSemantic;
                case 6: return JointSemantic;
                case 7: return WeightSemantic;
                case 8: return ColorSemantic;
                case 9: return TargetPositionSemantic;
                case 10: return TargetNormalSemantic;
                case 11: return TargetTangentSemantic;
                case 12: return TargetBinormalSemantic;
                case 13: return TexCoord1Semantic;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        
        public Attribute(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(Attribute instance);
        
        @io.qt.QtUninvokable
        private final boolean operator_equal(io.qt.quick3d.QQuick3DGeometry.Attribute b){
            return operator_equal_native_cref_QQuick3DGeometry_Attribute(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(b));
        }
        
        @io.qt.QtUninvokable
        private native boolean operator_equal_native_cref_QQuick3DGeometry_Attribute(long __this__nativeId, long b);
        
        @io.qt.QtUninvokable
        public final void setComponentType(io.qt.quick3d.QQuick3DGeometry.Attribute.ComponentType componentType){
            setComponentType_native_cref_QQuick3DGeometry_Attribute_ComponentType(QtJambi_LibraryUtilities.internal.nativeId(this), componentType.value());
        }
        
        @io.qt.QtUninvokable
        private native void setComponentType_native_cref_QQuick3DGeometry_Attribute_ComponentType(long __this__nativeId, int componentType);
        
        @io.qt.QtUninvokable
        public final io.qt.quick3d.QQuick3DGeometry.Attribute.ComponentType componentType(){
            return io.qt.quick3d.QQuick3DGeometry.Attribute.ComponentType.resolve(componentType_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int componentType_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setOffset(int offset){
            setOffset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
        }
        
        @io.qt.QtUninvokable
        private native void setOffset_native_int(long __this__nativeId, int offset);
        
        @io.qt.QtUninvokable
        public final int offset(){
            return offset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int offset_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setSemantic(io.qt.quick3d.QQuick3DGeometry.Attribute.Semantic semantic){
            setSemantic_native_cref_QQuick3DGeometry_Attribute_Semantic(QtJambi_LibraryUtilities.internal.nativeId(this), semantic.value());
        }
        
        @io.qt.QtUninvokable
        private native void setSemantic_native_cref_QQuick3DGeometry_Attribute_Semantic(long __this__nativeId, int semantic);
        
        @io.qt.QtUninvokable
        public final io.qt.quick3d.QQuick3DGeometry.Attribute.Semantic semantic(){
            return io.qt.quick3d.QQuick3DGeometry.Attribute.Semantic.resolve(semantic_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int semantic_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Attribute(QPrivateConstructor p) { super(p); } 
        

        @Override
        @io.qt.QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.quick3d.QQuick3DGeometry.Attribute) {
                return operator_equal((io.qt.quick3d.QQuick3DGeometry.Attribute) other);
            }

            return false;
        }


        @io.qt.QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        @Override
        public Attribute clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native Attribute clone_native(long __this_nativeId);
    }


    public final Signal0 geometryNodeDirty = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QQuick3DGeometry(io.qt.quick3d.QQuick3DObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuick3DGeometry() {
        this((io.qt.quick3d.QQuick3DObject)null);
    }
    
    public QQuick3DGeometry(io.qt.quick3d.QQuick3DObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuick3DGeometry instance, io.qt.quick3d.QQuick3DObject parent);
    
    @io.qt.QtUninvokable
    public final void addAttribute(io.qt.quick3d.QQuick3DGeometry.Attribute.Semantic semantic, int offset, io.qt.quick3d.QQuick3DGeometry.Attribute.ComponentType componentType){
        addAttribute_native_QQuick3DGeometry_Attribute_Semantic_int_QQuick3DGeometry_Attribute_ComponentType(QtJambi_LibraryUtilities.internal.nativeId(this), semantic.value(), offset, componentType.value());
    }
    
    @io.qt.QtUninvokable
    private native void addAttribute_native_QQuick3DGeometry_Attribute_Semantic_int_QQuick3DGeometry_Attribute_ComponentType(long __this__nativeId, int semantic, int offset, int componentType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#addAttribute-1">QQuick3DGeometry::addAttribute(QQuick3DGeometry::Attribute)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addAttribute(io.qt.quick3d.QQuick3DGeometry.Attribute att){
        addAttribute_native_cref_QQuick3DGeometry_Attribute(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(att));
    }
    
    @io.qt.QtUninvokable
    private native void addAttribute_native_cref_QQuick3DGeometry_Attribute(long __this__nativeId, long att);
    
    /**
     * <p>Overloaded function for {@link #addSubset(int, int, io.qt.gui.QVector3D, io.qt.gui.QVector3D, java.lang.String)}
     *  with <code>name = ""</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void addSubset(int offset, int count, io.qt.gui.QVector3D boundsMin, io.qt.gui.QVector3D boundsMax) {
        addSubset(offset, count, boundsMin, boundsMax, "");
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#addSubset">QQuick3DGeometry::addSubset(int,int,QVector3D,QVector3D,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addSubset(int offset, int count, io.qt.gui.QVector3D boundsMin, io.qt.gui.QVector3D boundsMax, java.lang.String name){
        addSubset_native_int_int_cref_QVector3D_cref_QVector3D_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), offset, count, QtJambi_LibraryUtilities.internal.checkedNativeId(boundsMin), QtJambi_LibraryUtilities.internal.checkedNativeId(boundsMax), name);
    }
    
    @io.qt.QtUninvokable
    private native void addSubset_native_int_int_cref_QVector3D_cref_QVector3D_cref_QString(long __this__nativeId, int offset, int count, long boundsMin, long boundsMax, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#attribute">QQuick3DGeometry::attribute(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick3d.QQuick3DGeometry.Attribute attribute(int index){
        return attribute_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick3d.QQuick3DGeometry.Attribute attribute_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#attributeCount">QQuick3DGeometry::attributeCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int attributeCount(){
        return attributeCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int attributeCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#boundsMax">QQuick3DGeometry::boundsMax()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D boundsMax(){
        return boundsMax_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D boundsMax_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#boundsMin">QQuick3DGeometry::boundsMin()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D boundsMin(){
        return boundsMin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D boundsMin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#clear">QQuick3DGeometry::clear()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#indexData">QQuick3DGeometry::indexData()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray indexData(){
        return indexData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray indexData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#primitiveType">QQuick3DGeometry::primitiveType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick3d.QQuick3DGeometry.PrimitiveType primitiveType(){
        return io.qt.quick3d.QQuick3DGeometry.PrimitiveType.resolve(primitiveType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int primitiveType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#setBounds">QQuick3DGeometry::setBounds(QVector3D,QVector3D)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setBounds(io.qt.gui.QVector3D min, io.qt.gui.QVector3D max){
        setBounds_native_cref_QVector3D_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(min), QtJambi_LibraryUtilities.internal.checkedNativeId(max));
    }
    
    @io.qt.QtUninvokable
    private native void setBounds_native_cref_QVector3D_cref_QVector3D(long __this__nativeId, long min, long max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#setIndexData">QQuick3DGeometry::setIndexData(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setIndexData(io.qt.core.QByteArray data){
        setIndexData_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @io.qt.QtUninvokable
    private native void setIndexData_native_cref_QByteArray(long __this__nativeId, long data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#setIndexData-1">QQuick3DGeometry::setIndexData(int,QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setIndexData(int offset, io.qt.core.QByteArray data){
        setIndexData_native_int_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), offset, QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @io.qt.QtUninvokable
    private native void setIndexData_native_int_cref_QByteArray(long __this__nativeId, int offset, long data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#setPrimitiveType">QQuick3DGeometry::setPrimitiveType(QQuick3DGeometry::PrimitiveType)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPrimitiveType(io.qt.quick3d.QQuick3DGeometry.PrimitiveType type){
        setPrimitiveType_native_QQuick3DGeometry_PrimitiveType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPrimitiveType_native_QQuick3DGeometry_PrimitiveType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#setStride">QQuick3DGeometry::setStride(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setStride(int stride){
        setStride_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), stride);
    }
    
    @io.qt.QtUninvokable
    private native void setStride_native_int(long __this__nativeId, int stride);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#setVertexData">QQuick3DGeometry::setVertexData(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setVertexData(io.qt.core.QByteArray data){
        setVertexData_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @io.qt.QtUninvokable
    private native void setVertexData_native_cref_QByteArray(long __this__nativeId, long data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#setVertexData-1">QQuick3DGeometry::setVertexData(int,QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setVertexData(int offset, io.qt.core.QByteArray data){
        setVertexData_native_int_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), offset, QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @io.qt.QtUninvokable
    private native void setVertexData_native_int_cref_QByteArray(long __this__nativeId, int offset, long data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#stride">QQuick3DGeometry::stride()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int stride(){
        return stride_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int stride_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#subsetBoundsMax">QQuick3DGeometry::subsetBoundsMax(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D subsetBoundsMax(int subset){
        return subsetBoundsMax_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), subset);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D subsetBoundsMax_native_int_constfct(long __this__nativeId, int subset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#subsetBoundsMin">QQuick3DGeometry::subsetBoundsMin(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D subsetBoundsMin(int subset){
        return subsetBoundsMin_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), subset);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D subsetBoundsMin_native_int_constfct(long __this__nativeId, int subset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#subsetCount">QQuick3DGeometry::subsetCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int subsetCount(){
        return subsetCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int subsetCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#subsetCount-1">QQuick3DGeometry::subsetCount(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final int subsetCount(int subset){
        return subsetCount_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), subset);
    }
    
    @io.qt.QtUninvokable
    private native int subsetCount_native_int_constfct(long __this__nativeId, int subset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#subsetName">QQuick3DGeometry::subsetName(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String subsetName(int subset){
        return subsetName_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), subset);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String subsetName_native_int_constfct(long __this__nativeId, int subset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#subsetOffset">QQuick3DGeometry::subsetOffset(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final int subsetOffset(int subset){
        return subsetOffset_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), subset);
    }
    
    @io.qt.QtUninvokable
    private native int subsetOffset_native_int_constfct(long __this__nativeId, int subset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dgeometry.html#vertexData">QQuick3DGeometry::vertexData()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray vertexData(){
        return vertexData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray vertexData_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void markAllDirty(){
        markAllDirty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void markAllDirty_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuick3DGeometry(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuick3DGeometry(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuick3DGeometry instance, QDeclarativeConstructor constructor);
    
}
