package io.qt.quick3d;


/**
 * <p>Base class of all 3D nodes and resources</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qquick3dobject.html">QQuick3DObject</a></p>
 */
public class QQuick3DObject extends io.qt.core.QObject
    implements io.qt.qml.QQmlParserStatus
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuick3DObject.class);
    
    /**
     * <p>Java wrapper for Qt enum QQuick3DObject::ItemChange</p>
     */
    @io.qt.QtUnlistedEnum
    public enum ItemChange implements io.qt.QtEnumerator {
        ItemChildAddedChange(0),
        ItemChildRemovedChange(1),
        ItemSceneChange(2),
        ItemVisibleHasChanged(3),
        ItemParentHasChanged(4),
        ItemOpacityHasChanged(5),
        ItemActiveFocusHasChanged(6),
        ItemRotationHasChanged(7),
        ItemAntialiasingHasChanged(8),
        ItemDevicePixelRatioHasChanged(9),
        ItemEnabledHasChanged(10);

        private ItemChange(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ItemChange resolve(int value) {
            switch (value) {
            case 0: return ItemChildAddedChange;
            case 1: return ItemChildRemovedChange;
            case 2: return ItemSceneChange;
            case 3: return ItemVisibleHasChanged;
            case 4: return ItemParentHasChanged;
            case 5: return ItemOpacityHasChanged;
            case 6: return ItemActiveFocusHasChanged;
            case 7: return ItemRotationHasChanged;
            case 8: return ItemAntialiasingHasChanged;
            case 9: return ItemDevicePixelRatioHasChanged;
            case 10: return ItemEnabledHasChanged;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    



    public final Signal0 childrenChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dobject.html#parent-prop">QQuick3DObject::parentChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="parent")
    public final Signal0 parentChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dobject.html#state-prop">QQuick3DObject::stateChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="state")
    public final Signal0 stateChanged = new Signal0();
    
    /**
     * This constructor is a place holder intended to prevent
     * users from subclassing the class. Certain classes can
     * unfortunately only be subclasses internally. The constructor
     * will indiscriminately throw an exception if called. If the
     * exception is ignored, any use of the constructed object will
     * cause an exception to occur.

     * @throws io.qt.QClassCannotBeSubclassedException
     **/
    @SuppressWarnings("unused")
    private QQuick3DObject() throws io.qt.QClassCannotBeSubclassedException {
        super((QPrivateConstructor)null);
        throw new io.qt.QClassCannotBeSubclassedException(QQuick3DObject.class);
    }

    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.quick3d.QQuick3DObject> childItems(){
        return childItems_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.quick3d.QQuick3DObject> childItems_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected final boolean isComponentComplete(){
        return isComponentComplete_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isComponentComplete_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dobject.html#parent-prop">QQuick3DObject::parentItem()const</a></p>
     */
    @io.qt.QtPropertyReader(name="parent")
    @io.qt.QtPropertyDesignable("false")
    @io.qt.QtUninvokable
    public final io.qt.quick3d.QQuick3DObject parentItem(){
        return parentItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick3d.QQuick3DObject parentItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dobject.html#parent-prop">QQuick3DObject::setParentItem(QQuick3DObject*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="parent")
    public final void setParentItem(io.qt.quick3d.QQuick3DObject parentItem){
        setParentItem_native_QQuick3DObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parentItem));
    }
    
    private native void setParentItem_native_QQuick3DObject_ptr(long __this__nativeId, long parentItem);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dobject.html#state-prop">QQuick3DObject::setState(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="state")
    @io.qt.QtUninvokable
    public final void setState(java.lang.String state){
        setState_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), state);
    }
    
    @io.qt.QtUninvokable
    private native void setState_native_cref_QString(long __this__nativeId, java.lang.String state);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dobject.html#state-prop">QQuick3DObject::state()const</a></p>
     */
    @io.qt.QtPropertyReader(name="state")
    @io.qt.QtUninvokable
    public final java.lang.String state(){
        return state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String state_native_constfct(long __this__nativeId);
    
    public final void update(){
        update_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void update_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlparserstatus.html#classBegin">QQmlParserStatus::classBegin()</a></p>
     */
    @io.qt.QtUninvokable
    public void classBegin(){
        classBegin_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void classBegin_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlparserstatus.html#componentComplete">QQmlParserStatus::componentComplete()</a></p>
     */
    @io.qt.QtUninvokable
    public void componentComplete(){
        componentComplete_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void componentComplete_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void itemChange(io.qt.quick3d.QQuick3DObject.ItemChange arg__1, java.lang.Object arg__2){
        java.util.Objects.requireNonNull(arg__2, "Argument 'arg__2': null not expected.");
        itemChange_native_QQuick3DObject_ItemChange_cref_QQuick3DObject_ItemChangeData(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value(), arg__2);
    }
    
    @io.qt.QtUninvokable
    private native void itemChange_native_QQuick3DObject_ItemChange_cref_QQuick3DObject_ItemChangeData(long __this__nativeId, int arg__1, java.lang.Object arg__2);
    
    @io.qt.QtUninvokable
    protected void markAllDirty(){
        markAllDirty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void markAllDirty_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void preSync(){
        preSync_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void preSync_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuick3DObject(QPrivateConstructor p) { super(p); } 
    
}
