package io.qt.quick3d;


/**
 * <p>Base class for defining instance tables</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qquick3dinstancing.html">QQuick3DInstancing</a></p>
 */
public abstract class QQuick3DInstancing extends io.qt.quick3d.QQuick3DObject
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuick3DInstancing.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QQuick3DInstancing {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        protected io.qt.core.QByteArray getInstanceBuffer(int[] instanceCount){
            if(instanceCount!=null && instanceCount.length < 1)
                throw new IllegalArgumentException("Argument 'instanceCount': Wrong number of elements in array. Found: " + instanceCount.length + ", expected: 1");
            return getInstanceBuffer_native_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), instanceCount);
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QByteArray getInstanceBuffer_native_int_ptr(long __this__nativeId, int[] instanceCount);
        
    }
    
    /**
     * <p>Java wrapper for Qt class QQuick3DInstancing::InstanceTableEntry</p>
     */
    public static class InstanceTableEntry extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public InstanceTableEntry(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(InstanceTableEntry instance);
        
        @io.qt.QtUninvokable
        public final void setColor(io.qt.gui.QVector4D color){
            setColor_native_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
        }
        
        @io.qt.QtUninvokable
        private native void setColor_native_cref_QVector4D(long __this__nativeId, long color);
        
        @io.qt.QtUninvokable
        public final io.qt.gui.QVector4D color(){
            return color_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QVector4D color_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setInstanceData(io.qt.gui.QVector4D instanceData){
            setInstanceData_native_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(instanceData));
        }
        
        @io.qt.QtUninvokable
        private native void setInstanceData_native_cref_QVector4D(long __this__nativeId, long instanceData);
        
        @io.qt.QtUninvokable
        public final io.qt.gui.QVector4D instanceData(){
            return instanceData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QVector4D instanceData_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setRow0(io.qt.gui.QVector4D row0){
            setRow0_native_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(row0));
        }
        
        @io.qt.QtUninvokable
        private native void setRow0_native_cref_QVector4D(long __this__nativeId, long row0);
        
        @io.qt.QtUninvokable
        public final io.qt.gui.QVector4D row0(){
            return row0_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QVector4D row0_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setRow1(io.qt.gui.QVector4D row1){
            setRow1_native_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(row1));
        }
        
        @io.qt.QtUninvokable
        private native void setRow1_native_cref_QVector4D(long __this__nativeId, long row1);
        
        @io.qt.QtUninvokable
        public final io.qt.gui.QVector4D row1(){
            return row1_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QVector4D row1_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setRow2(io.qt.gui.QVector4D row2){
            setRow2_native_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(row2));
        }
        
        @io.qt.QtUninvokable
        private native void setRow2_native_cref_QVector4D(long __this__nativeId, long row2);
        
        @io.qt.QtUninvokable
        public final io.qt.gui.QVector4D row2(){
            return row2_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QVector4D row2_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected InstanceTableEntry(QPrivateConstructor p) { super(p); } 
        

        @Override
        @io.qt.QtUninvokable
        public boolean equals(Object other) {
            if(other instanceof io.qt.quick3d.QQuick3DInstancing.InstanceTableEntry)
                return hashCode()==other.hashCode();
            else return super.equals(other);        }


        @io.qt.QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        @Override
        public InstanceTableEntry clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native InstanceTableEntry clone_native(long __this_nativeId);
    }


    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#depthSortingEnabled-prop">QQuick3DInstancing::depthSortingEnabledChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="depthSortingEnabled")
    public final Signal0 depthSortingEnabledChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#hasTransparency-prop">QQuick3DInstancing::hasTransparencyChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="hasTransparency")
    public final Signal0 hasTransparencyChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#instanceCountOverride-prop">QQuick3DInstancing::instanceCountOverrideChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="instanceCountOverride")
    public final Signal0 instanceCountOverrideChanged = new Signal0();

    public final Signal0 instanceNodeDirty = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QQuick3DInstancing(io.qt.quick3d.QQuick3DObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuick3DInstancing() {
        this((io.qt.quick3d.QQuick3DObject)null);
    }
    
    public QQuick3DInstancing(io.qt.quick3d.QQuick3DObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuick3DInstancing instance, io.qt.quick3d.QQuick3DObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#depthSortingEnabled-prop">QQuick3DInstancing::depthSortingEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="depthSortingEnabled")
    @io.qt.QtUninvokable
    public final boolean depthSortingEnabled(){
        return depthSortingEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean depthSortingEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#hasTransparency-prop">QQuick3DInstancing::hasTransparency()const</a></p>
     */
    @io.qt.QtPropertyReader(name="hasTransparency")
    @io.qt.QtUninvokable
    public final boolean hasTransparency(){
        return hasTransparency_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasTransparency_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray instanceBuffer(int[] instanceCount){
        if(instanceCount!=null && instanceCount.length < 1)
            throw new IllegalArgumentException("Argument 'instanceCount': Wrong number of elements in array. Found: " + instanceCount.length + ", expected: 1");
        return instanceBuffer_native_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), instanceCount);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray instanceBuffer_native_int_ptr(long __this__nativeId, int[] instanceCount);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#instanceCountOverride-prop">QQuick3DInstancing::instanceCountOverride()const</a></p>
     */
    @io.qt.QtPropertyReader(name="instanceCountOverride")
    @io.qt.QtUninvokable
    public final int instanceCountOverride(){
        return instanceCountOverride_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int instanceCountOverride_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#markDirty">QQuick3DInstancing::markDirty()</a></p>
     */
    @io.qt.QtUninvokable
    protected final void markDirty(){
        markDirty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void markDirty_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#depthSortingEnabled-prop">QQuick3DInstancing::setDepthSortingEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="depthSortingEnabled")
    public final void setDepthSortingEnabled(boolean enabled){
        setDepthSortingEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setDepthSortingEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#hasTransparency-prop">QQuick3DInstancing::setHasTransparency(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="hasTransparency")
    public final void setHasTransparency(boolean hasTransparency){
        setHasTransparency_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), hasTransparency);
    }
    
    private native void setHasTransparency_native_bool(long __this__nativeId, boolean hasTransparency);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#instanceCountOverride-prop">QQuick3DInstancing::setInstanceCountOverride(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="instanceCountOverride")
    public final void setInstanceCountOverride(int instanceCountOverride){
        setInstanceCountOverride_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), instanceCountOverride);
    }
    
    private native void setInstanceCountOverride_native_int(long __this__nativeId, int instanceCountOverride);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#getInstanceBuffer">QQuick3DInstancing::getInstanceBuffer(int*)</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract io.qt.core.QByteArray getInstanceBuffer(int[] instanceCount);
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray getInstanceBuffer_native_int_ptr(long __this__nativeId, int[] instanceCount);
    
    /**
     * <p>Overloaded function for {@link #calculateTableEntry(io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QColor, io.qt.gui.QVector4D)}
     *  with <code>customData = new io.qt.gui.QVector4D()</code>.</p>
     */
    protected static io.qt.quick3d.QQuick3DInstancing.InstanceTableEntry calculateTableEntry(io.qt.gui.QVector3D position, io.qt.gui.QVector3D scale, io.qt.gui.QVector3D eulerRotation, io.qt.gui.QColor color) {
        return calculateTableEntry(position, scale, eulerRotation, color, new io.qt.gui.QVector4D());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#calculateTableEntry">QQuick3DInstancing::calculateTableEntry(QVector3D,QVector3D,QVector3D,QColor,QVector4D)</a></p>
     */
    protected static io.qt.quick3d.QQuick3DInstancing.InstanceTableEntry calculateTableEntry(io.qt.gui.QVector3D position, io.qt.gui.QVector3D scale, io.qt.gui.QVector3D eulerRotation, io.qt.gui.QColor color, io.qt.gui.QVector4D customData){
        return calculateTableEntry_native_cref_QVector3D_cref_QVector3D_cref_QVector3D_cref_QColor_cref_QVector4D(QtJambi_LibraryUtilities.internal.checkedNativeId(position), QtJambi_LibraryUtilities.internal.checkedNativeId(scale), QtJambi_LibraryUtilities.internal.checkedNativeId(eulerRotation), QtJambi_LibraryUtilities.internal.checkedNativeId(color), QtJambi_LibraryUtilities.internal.checkedNativeId(customData));
    }
    
    private native static io.qt.quick3d.QQuick3DInstancing.InstanceTableEntry calculateTableEntry_native_cref_QVector3D_cref_QVector3D_cref_QVector3D_cref_QColor_cref_QVector4D(long position, long scale, long eulerRotation, long color, long customData);
    
    /**
     * <p>Overloaded function for {@link #calculateTableEntryFromQuaternion(io.qt.gui.QVector3D, io.qt.gui.QVector3D, io.qt.gui.QQuaternion, io.qt.gui.QColor, io.qt.gui.QVector4D)}
     *  with <code>customData = new io.qt.gui.QVector4D()</code>.</p>
     */
    protected static io.qt.quick3d.QQuick3DInstancing.InstanceTableEntry calculateTableEntryFromQuaternion(io.qt.gui.QVector3D position, io.qt.gui.QVector3D scale, io.qt.gui.QQuaternion rotation, io.qt.gui.QColor color) {
        return calculateTableEntryFromQuaternion(position, scale, rotation, color, new io.qt.gui.QVector4D());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquick3dinstancing.html#calculateTableEntryFromQuaternion">QQuick3DInstancing::calculateTableEntryFromQuaternion(QVector3D,QVector3D,QQuaternion,QColor,QVector4D)</a></p>
     */
    protected static io.qt.quick3d.QQuick3DInstancing.InstanceTableEntry calculateTableEntryFromQuaternion(io.qt.gui.QVector3D position, io.qt.gui.QVector3D scale, io.qt.gui.QQuaternion rotation, io.qt.gui.QColor color, io.qt.gui.QVector4D customData){
        return calculateTableEntryFromQuaternion_native_cref_QVector3D_cref_QVector3D_cref_QQuaternion_cref_QColor_cref_QVector4D(QtJambi_LibraryUtilities.internal.checkedNativeId(position), QtJambi_LibraryUtilities.internal.checkedNativeId(scale), QtJambi_LibraryUtilities.internal.checkedNativeId(rotation), QtJambi_LibraryUtilities.internal.checkedNativeId(color), QtJambi_LibraryUtilities.internal.checkedNativeId(customData));
    }
    
    private native static io.qt.quick3d.QQuick3DInstancing.InstanceTableEntry calculateTableEntryFromQuaternion_native_cref_QVector3D_cref_QVector3D_cref_QQuaternion_cref_QColor_cref_QVector4D(long position, long scale, long rotation, long color, long customData);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuick3DInstancing(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuick3DInstancing(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuick3DInstancing instance, QDeclarativeConstructor constructor);
    
}
