package io.qt.quick.nativeinterface;


/**
 * <p>Provides access to and enables adopting Vulkan image objects</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qnativeinterface-qsgvulkantexture.html">QNativeInterface::QSGVulkanTexture</a></p>
 */
public interface QSGVulkanTexture extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.quick.nativeinterface.QSGVulkanTexture}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.quick.nativeinterface.QSGVulkanTexture
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QSGVulkanTexture.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public long nativeImage(){
                return nativeImage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static long nativeImage_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public int nativeImageLayout(){
                return nativeImageLayout_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int nativeImageLayout_native_constfct(long __this__nativeId);
            
        }
        
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgvulkantexture.html#nativeImage">QNativeInterface::QSGVulkanTexture::nativeImage()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract long nativeImage();
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgvulkantexture.html#nativeImageLayout">QNativeInterface::QSGVulkanTexture::nativeImageLayout()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int nativeImageLayout();
        
        /**
         * <p>Overloaded function for {@link #fromNative(long, int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
         */
        private static io.qt.quick.QSGTexture fromNative(long image, int layout, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
            return fromNative(image, layout, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
        }
        
        /**
         * <p>Overloaded function for {@link #fromNative(long, int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}
         *  with <code>options = new io.qt.quick.QQuickWindow.CreateTextureOptions(0)</code>.</p>
         */
        private static io.qt.quick.QSGTexture fromNative(long image, int layout, io.qt.quick.QQuickWindow window, io.qt.core.QSize size) {
            return fromNative(image, layout, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(0));
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgvulkantexture.html#fromNative">QNativeInterface::QSGVulkanTexture::fromNative(VkImage,VkImageLayout,QQuickWindow*,QSize,QFlags&lt;QQuickWindow::CreateTextureOption&gt;)</a></p>
         */
        private static io.qt.quick.QSGTexture fromNative(long image, int layout, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOptions options){
            return fromNative_native_VkImage_VkImageLayout_QQuickWindow_ptr_cref_QSize_QFlags_QQuickWindow_CreateTextureOption_(image, layout, QtJambi_LibraryUtilities.internal.checkedNativeId(window), QtJambi_LibraryUtilities.internal.checkedNativeId(size), options.value());
        }
        
        private native static io.qt.quick.QSGTexture fromNative_native_VkImage_VkImageLayout_QQuickWindow_ptr_cref_QSize_QFlags_QQuickWindow_CreateTextureOption_(long image, int layout, long window, long size, int options);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgvulkantexture.html#nativeImage">QNativeInterface::QSGVulkanTexture::nativeImage()const</a></p>
     */
    @io.qt.QtUninvokable
    public long nativeImage();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgvulkantexture.html#nativeImageLayout">QNativeInterface::QSGVulkanTexture::nativeImageLayout()const</a></p>
     */
    @io.qt.QtUninvokable
    public int nativeImageLayout();
    
    /**
     * <p>Overloaded function for {@link #fromNative(long, int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
     */
    public static io.qt.quick.QSGTexture fromNative(long image, int layout, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
        return fromNative(image, layout, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #fromNative(long, int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}
     *  with <code>options = new io.qt.quick.QQuickWindow.CreateTextureOptions(0)</code>.</p>
     */
    public static io.qt.quick.QSGTexture fromNative(long image, int layout, io.qt.quick.QQuickWindow window, io.qt.core.QSize size) {
        return fromNative(image, layout, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgvulkantexture.html#fromNative">QNativeInterface::QSGVulkanTexture::fromNative(VkImage,VkImageLayout,QQuickWindow*,QSize,QQuickWindow::CreateTextureOptions)</a></p>
     */
    public static io.qt.quick.QSGTexture fromNative(long image, int layout, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOptions options){
        return Impl.fromNative(image, layout, window, size, options);
    }
    
}
