package io.qt.quick.nativeinterface;


/**
 * <p>Provides access to and enables adopting OpenGL texture objects</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qnativeinterface-qsgopengltexture.html">QNativeInterface::QSGOpenGLTexture</a></p>
 */
public interface QSGOpenGLTexture extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.quick.nativeinterface.QSGOpenGLTexture}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.quick.nativeinterface.QSGOpenGLTexture
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QSGOpenGLTexture.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public int nativeTexture(){
                return nativeTexture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static int nativeTexture_native_constfct(long __this__nativeId);
            
        }
        
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgopengltexture.html#nativeTexture">QNativeInterface::QSGOpenGLTexture::nativeTexture()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract int nativeTexture();
        
        /**
         * <p>Overloaded function for {@link #fromNative(int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
         */
        private static io.qt.quick.QSGTexture fromNative(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
            return fromNative(textureId, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
        }
        
        /**
         * <p>Overloaded function for {@link #fromNative(int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}
         *  with <code>options = new io.qt.quick.QQuickWindow.CreateTextureOptions(0)</code>.</p>
         */
        private static io.qt.quick.QSGTexture fromNative(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size) {
            return fromNative(textureId, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(0));
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgopengltexture.html#fromNative">QNativeInterface::QSGOpenGLTexture::fromNative(GLuint,QQuickWindow*,QSize,QFlags&lt;QQuickWindow::CreateTextureOption&gt;)</a></p>
         */
        private static io.qt.quick.QSGTexture fromNative(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOptions options){
            return fromNative_native_GLuint_QQuickWindow_ptr_cref_QSize_QFlags_QQuickWindow_CreateTextureOption_(textureId, QtJambi_LibraryUtilities.internal.checkedNativeId(window), QtJambi_LibraryUtilities.internal.checkedNativeId(size), options.value());
        }
        
        private native static io.qt.quick.QSGTexture fromNative_native_GLuint_QQuickWindow_ptr_cref_QSize_QFlags_QQuickWindow_CreateTextureOption_(int textureId, long window, long size, int options);
        
        /**
         * <p>Overloaded function for {@link #fromNativeExternalOES(int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
         */
        private static io.qt.quick.QSGTexture fromNativeExternalOES(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
            return fromNativeExternalOES(textureId, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
        }
        
        /**
         * <p>Overloaded function for {@link #fromNativeExternalOES(int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}
         *  with <code>options = new io.qt.quick.QQuickWindow.CreateTextureOptions(0)</code>.</p>
         */
        private static io.qt.quick.QSGTexture fromNativeExternalOES(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size) {
            return fromNativeExternalOES(textureId, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(0));
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgopengltexture.html#fromNativeExternalOES">QNativeInterface::QSGOpenGLTexture::fromNativeExternalOES(GLuint,QQuickWindow*,QSize,QFlags&lt;QQuickWindow::CreateTextureOption&gt;)</a></p>
         */
        private static io.qt.quick.QSGTexture fromNativeExternalOES(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOptions options){
            return fromNativeExternalOES_native_GLuint_QQuickWindow_ptr_cref_QSize_QFlags_QQuickWindow_CreateTextureOption_(textureId, QtJambi_LibraryUtilities.internal.checkedNativeId(window), QtJambi_LibraryUtilities.internal.checkedNativeId(size), options.value());
        }
        
        private native static io.qt.quick.QSGTexture fromNativeExternalOES_native_GLuint_QQuickWindow_ptr_cref_QSize_QFlags_QQuickWindow_CreateTextureOption_(int textureId, long window, long size, int options);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgopengltexture.html#nativeTexture">QNativeInterface::QSGOpenGLTexture::nativeTexture()const</a></p>
     */
    @io.qt.QtUninvokable
    public int nativeTexture();
    
    /**
     * <p>Overloaded function for {@link #fromNative(int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
     */
    public static io.qt.quick.QSGTexture fromNative(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
        return fromNative(textureId, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #fromNative(int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}
     *  with <code>options = new io.qt.quick.QQuickWindow.CreateTextureOptions(0)</code>.</p>
     */
    public static io.qt.quick.QSGTexture fromNative(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size) {
        return fromNative(textureId, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgopengltexture.html#fromNative">QNativeInterface::QSGOpenGLTexture::fromNative(GLuint,QQuickWindow*,QSize,QQuickWindow::CreateTextureOptions)</a></p>
     */
    public static io.qt.quick.QSGTexture fromNative(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOptions options){
        return Impl.fromNative(textureId, window, size, options);
    }
    
    /**
     * <p>Overloaded function for {@link #fromNativeExternalOES(int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
     */
    public static io.qt.quick.QSGTexture fromNativeExternalOES(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
        return fromNativeExternalOES(textureId, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #fromNativeExternalOES(int, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}
     *  with <code>options = new io.qt.quick.QQuickWindow.CreateTextureOptions(0)</code>.</p>
     */
    public static io.qt.quick.QSGTexture fromNativeExternalOES(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size) {
        return fromNativeExternalOES(textureId, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgopengltexture.html#fromNativeExternalOES">QNativeInterface::QSGOpenGLTexture::fromNativeExternalOES(GLuint,QQuickWindow*,QSize,QQuickWindow::CreateTextureOptions)</a></p>
     */
    public static io.qt.quick.QSGTexture fromNativeExternalOES(int textureId, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOptions options){
        return Impl.fromNativeExternalOES(textureId, window, size, options);
    }
    
}
