package io.qt.quick.nativeinterface;


/**
 * <p>Provides access to and enables adopting Direct3D 11 texture objects</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qnativeinterface-qsgd3d11texture.html">QNativeInterface::QSGD3D11Texture</a></p>
 */
public interface QSGD3D11Texture extends io.qt.QtObjectInterface
{
    /**
     * <p>Implementor class for interface {@link io.qt.quick.nativeinterface.QSGD3D11Texture}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.quick.nativeinterface.QSGD3D11Texture
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QSGD3D11Texture.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.QNativePointer nativeTexture(){
                return nativeTexture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static io.qt.QNativePointer nativeTexture_native_constfct(long __this__nativeId);
            
        }
        
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgd3d11texture.html#nativeTexture">QNativeInterface::QSGD3D11Texture::nativeTexture()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.QNativePointer nativeTexture();
        
        /**
         * <p>Overloaded function for {@link #fromNative(io.qt.QNativePointer, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
         */
        private static io.qt.quick.QSGTexture fromNative(io.qt.QNativePointer texture, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
            return fromNative(texture, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
        }
        
        /**
         * <p>Overloaded function for {@link #fromNative(io.qt.QNativePointer, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}
         *  with <code>options = new io.qt.quick.QQuickWindow.CreateTextureOptions(0)</code>.</p>
         */
        private static io.qt.quick.QSGTexture fromNative(io.qt.QNativePointer texture, io.qt.quick.QQuickWindow window, io.qt.core.QSize size) {
            return fromNative(texture, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(0));
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgd3d11texture.html#fromNative">QNativeInterface::QSGD3D11Texture::fromNative(void*,QQuickWindow*,QSize,QFlags&lt;QQuickWindow::CreateTextureOption&gt;)</a></p>
         */
        private static io.qt.quick.QSGTexture fromNative(io.qt.QNativePointer texture, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOptions options){
            return fromNative_native_void_ptr_QQuickWindow_ptr_cref_QSize_QFlags_QQuickWindow_CreateTextureOption_(texture, QtJambi_LibraryUtilities.internal.checkedNativeId(window), QtJambi_LibraryUtilities.internal.checkedNativeId(size), options.value());
        }
        
        private native static io.qt.quick.QSGTexture fromNative_native_void_ptr_QQuickWindow_ptr_cref_QSize_QFlags_QQuickWindow_CreateTextureOption_(io.qt.QNativePointer texture, long window, long size, int options);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgd3d11texture.html#nativeTexture">QNativeInterface::QSGD3D11Texture::nativeTexture()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.QNativePointer nativeTexture();
    
    /**
     * <p>Overloaded function for {@link #fromNative(io.qt.QNativePointer, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
     */
    public static io.qt.quick.QSGTexture fromNative(io.qt.QNativePointer texture, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
        return fromNative(texture, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #fromNative(io.qt.QNativePointer, io.qt.quick.QQuickWindow, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}
     *  with <code>options = new io.qt.quick.QQuickWindow.CreateTextureOptions(0)</code>.</p>
     */
    public static io.qt.quick.QSGTexture fromNative(io.qt.QNativePointer texture, io.qt.quick.QQuickWindow window, io.qt.core.QSize size) {
        return fromNative(texture, window, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnativeinterface-qsgd3d11texture.html#fromNative">QNativeInterface::QSGD3D11Texture::fromNative(void*,QQuickWindow*,QSize,QQuickWindow::CreateTextureOptions)</a></p>
     */
    public static io.qt.quick.QSGTexture fromNative(io.qt.QNativePointer texture, io.qt.quick.QQuickWindow window, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOptions options){
        return Impl.fromNative(texture, window, size, options);
    }
    
}
