package io.qt.quick;


/**
 * <p>Convenient way of rendering textured geometry in the scene graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgtexturematerial.html">QSGTextureMaterial</a></p>
 */
public class QSGTextureMaterial extends io.qt.quick.QSGOpaqueTextureMaterial
{
    
    public QSGTextureMaterial(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGTextureMaterial instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#createShader">QSGMaterial::createShader(QSGRendererInterface::RenderMode)const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGMaterialShader createShader(io.qt.quick.QSGRendererInterface.RenderMode renderMode){
        return createShader_native_QSGRendererInterface_RenderMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), renderMode.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterialShader createShader_native_QSGRendererInterface_RenderMode_constfct(long __this__nativeId, int renderMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#type">QSGMaterial::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGMaterialType type(){
        return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterialType type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGTextureMaterial(QPrivateConstructor p) { super(p); } 
    
}
