package io.qt.quick;


/**
 * <p>An interface providing access to some of the graphics API specific internals of the scenegraph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgrendererinterface.html">QSGRendererInterface</a></p>
 */
public interface QSGRendererInterface extends io.qt.QtObjectInterface
{
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgrendererinterface.html#GraphicsApi-enum">QSGRendererInterface::GraphicsApi</a></p>
     */
    @io.qt.QtRejectedEntries({"OpenGLRhi", "Direct3D11Rhi", "VulkanRhi", "MetalRhi", "NullRhi"})
    public enum GraphicsApi implements io.qt.QtEnumerator {
        Unknown(0),
        Software(1),
        OpenVG(2),
        OpenGL(3),
        Direct3D11(4),
        Vulkan(5),
        Metal(6),
        Null(7),
        OpenGLRhi(3),
        Direct3D11Rhi(4),
        VulkanRhi(5),
        MetalRhi(6),
        NullRhi(7);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private GraphicsApi(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static GraphicsApi resolve(int value) {
            switch (value) {
            case 0: return Unknown;
            case 1: return Software;
            case 2: return OpenVG;
            case 3: return OpenGL;
            case 4: return Direct3D11;
            case 5: return Vulkan;
            case 6: return Metal;
            case 7: return Null;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgrendererinterface.html#RenderMode-enum">QSGRendererInterface::RenderMode</a></p>
     */
    public enum RenderMode implements io.qt.QtEnumerator {
        RenderMode2D(0),
        RenderMode2DNoDepthBuffer(1),
        RenderMode3D(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RenderMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RenderMode resolve(int value) {
            switch (value) {
            case 0: return RenderMode2D;
            case 1: return RenderMode2DNoDepthBuffer;
            case 2: return RenderMode3D;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgrendererinterface.html#Resource-enum">QSGRendererInterface::Resource</a></p>
     */
    public enum Resource implements io.qt.QtEnumerator {
        DeviceResource(0),
        CommandQueueResource(1),
        CommandListResource(2),
        PainterResource(3),
        RhiResource(4),
        RhiSwapchainResource(5),
        RhiRedirectCommandBuffer(6),
        RhiRedirectRenderTarget(7),
        PhysicalDeviceResource(8),
        OpenGLContextResource(9),
        DeviceContextResource(10),
        CommandEncoderResource(11),
        VulkanInstanceResource(12),
        RenderPassResource(13);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Resource(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Resource resolve(int value) {
            switch (value) {
            case 0: return DeviceResource;
            case 1: return CommandQueueResource;
            case 2: return CommandListResource;
            case 3: return PainterResource;
            case 4: return RhiResource;
            case 5: return RhiSwapchainResource;
            case 6: return RhiRedirectCommandBuffer;
            case 7: return RhiRedirectRenderTarget;
            case 8: return PhysicalDeviceResource;
            case 9: return OpenGLContextResource;
            case 10: return DeviceContextResource;
            case 11: return CommandEncoderResource;
            case 12: return VulkanInstanceResource;
            case 13: return RenderPassResource;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgrendererinterface.html#ShaderCompilationType-enum">QSGRendererInterface::ShaderCompilationType</a></p>
     * 
     * @see ShaderCompilationTypes
     */
    public enum ShaderCompilationType implements io.qt.QtFlagEnumerator {
        RuntimeCompilation(1),
        OfflineCompilation(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ShaderCompilationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ShaderCompilationTypes asFlags() {
            return new ShaderCompilationTypes(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ShaderCompilationTypes combined(ShaderCompilationType e) {
            return new ShaderCompilationTypes(this, e);
        }

        /**
         * Creates a new {@link ShaderCompilationTypes} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ShaderCompilationTypes flags(ShaderCompilationType ... values) {
            return new ShaderCompilationTypes(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ShaderCompilationType resolve(int value) {
            switch (value) {
            case 1: return RuntimeCompilation;
            case 2: return OfflineCompilation;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ShaderCompilationType}
     */
    public static final class ShaderCompilationTypes extends io.qt.QFlags<ShaderCompilationType> implements Comparable<ShaderCompilationTypes> {
        private static final long serialVersionUID = 0x1b6b40d6165244b0L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ShaderCompilationTypes where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ShaderCompilationTypes(ShaderCompilationType ... args){
            super(args);
        }

        /**
         * Creates a new ShaderCompilationTypes with given <code>value</code>.
         * @param value
         */
        public ShaderCompilationTypes(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ShaderCompilationTypes
         */
        @Override
        public final ShaderCompilationTypes combined(ShaderCompilationType e){
            return new ShaderCompilationTypes(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ShaderCompilationTypes setFlag(ShaderCompilationType e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ShaderCompilationTypes setFlag(ShaderCompilationType e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ShaderCompilationTypes.
         * @return array of enum entries
         */
        @Override
        public final ShaderCompilationType[] flags(){
            return super.flags(ShaderCompilationType.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ShaderCompilationTypes clone(){
            return new ShaderCompilationTypes(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ShaderCompilationTypes other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgrendererinterface.html#ShaderSourceType-enum">QSGRendererInterface::ShaderSourceType</a></p>
     * 
     * @see ShaderSourceTypes
     */
    public enum ShaderSourceType implements io.qt.QtFlagEnumerator {
        ShaderSourceString(1),
        ShaderSourceFile(2),
        ShaderByteCode(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ShaderSourceType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ShaderSourceTypes asFlags() {
            return new ShaderSourceTypes(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ShaderSourceTypes combined(ShaderSourceType e) {
            return new ShaderSourceTypes(this, e);
        }

        /**
         * Creates a new {@link ShaderSourceTypes} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ShaderSourceTypes flags(ShaderSourceType ... values) {
            return new ShaderSourceTypes(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ShaderSourceType resolve(int value) {
            switch (value) {
            case 1: return ShaderSourceString;
            case 2: return ShaderSourceFile;
            case 4: return ShaderByteCode;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ShaderSourceType}
     */
    public static final class ShaderSourceTypes extends io.qt.QFlags<ShaderSourceType> implements Comparable<ShaderSourceTypes> {
        private static final long serialVersionUID = 0xc3e7cec6283ef008L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ShaderSourceTypes where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ShaderSourceTypes(ShaderSourceType ... args){
            super(args);
        }

        /**
         * Creates a new ShaderSourceTypes with given <code>value</code>.
         * @param value
         */
        public ShaderSourceTypes(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ShaderSourceTypes
         */
        @Override
        public final ShaderSourceTypes combined(ShaderSourceType e){
            return new ShaderSourceTypes(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ShaderSourceTypes setFlag(ShaderSourceType e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ShaderSourceTypes setFlag(ShaderSourceType e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ShaderSourceTypes.
         * @return array of enum entries
         */
        @Override
        public final ShaderSourceType[] flags(){
            return super.flags(ShaderSourceType.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ShaderSourceTypes clone(){
            return new ShaderSourceTypes(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ShaderSourceTypes other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgrendererinterface.html#ShaderType-enum">QSGRendererInterface::ShaderType</a></p>
     */
    public enum ShaderType implements io.qt.QtEnumerator {
        UnknownShadingLanguage(0),
        GLSL(1),
        HLSL(2),
        RhiShader(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ShaderType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ShaderType resolve(int value) {
            switch (value) {
            case 0: return UnknownShadingLanguage;
            case 1: return GLSL;
            case 2: return HLSL;
            case 3: return RhiShader;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Implementor class for interface {@link io.qt.quick.QSGRendererInterface}</p>
     */
    public static abstract class Impl extends io.qt.QtObject
        implements io.qt.quick.QSGRendererInterface
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QSGRendererInterface.Impl {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.quick.QSGRendererInterface.GraphicsApi graphicsApi(){
                return io.qt.quick.QSGRendererInterface.GraphicsApi.resolve(graphicsApi_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
            }
            private native static int graphicsApi_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.quick.QSGRendererInterface.ShaderCompilationTypes shaderCompilationType(){
                return new io.qt.quick.QSGRendererInterface.ShaderCompilationTypes(shaderCompilationType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
            }
            private native static int shaderCompilationType_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.quick.QSGRendererInterface.ShaderSourceTypes shaderSourceType(){
                return new io.qt.quick.QSGRendererInterface.ShaderSourceTypes(shaderSourceType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
            }
            private native static int shaderSourceType_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.quick.QSGRendererInterface.ShaderType shaderType(){
                return io.qt.quick.QSGRendererInterface.ShaderType.resolve(shaderType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
            }
            private native static int shaderType_native_constfct(long __this__nativeId);
            
        }
        
        
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QSGRendererInterface instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#graphicsApi">QSGRendererInterface::graphicsApi()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.quick.QSGRendererInterface.GraphicsApi graphicsApi();
        
        private native static int graphicsApi_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#shaderCompilationType">QSGRendererInterface::shaderCompilationType()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.quick.QSGRendererInterface.ShaderCompilationTypes shaderCompilationType();
        
        private native static int shaderCompilationType_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#shaderSourceType">QSGRendererInterface::shaderSourceType()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.quick.QSGRendererInterface.ShaderSourceTypes shaderSourceType();
        
        private native static int shaderSourceType_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#shaderType">QSGRendererInterface::shaderType()const</a></p>
         */
        @io.qt.QtUninvokable
        public abstract io.qt.quick.QSGRendererInterface.ShaderType shaderType();
        
        private native static int shaderType_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#isApiRhiBased">QSGRendererInterface::isApiRhiBased(QSGRendererInterface::GraphicsApi)</a></p>
         */
        private static boolean isApiRhiBased(io.qt.quick.QSGRendererInterface.GraphicsApi api){
            return isApiRhiBased_native_QSGRendererInterface_GraphicsApi(api.value());
        }
        
        private native static boolean isApiRhiBased_native_QSGRendererInterface_GraphicsApi(int api);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#graphicsApi">QSGRendererInterface::graphicsApi()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGRendererInterface.GraphicsApi graphicsApi();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#shaderCompilationType">QSGRendererInterface::shaderCompilationType()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGRendererInterface.ShaderCompilationTypes shaderCompilationType();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#shaderSourceType">QSGRendererInterface::shaderSourceType()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGRendererInterface.ShaderSourceTypes shaderSourceType();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#shaderType">QSGRendererInterface::shaderType()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGRendererInterface.ShaderType shaderType();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendererinterface.html#isApiRhiBased">QSGRendererInterface::isApiRhiBased(QSGRendererInterface::GraphicsApi)</a></p>
     */
    public static boolean isApiRhiBased(io.qt.quick.QSGRendererInterface.GraphicsApi api){
        return Impl.isApiRhiBased(api);
    }
    
}
