package io.qt.quick;


/**
 * <p>Represents a set of custom rendering commands targeting the graphics API that is in use by the scenegraph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgrendernode.html">QSGRenderNode</a></p>
 */
public abstract class QSGRenderNode extends io.qt.quick.QSGNode
{
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSGRenderNode {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public void render(io.qt.quick.QSGRenderNode.RenderState state){
            render_native_const_QSGRenderNode_RenderState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
        }
        @io.qt.QtUninvokable
        private native void render_native_const_QSGRenderNode_RenderState_ptr(long __this__nativeId, long state);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgrendernode.html#RenderingFlag-enum">QSGRenderNode::RenderingFlag</a></p>
     * 
     * @see RenderingFlags
     */
    public enum RenderingFlag implements io.qt.QtFlagEnumerator {
        BoundedRectRendering(1),
        DepthAwareRendering(2),
        OpaqueRendering(4),
        NoExternalRendering(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RenderingFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public RenderingFlags asFlags() {
            return new RenderingFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public RenderingFlags combined(RenderingFlag e) {
            return new RenderingFlags(this, e);
        }

        /**
         * Creates a new {@link RenderingFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static RenderingFlags flags(RenderingFlag ... values) {
            return new RenderingFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RenderingFlag resolve(int value) {
            switch (value) {
            case 1: return BoundedRectRendering;
            case 2: return DepthAwareRendering;
            case 4: return OpaqueRendering;
            case 8: return NoExternalRendering;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link RenderingFlag}
     */
    public static final class RenderingFlags extends io.qt.QFlags<RenderingFlag> implements Comparable<RenderingFlags> {
        private static final long serialVersionUID = 0x90ca10eb18093afdL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new RenderingFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public RenderingFlags(RenderingFlag ... args){
            super(args);
        }

        /**
         * Creates a new RenderingFlags with given <code>value</code>.
         * @param value
         */
        public RenderingFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new RenderingFlags
         */
        @Override
        public final RenderingFlags combined(RenderingFlag e){
            return new RenderingFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final RenderingFlags setFlag(RenderingFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final RenderingFlags setFlag(RenderingFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this RenderingFlags.
         * @return array of enum entries
         */
        @Override
        public final RenderingFlag[] flags(){
            return super.flags(RenderingFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final RenderingFlags clone(){
            return new RenderingFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(RenderingFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgrendernode.html#StateFlag-enum">QSGRenderNode::StateFlag</a></p>
     * 
     * @see StateFlags
     */
    public enum StateFlag implements io.qt.QtFlagEnumerator {
        DepthState(1),
        StencilState(2),
        ScissorState(4),
        ColorState(8),
        BlendState(16),
        CullState(32),
        ViewportState(64),
        RenderTargetState(128);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private StateFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public StateFlags asFlags() {
            return new StateFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public StateFlags combined(StateFlag e) {
            return new StateFlags(this, e);
        }

        /**
         * Creates a new {@link StateFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static StateFlags flags(StateFlag ... values) {
            return new StateFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static StateFlag resolve(int value) {
            switch (value) {
            case 1: return DepthState;
            case 2: return StencilState;
            case 4: return ScissorState;
            case 8: return ColorState;
            case 16: return BlendState;
            case 32: return CullState;
            case 64: return ViewportState;
            case 128: return RenderTargetState;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link StateFlag}
     */
    public static final class StateFlags extends io.qt.QFlags<StateFlag> implements Comparable<StateFlags> {
        private static final long serialVersionUID = 0xc82adc3999736912L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new StateFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public StateFlags(StateFlag ... args){
            super(args);
        }

        /**
         * Creates a new StateFlags with given <code>value</code>.
         * @param value
         */
        public StateFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new StateFlags
         */
        @Override
        public final StateFlags combined(StateFlag e){
            return new StateFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final StateFlags setFlag(StateFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final StateFlags setFlag(StateFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this StateFlags.
         * @return array of enum entries
         */
        @Override
        public final StateFlag[] flags(){
            return super.flags(StateFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final StateFlags clone(){
            return new StateFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(StateFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>Java wrapper for Qt class QSGRenderNode::RenderState</p>
     */
    public static abstract class RenderState extends io.qt.QtObject
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QSGRenderNode.RenderState {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.gui.QRegion clipRegion(){
                return clipRegion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            @io.qt.QtUninvokable
            private native io.qt.gui.QRegion clipRegion_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.gui.QMatrix4x4 projectionMatrix(){
                return projectionMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            @io.qt.QtUninvokable
            private native io.qt.gui.QMatrix4x4 projectionMatrix_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean scissorEnabled(){
                return scissorEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            @io.qt.QtUninvokable
            private native boolean scissorEnabled_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public io.qt.core.QRect scissorRect(){
                return scissorRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            @io.qt.QtUninvokable
            private native io.qt.core.QRect scissorRect_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public boolean stencilEnabled(){
                return stencilEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            @io.qt.QtUninvokable
            private native boolean stencilEnabled_native_constfct(long __this__nativeId);
            
            
            @Override
            @io.qt.QtUninvokable
            public int stencilValue(){
                return stencilValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            @io.qt.QtUninvokable
            private native int stencilValue_native_constfct(long __this__nativeId);
            
        }
        
        
        public RenderState(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(RenderState instance);
        
        @io.qt.QtUninvokable
        public abstract io.qt.gui.QRegion clipRegion();
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QRegion clipRegion_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public abstract io.qt.gui.QMatrix4x4 projectionMatrix();
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 projectionMatrix_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public abstract boolean scissorEnabled();
        
        @io.qt.QtUninvokable
        private native boolean scissorEnabled_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public abstract io.qt.core.QRect scissorRect();
        
        @io.qt.QtUninvokable
        private native io.qt.core.QRect scissorRect_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public abstract boolean stencilEnabled();
        
        @io.qt.QtUninvokable
        private native boolean stencilEnabled_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public abstract int stencilValue();
        
        @io.qt.QtUninvokable
        private native int stencilValue_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected RenderState(QPrivateConstructor p) { super(p); } 
        
    }

    
    public QSGRenderNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGRenderNode instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendernode.html#clipList">QSGRenderNode::clipList()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGClipNode clipList(){
        return clipList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGClipNode clipList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendernode.html#inheritedOpacity">QSGRenderNode::inheritedOpacity()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double inheritedOpacity(){
        return inheritedOpacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double inheritedOpacity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendernode.html#matrix">QSGRenderNode::matrix()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QMatrix4x4 matrix(){
        return matrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QMatrix4x4 matrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendernode.html#changedStates">QSGRenderNode::changedStates()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGRenderNode.StateFlags changedStates(){
        return new io.qt.quick.QSGRenderNode.StateFlags(changedStates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int changedStates_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendernode.html#flags">QSGRenderNode::flags()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGRenderNode.RenderingFlags renderingFlags(){
        return new io.qt.quick.QSGRenderNode.RenderingFlags(renderingFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int renderingFlags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendernode.html#prepare">QSGRenderNode::prepare()</a></p>
     */
    @io.qt.QtUninvokable
    public void prepare(){
        prepare_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void prepare_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendernode.html#rect">QSGRenderNode::rect()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QRectF rect(){
        return rect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF rect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendernode.html#releaseResources">QSGRenderNode::releaseResources()</a></p>
     */
    @io.qt.QtUninvokable
    public void releaseResources(){
        releaseResources_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void releaseResources_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrendernode.html#render">QSGRenderNode::render(const QSGRenderNode::RenderState*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void render(io.qt.quick.QSGRenderNode.RenderState state);
    
    @io.qt.QtUninvokable
    private native void render_native_const_QSGRenderNode_RenderState_ptr(long __this__nativeId, long state);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGRenderNode(QPrivateConstructor p) { super(p); } 
    
}
