package io.qt.quick;


/**
 * <p>Convenience class for drawing solid filled rectangles using scenegraph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgrectanglenode.html">QSGRectangleNode</a></p>
 */
public abstract class QSGRectangleNode extends io.qt.quick.QSGGeometryNode
{
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSGRectangleNode {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.gui.QColor color(){
            return color_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.gui.QColor color_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QRectF rect(){
            return rect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QRectF rect_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setColor(io.qt.gui.QColor color){
            setColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
        }
        @io.qt.QtUninvokable
        private native void setColor_native_cref_QColor(long __this__nativeId, long color);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setRect(io.qt.core.QRectF rect){
            setRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
        }
        @io.qt.QtUninvokable
        private native void setRect_native_cref_QRectF(long __this__nativeId, long rect);
        
    }
    
    
    public QSGRectangleNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGRectangleNode instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrectanglenode.html#setRect-1">QSGRectangleNode::setRect(qreal,qreal,qreal,qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRect(double x, double y, double w, double h){
        setRect_native_qreal_qreal_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, w, h);
    }
    
    @io.qt.QtUninvokable
    private native void setRect_native_qreal_qreal_qreal_qreal(long __this__nativeId, double x, double y, double w, double h);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrectanglenode.html#color">QSGRectangleNode::color()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.gui.QColor color();
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor color_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrectanglenode.html#rect">QSGRectangleNode::rect()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QRectF rect();
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF rect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrectanglenode.html#setColor">QSGRectangleNode::setColor(QColor)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setColor(io.qt.gui.QColor color);
    
    @io.qt.QtUninvokable
    private native void setColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgrectanglenode.html#setRect">QSGRectangleNode::setRect(QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setRect(io.qt.core.QRectF rect);
    
    @io.qt.QtUninvokable
    private native void setRect_native_cref_QRectF(long __this__nativeId, long rect);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGRectangleNode(QPrivateConstructor p) { super(p); } 
    
}
