package io.qt.quick;


/**
 * <p>Convenient way of rendering textured geometry in the scene graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html">QSGOpaqueTextureMaterial</a></p>
 */
public class QSGOpaqueTextureMaterial extends io.qt.quick.QSGMaterial
{
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#QSGOpaqueTextureMaterial">QSGOpaqueTextureMaterial::QSGOpaqueTextureMaterial()</a></p>
     */
    public QSGOpaqueTextureMaterial(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGOpaqueTextureMaterial instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#anisotropyLevel">QSGOpaqueTextureMaterial::anisotropyLevel()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.AnisotropyLevel anisotropyLevel(){
        return io.qt.quick.QSGTexture.AnisotropyLevel.resolve(anisotropyLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int anisotropyLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#filtering">QSGOpaqueTextureMaterial::filtering()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.Filtering filtering(){
        return io.qt.quick.QSGTexture.Filtering.resolve(filtering_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int filtering_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#horizontalWrapMode">QSGOpaqueTextureMaterial::horizontalWrapMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.WrapMode horizontalWrapMode(){
        return io.qt.quick.QSGTexture.WrapMode.resolve(horizontalWrapMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int horizontalWrapMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#mipmapFiltering">QSGOpaqueTextureMaterial::mipmapFiltering()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.Filtering mipmapFiltering(){
        return io.qt.quick.QSGTexture.Filtering.resolve(mipmapFiltering_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int mipmapFiltering_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#setAnisotropyLevel">QSGOpaqueTextureMaterial::setAnisotropyLevel(QSGTexture::AnisotropyLevel)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAnisotropyLevel(io.qt.quick.QSGTexture.AnisotropyLevel level){
        setAnisotropyLevel_native_QSGTexture_AnisotropyLevel(QtJambi_LibraryUtilities.internal.nativeId(this), level.value());
    }
    
    @io.qt.QtUninvokable
    private native void setAnisotropyLevel_native_QSGTexture_AnisotropyLevel(long __this__nativeId, int level);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#setFiltering">QSGOpaqueTextureMaterial::setFiltering(QSGTexture::Filtering)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFiltering(io.qt.quick.QSGTexture.Filtering filteringType){
        setFiltering_native_QSGTexture_Filtering(QtJambi_LibraryUtilities.internal.nativeId(this), filteringType.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFiltering_native_QSGTexture_Filtering(long __this__nativeId, int filteringType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#setHorizontalWrapMode">QSGOpaqueTextureMaterial::setHorizontalWrapMode(QSGTexture::WrapMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHorizontalWrapMode(io.qt.quick.QSGTexture.WrapMode mode){
        setHorizontalWrapMode_native_QSGTexture_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setHorizontalWrapMode_native_QSGTexture_WrapMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#setMipmapFiltering">QSGOpaqueTextureMaterial::setMipmapFiltering(QSGTexture::Filtering)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMipmapFiltering(io.qt.quick.QSGTexture.Filtering filteringType){
        setMipmapFiltering_native_QSGTexture_Filtering(QtJambi_LibraryUtilities.internal.nativeId(this), filteringType.value());
    }
    
    @io.qt.QtUninvokable
    private native void setMipmapFiltering_native_QSGTexture_Filtering(long __this__nativeId, int filteringType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#setTexture">QSGOpaqueTextureMaterial::setTexture(QSGTexture*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTexture(io.qt.quick.QSGTexture texture){
        setTexture_native_QSGTexture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
    }
    
    @io.qt.QtUninvokable
    private native void setTexture_native_QSGTexture_ptr(long __this__nativeId, long texture);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#setVerticalWrapMode">QSGOpaqueTextureMaterial::setVerticalWrapMode(QSGTexture::WrapMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setVerticalWrapMode(io.qt.quick.QSGTexture.WrapMode mode){
        setVerticalWrapMode_native_QSGTexture_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setVerticalWrapMode_native_QSGTexture_WrapMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#texture">QSGOpaqueTextureMaterial::texture()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTexture texture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgopaquetexturematerial.html#verticalWrapMode">QSGOpaqueTextureMaterial::verticalWrapMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.WrapMode verticalWrapMode(){
        return io.qt.quick.QSGTexture.WrapMode.resolve(verticalWrapMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int verticalWrapMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#compare">QSGMaterial::compare(const QSGMaterial*)const</a></p>
     */
    @io.qt.QtUninvokable
    public int compare(io.qt.quick.QSGMaterial other){
        return compare_native_const_QSGMaterial_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native int compare_native_const_QSGMaterial_ptr_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#createShader">QSGMaterial::createShader(QSGRendererInterface::RenderMode)const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGMaterialShader createShader(io.qt.quick.QSGRendererInterface.RenderMode renderMode){
        return createShader_native_QSGRendererInterface_RenderMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), renderMode.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterialShader createShader_native_QSGRendererInterface_RenderMode_constfct(long __this__nativeId, int renderMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#type">QSGMaterial::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGMaterialType type(){
        return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterialType type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGOpaqueTextureMaterial(QPrivateConstructor p) { super(p); } 
    
}
