package io.qt.quick;


/**
 * <p>Represents a graphics API independent shader program</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgmaterialshader.html">QSGMaterialShader</a></p>
 */
public class QSGMaterialShader extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgmaterialshader.html#Flag-enum">QSGMaterialShader::Flag</a></p>
     * 
     * @see Flags
     */
    public enum Flag implements io.qt.QtFlagEnumerator {
        UpdatesGraphicsPipelineState(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Flag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Flags asFlags() {
            return new Flags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Flags combined(Flag e) {
            return new Flags(this, e);
        }

        /**
         * Creates a new {@link Flags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Flags flags(Flag ... values) {
            return new Flags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Flag resolve(int value) {
            switch (value) {
            case 1: return UpdatesGraphicsPipelineState;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Flag}
     */
    public static final class Flags extends io.qt.QFlags<Flag> implements Comparable<Flags> {
        private static final long serialVersionUID = 0x92d9bce6c929c1c6L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Flags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Flags(Flag ... args){
            super(args);
        }

        /**
         * Creates a new Flags with given <code>value</code>.
         * @param value
         */
        public Flags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Flags
         */
        @Override
        public final Flags combined(Flag e){
            return new Flags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Flags setFlag(Flag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Flags setFlag(Flag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Flags.
         * @return array of enum entries
         */
        @Override
        public final Flag[] flags(){
            return super.flags(Flag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Flags clone(){
            return new Flags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Flags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum QSGMaterialShader::Stage</p>
     */
    public enum Stage implements io.qt.QtEnumerator {
        VertexStage(0),
        FragmentStage(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Stage(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Stage resolve(int value) {
            switch (value) {
            case 0: return VertexStage;
            case 1: return FragmentStage;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Encapsulates the current rendering state during a call to QSGMaterialShader::updateUniformData() and the other update type of functions</p>
     * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html">QSGMaterialShader::RenderState</a></p>
     */
    public static class RenderState extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        /**
         * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#DirtyState-enum">QSGMaterialShader::RenderState::DirtyState</a></p>
         * 
         * @see DirtyStates
         */
        public enum DirtyState implements io.qt.QtFlagEnumerator {
            DirtyMatrix(1),
            DirtyOpacity(2),
            DirtyCachedMaterialData(4),
            DirtyAll(65535);

            static {
                QtJambi_LibraryUtilities.initialize();
            }

            private DirtyState(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Create a QFlags of the enum entry.
             * @return QFlags
             */
            public DirtyStates asFlags() {
                return new DirtyStates(value);
            }

            /**
             * Combines this entry with other enum entry.
             * @param e enum entry
             * @return new flag
             */
            public DirtyStates combined(DirtyState e) {
                return new DirtyStates(this, e);
            }

            /**
             * Creates a new {@link DirtyStates} from the entries.
             * @param values entries
             * @return new flag
             */
            public static DirtyStates flags(DirtyState ... values) {
                return new DirtyStates(values);
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static DirtyState resolve(int value) {
                switch (value) {
                case 1: return DirtyMatrix;
                case 2: return DirtyOpacity;
                case 4: return DirtyCachedMaterialData;
                case 65535: return DirtyAll;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        /**
         * QFlags type for enum {@link DirtyState}
         */
        public static final class DirtyStates extends io.qt.QFlags<DirtyState> implements Comparable<DirtyStates> {
            private static final long serialVersionUID = 0x8dc3e7d21adb861cL;
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            /**
             * Creates a new DirtyStates where the flags in <code>args</code> are set.
             * @param args enum entries
             */
            public DirtyStates(DirtyState ... args){
                super(args);
            }

            /**
             * Creates a new DirtyStates with given <code>value</code>.
             * @param value
             */
            public DirtyStates(int value) {
                super(value);
            }

            /**
             * Combines this flags with enum entry.
             * @param e enum entry
             * @return new DirtyStates
             */
            @Override
            public final DirtyStates combined(DirtyState e){
                return new DirtyStates(value() | e.value());
            }

            /**
             * Sets the flag <code>e</code>
             * @param e enum entry
             * @return this
             */
            public final DirtyStates setFlag(DirtyState e){
                super.setFlag(e);
                return this;
            }

            /**
             * Sets or clears the flag <code>flag</code>
             * @param e enum entry
             * @param on set (true) or clear (false)
             * @return this
             */
            public final DirtyStates setFlag(DirtyState e, boolean on){
                super.setFlag(e, on);
                return this;
            }

            /**
             * Returns an array of flag objects represented by this DirtyStates.
             * @return array of enum entries
             */
            @Override
            public final DirtyState[] flags(){
                return super.flags(DirtyState.values());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final DirtyStates clone(){
                return new DirtyStates(value());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final int compareTo(DirtyStates other){
                return Integer.compare(value(), other.value());
            }
        }
        
        
        public RenderState(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(RenderState instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#combinedMatrix">QSGMaterialShader::RenderState::combinedMatrix()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QMatrix4x4 combinedMatrix(){
            return combinedMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 combinedMatrix_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#determinant">QSGMaterialShader::RenderState::determinant()const</a></p>
         */
        @io.qt.QtUninvokable
        public final float determinant(){
            return determinant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float determinant_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#devicePixelRatio">QSGMaterialShader::RenderState::devicePixelRatio()const</a></p>
         */
        @io.qt.QtUninvokable
        public final float devicePixelRatio(){
            return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float devicePixelRatio_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#deviceRect">QSGMaterialShader::RenderState::deviceRect()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QRect deviceRect(){
            return deviceRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QRect deviceRect_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#dirtyStates">QSGMaterialShader::RenderState::dirtyStates()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialShader.RenderState.DirtyStates dirtyStates(){
            return new io.qt.quick.QSGMaterialShader.RenderState.DirtyStates(dirtyStates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int dirtyStates_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#isMatrixDirty">QSGMaterialShader::RenderState::isMatrixDirty()const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isMatrixDirty(){
            return isMatrixDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isMatrixDirty_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#isOpacityDirty">QSGMaterialShader::RenderState::isOpacityDirty()const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isOpacityDirty(){
            return isOpacityDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isOpacityDirty_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#modelViewMatrix">QSGMaterialShader::RenderState::modelViewMatrix()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QMatrix4x4 modelViewMatrix(){
            return modelViewMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 modelViewMatrix_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#opacity">QSGMaterialShader::RenderState::opacity()const</a></p>
         */
        @io.qt.QtUninvokable
        public final float opacity(){
            return opacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float opacity_native_constfct(long __this__nativeId);
        
        @io.qt.QtUninvokable
        private final boolean operator_equal(io.qt.quick.QSGMaterialShader.RenderState value2){
            return operator_equal_native_cref_QSGMaterialShader_RenderState(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value2));
        }
        
        @io.qt.QtUninvokable
        private native boolean operator_equal_native_cref_QSGMaterialShader_RenderState(long __this__nativeId, long value2);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#projectionMatrix">QSGMaterialShader::RenderState::projectionMatrix()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QMatrix4x4 projectionMatrix(){
            return projectionMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 projectionMatrix_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader-renderstate.html#viewportRect">QSGMaterialShader::RenderState::viewportRect()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QRect viewportRect(){
            return viewportRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QRect viewportRect_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected RenderState(QPrivateConstructor p) { super(p); } 
        

        @Override
        @io.qt.QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.quick.QSGMaterialShader.RenderState) {
                return operator_equal((io.qt.quick.QSGMaterialShader.RenderState) other);
            }

            return false;
        }


        @io.qt.QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        @Override
        public RenderState clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native RenderState clone_native(long __this_nativeId);
    }
    /**
     * <p>Describes state changes that the material wants to apply to the currently active graphics pipeline state</p>
     * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgmaterialshader-graphicspipelinestate.html">QSGMaterialShader::GraphicsPipelineState</a></p>
     */
    public static class GraphicsPipelineState extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        /**
         * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgmaterialshader-graphicspipelinestate.html#BlendFactor-enum">QSGMaterialShader::GraphicsPipelineState::BlendFactor</a></p>
         */
        public enum BlendFactor implements io.qt.QtEnumerator {
            Zero(0),
            One(1),
            SrcColor(2),
            OneMinusSrcColor(3),
            DstColor(4),
            OneMinusDstColor(5),
            SrcAlpha(6),
            OneMinusSrcAlpha(7),
            DstAlpha(8),
            OneMinusDstAlpha(9),
            ConstantColor(10),
            OneMinusConstantColor(11),
            ConstantAlpha(12),
            OneMinusConstantAlpha(13),
            SrcAlphaSaturate(14),
            Src1Color(15),
            OneMinusSrc1Color(16),
            Src1Alpha(17),
            OneMinusSrc1Alpha(18);

            static {
                QtJambi_LibraryUtilities.initialize();
            }

            private BlendFactor(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static BlendFactor resolve(int value) {
                switch (value) {
                case 0: return Zero;
                case 1: return One;
                case 2: return SrcColor;
                case 3: return OneMinusSrcColor;
                case 4: return DstColor;
                case 5: return OneMinusDstColor;
                case 6: return SrcAlpha;
                case 7: return OneMinusSrcAlpha;
                case 8: return DstAlpha;
                case 9: return OneMinusDstAlpha;
                case 10: return ConstantColor;
                case 11: return OneMinusConstantColor;
                case 12: return ConstantAlpha;
                case 13: return OneMinusConstantAlpha;
                case 14: return SrcAlphaSaturate;
                case 15: return Src1Color;
                case 16: return OneMinusSrc1Color;
                case 17: return Src1Alpha;
                case 18: return OneMinusSrc1Alpha;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        /**
         * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgmaterialshader-graphicspipelinestate.html#ColorMaskComponent-enum">QSGMaterialShader::GraphicsPipelineState::ColorMaskComponent</a></p>
         * 
         * @see ColorMask
         */
        public enum ColorMaskComponent implements io.qt.QtFlagEnumerator {
            R(1),
            G(2),
            B(4),
            A(8);

            static {
                QtJambi_LibraryUtilities.initialize();
            }

            private ColorMaskComponent(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Create a QFlags of the enum entry.
             * @return QFlags
             */
            public ColorMask asFlags() {
                return new ColorMask(value);
            }

            /**
             * Combines this entry with other enum entry.
             * @param e enum entry
             * @return new flag
             */
            public ColorMask combined(ColorMaskComponent e) {
                return new ColorMask(this, e);
            }

            /**
             * Creates a new {@link ColorMask} from the entries.
             * @param values entries
             * @return new flag
             */
            public static ColorMask flags(ColorMaskComponent ... values) {
                return new ColorMask(values);
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static ColorMaskComponent resolve(int value) {
                switch (value) {
                case 1: return R;
                case 2: return G;
                case 4: return B;
                case 8: return A;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        /**
         * QFlags type for enum {@link ColorMaskComponent}
         */
        public static final class ColorMask extends io.qt.QFlags<ColorMaskComponent> implements Comparable<ColorMask> {
            private static final long serialVersionUID = 0xb6e9f22153371f6aL;
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            /**
             * Creates a new ColorMask where the flags in <code>args</code> are set.
             * @param args enum entries
             */
            public ColorMask(ColorMaskComponent ... args){
                super(args);
            }

            /**
             * Creates a new ColorMask with given <code>value</code>.
             * @param value
             */
            public ColorMask(int value) {
                super(value);
            }

            /**
             * Combines this flags with enum entry.
             * @param e enum entry
             * @return new ColorMask
             */
            @Override
            public final ColorMask combined(ColorMaskComponent e){
                return new ColorMask(value() | e.value());
            }

            /**
             * Sets the flag <code>e</code>
             * @param e enum entry
             * @return this
             */
            public final ColorMask setFlag(ColorMaskComponent e){
                super.setFlag(e);
                return this;
            }

            /**
             * Sets or clears the flag <code>flag</code>
             * @param e enum entry
             * @param on set (true) or clear (false)
             * @return this
             */
            public final ColorMask setFlag(ColorMaskComponent e, boolean on){
                super.setFlag(e, on);
                return this;
            }

            /**
             * Returns an array of flag objects represented by this ColorMask.
             * @return array of enum entries
             */
            @Override
            public final ColorMaskComponent[] flags(){
                return super.flags(ColorMaskComponent.values());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final ColorMask clone(){
                return new ColorMask(value());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final int compareTo(ColorMask other){
                return Integer.compare(value(), other.value());
            }
        }
        
        /**
         * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgmaterialshader-graphicspipelinestate.html#CullMode-enum">QSGMaterialShader::GraphicsPipelineState::CullMode</a></p>
         */
        public enum CullMode implements io.qt.QtEnumerator {
            CullNone(0),
            CullFront(1),
            CullBack(2);

            static {
                QtJambi_LibraryUtilities.initialize();
            }

            private CullMode(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static CullMode resolve(int value) {
                switch (value) {
                case 0: return CullNone;
                case 1: return CullFront;
                case 2: return CullBack;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        
        public GraphicsPipelineState(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(GraphicsPipelineState instance);
        
        @io.qt.QtUninvokable
        private final boolean operator_equal(io.qt.quick.QSGMaterialShader.GraphicsPipelineState value2){
            return operator_equal_native_cref_QSGMaterialShader_GraphicsPipelineState(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value2));
        }
        
        @io.qt.QtUninvokable
        private native boolean operator_equal_native_cref_QSGMaterialShader_GraphicsPipelineState(long __this__nativeId, long value2);
        
        @io.qt.QtUninvokable
        public final void setBlendConstant(io.qt.gui.QColor blendConstant){
            setBlendConstant_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(blendConstant));
        }
        
        @io.qt.QtUninvokable
        private native void setBlendConstant_native_cref_QColor(long __this__nativeId, long blendConstant);
        
        @io.qt.QtUninvokable
        public final io.qt.gui.QColor blendConstant(){
            return blendConstant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QColor blendConstant_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setBlendEnable(boolean blendEnable){
            setBlendEnable_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), blendEnable);
        }
        
        @io.qt.QtUninvokable
        private native void setBlendEnable_native_bool(long __this__nativeId, boolean blendEnable);
        
        @io.qt.QtUninvokable
        public final boolean blendEnable(){
            return blendEnable_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean blendEnable_native(long __this__nativeId);
        
        /**
         * <p>Overloaded function for {@link #setColorWrite(io.qt.quick.QSGMaterialShader.GraphicsPipelineState.ColorMask)}.</p>
         */
        @io.qt.QtUninvokable
        public final void setColorWrite(io.qt.quick.QSGMaterialShader.GraphicsPipelineState.ColorMaskComponent ... colorWrite){
            setColorWrite(new io.qt.quick.QSGMaterialShader.GraphicsPipelineState.ColorMask(colorWrite));
        }
        
        @io.qt.QtUninvokable
        public final void setColorWrite(io.qt.quick.QSGMaterialShader.GraphicsPipelineState.ColorMask colorWrite){
            setColorWrite_native_cref_QFlags_QSGMaterialShader_GraphicsPipelineState_ColorMaskComponent_(QtJambi_LibraryUtilities.internal.nativeId(this), colorWrite.value());
        }
        
        @io.qt.QtUninvokable
        private native void setColorWrite_native_cref_QFlags_QSGMaterialShader_GraphicsPipelineState_ColorMaskComponent_(long __this__nativeId, int colorWrite);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialShader.GraphicsPipelineState.ColorMask colorWrite(){
            return new io.qt.quick.QSGMaterialShader.GraphicsPipelineState.ColorMask(colorWrite_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int colorWrite_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setCullMode(io.qt.quick.QSGMaterialShader.GraphicsPipelineState.CullMode cullMode){
            setCullMode_native_cref_QSGMaterialShader_GraphicsPipelineState_CullMode(QtJambi_LibraryUtilities.internal.nativeId(this), cullMode.value());
        }
        
        @io.qt.QtUninvokable
        private native void setCullMode_native_cref_QSGMaterialShader_GraphicsPipelineState_CullMode(long __this__nativeId, int cullMode);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialShader.GraphicsPipelineState.CullMode cullMode(){
            return io.qt.quick.QSGMaterialShader.GraphicsPipelineState.CullMode.resolve(cullMode_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int cullMode_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setDstColor(io.qt.quick.QSGMaterialShader.GraphicsPipelineState.BlendFactor dstColor){
            setDstColor_native_cref_QSGMaterialShader_GraphicsPipelineState_BlendFactor(QtJambi_LibraryUtilities.internal.nativeId(this), dstColor.value());
        }
        
        @io.qt.QtUninvokable
        private native void setDstColor_native_cref_QSGMaterialShader_GraphicsPipelineState_BlendFactor(long __this__nativeId, int dstColor);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialShader.GraphicsPipelineState.BlendFactor dstColor(){
            return io.qt.quick.QSGMaterialShader.GraphicsPipelineState.BlendFactor.resolve(dstColor_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int dstColor_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setSrcColor(io.qt.quick.QSGMaterialShader.GraphicsPipelineState.BlendFactor srcColor){
            setSrcColor_native_cref_QSGMaterialShader_GraphicsPipelineState_BlendFactor(QtJambi_LibraryUtilities.internal.nativeId(this), srcColor.value());
        }
        
        @io.qt.QtUninvokable
        private native void setSrcColor_native_cref_QSGMaterialShader_GraphicsPipelineState_BlendFactor(long __this__nativeId, int srcColor);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialShader.GraphicsPipelineState.BlendFactor srcColor(){
            return io.qt.quick.QSGMaterialShader.GraphicsPipelineState.BlendFactor.resolve(srcColor_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int srcColor_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected GraphicsPipelineState(QPrivateConstructor p) { super(p); } 
        

        @Override
        @io.qt.QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.quick.QSGMaterialShader.GraphicsPipelineState) {
                return operator_equal((io.qt.quick.QSGMaterialShader.GraphicsPipelineState) other);
            }

            return false;
        }


        @io.qt.QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        @Override
        public GraphicsPipelineState clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native GraphicsPipelineState clone_native(long __this_nativeId);
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader.html#QSGMaterialShader">QSGMaterialShader::QSGMaterialShader()</a></p>
     */
    public QSGMaterialShader(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGMaterialShader instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader.html#flags">QSGMaterialShader::flags()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGMaterialShader.Flags flags(){
        return new io.qt.quick.QSGMaterialShader.Flags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setFlag(io.qt.quick.QSGMaterialShader.Flags, boolean)}
     *  with <code>on = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QSGMaterialShader.Flags flags) {
        setFlag(flags, (boolean)true);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader.html#setFlag">QSGMaterialShader::setFlag(QSGMaterialShader::Flags,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QSGMaterialShader.Flags flags, boolean on){
        setFlag_native_QFlags_QSGMaterialShader_Flag__bool(QtJambi_LibraryUtilities.internal.nativeId(this), flags.value(), on);
    }
    
    @io.qt.QtUninvokable
    private native void setFlag_native_QFlags_QSGMaterialShader_Flag__bool(long __this__nativeId, int flags, boolean on);
    
    /**
     * <p>Overloaded function for {@link #setFlags(io.qt.quick.QSGMaterialShader.Flags)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setFlags(io.qt.quick.QSGMaterialShader.Flag ... flags){
        setFlags(new io.qt.quick.QSGMaterialShader.Flags(flags));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader.html#setFlags">QSGMaterialShader::setFlags(QSGMaterialShader::Flags)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFlags(io.qt.quick.QSGMaterialShader.Flags flags){
        setFlags_native_QFlags_QSGMaterialShader_Flag_(QtJambi_LibraryUtilities.internal.nativeId(this), flags.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFlags_native_QFlags_QSGMaterialShader_Flag_(long __this__nativeId, int flags);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader.html#setShaderFileName">QSGMaterialShader::setShaderFileName(QSGMaterialShader::Stage,QString)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setShaderFileName(io.qt.quick.QSGMaterialShader.Stage stage, java.lang.String filename){
        setShaderFileName_native_QSGMaterialShader_Stage_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), stage.value(), filename);
    }
    
    @io.qt.QtUninvokable
    private native void setShaderFileName_native_QSGMaterialShader_Stage_cref_QString(long __this__nativeId, int stage, java.lang.String filename);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader.html#updateGraphicsPipelineState">QSGMaterialShader::updateGraphicsPipelineState(QSGMaterialShader::RenderState&amp;,QSGMaterialShader::GraphicsPipelineState*,QSGMaterial*,QSGMaterial*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean updateGraphicsPipelineState(io.qt.quick.QSGMaterialShader.RenderState state, io.qt.quick.QSGMaterialShader.GraphicsPipelineState ps, io.qt.quick.QSGMaterial newMaterial, io.qt.quick.QSGMaterial oldMaterial){
        java.util.Objects.requireNonNull(state, "Argument 'state': null not expected.");
        return updateGraphicsPipelineState_native_ref_QSGMaterialShader_RenderState_QSGMaterialShader_GraphicsPipelineState_ptr_QSGMaterial_ptr_QSGMaterial_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), state, ps, QtJambi_LibraryUtilities.internal.checkedNativeId(newMaterial), QtJambi_LibraryUtilities.internal.checkedNativeId(oldMaterial));
    }
    
    @io.qt.QtUninvokable
    private native boolean updateGraphicsPipelineState_native_ref_QSGMaterialShader_RenderState_QSGMaterialShader_GraphicsPipelineState_ptr_QSGMaterial_ptr_QSGMaterial_ptr(long __this__nativeId, io.qt.quick.QSGMaterialShader.RenderState state, io.qt.quick.QSGMaterialShader.GraphicsPipelineState ps, long newMaterial, long oldMaterial);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader.html#updateSampledImage">QSGMaterialShader::updateSampledImage(QSGMaterialShader::RenderState&amp;,int,QSGTexture**,QSGMaterial*,QSGMaterial*)</a></p>
     */
    @io.qt.QtUninvokable
    public void updateSampledImage(io.qt.quick.QSGMaterialShader.RenderState state, int binding, io.qt.quick.QSGTexture[] texture, io.qt.quick.QSGMaterial newMaterial, io.qt.quick.QSGMaterial oldMaterial){
        java.util.Objects.requireNonNull(state, "Argument 'state': null not expected.");
        if(texture!=null && texture.length < 1)
            throw new IllegalArgumentException("Argument 'texture': Wrong number of elements in array. Found: " + texture.length + ", expected: 1");
        updateSampledImage_native_ref_QSGMaterialShader_RenderState_int_QSGTexture_ptr_ptr_QSGMaterial_ptr_QSGMaterial_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), state, binding, texture, QtJambi_LibraryUtilities.internal.checkedNativeId(newMaterial), QtJambi_LibraryUtilities.internal.checkedNativeId(oldMaterial));
    }
    
    @io.qt.QtUninvokable
    private native void updateSampledImage_native_ref_QSGMaterialShader_RenderState_int_QSGTexture_ptr_ptr_QSGMaterial_ptr_QSGMaterial_ptr(long __this__nativeId, io.qt.quick.QSGMaterialShader.RenderState state, int binding, io.qt.quick.QSGTexture[] texture, long newMaterial, long oldMaterial);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterialshader.html#updateUniformData">QSGMaterialShader::updateUniformData(QSGMaterialShader::RenderState&amp;,QSGMaterial*,QSGMaterial*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean updateUniformData(io.qt.quick.QSGMaterialShader.RenderState state, io.qt.quick.QSGMaterial newMaterial, io.qt.quick.QSGMaterial oldMaterial){
        java.util.Objects.requireNonNull(state, "Argument 'state': null not expected.");
        return updateUniformData_native_ref_QSGMaterialShader_RenderState_QSGMaterial_ptr_QSGMaterial_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), state, QtJambi_LibraryUtilities.internal.checkedNativeId(newMaterial), QtJambi_LibraryUtilities.internal.checkedNativeId(oldMaterial));
    }
    
    @io.qt.QtUninvokable
    private native boolean updateUniformData_native_ref_QSGMaterialShader_RenderState_QSGMaterial_ptr_QSGMaterial_ptr(long __this__nativeId, io.qt.quick.QSGMaterialShader.RenderState state, long newMaterial, long oldMaterial);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGMaterialShader(QPrivateConstructor p) { super(p); } 
    
}
