package io.qt.quick;


/**
 * <p>Encapsulates rendering state for a shader program</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgmaterial.html">QSGMaterial</a></p>
 */
public abstract class QSGMaterial extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSGMaterial {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QSGMaterialShader createShader(io.qt.quick.QSGRendererInterface.RenderMode renderMode){
            return createShader_native_QSGRendererInterface_RenderMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), renderMode.value());
        }
        @io.qt.QtUninvokable
        private native io.qt.quick.QSGMaterialShader createShader_native_QSGRendererInterface_RenderMode_constfct(long __this__nativeId, int renderMode);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QSGMaterialType type(){
            return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.quick.QSGMaterialType type_native_constfct(long __this__nativeId);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgmaterial.html#Flag-enum">QSGMaterial::Flag</a></p>
     * 
     * @see Flags
     */
    public enum Flag implements io.qt.QtFlagEnumerator {
        Blending(1),
        RequiresDeterminant(2),
        RequiresFullMatrixExceptTranslate(6),
        RequiresFullMatrix(14),
        CustomCompileStep(16);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Flag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Flags asFlags() {
            return new Flags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Flags combined(Flag e) {
            return new Flags(this, e);
        }

        /**
         * Creates a new {@link Flags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Flags flags(Flag ... values) {
            return new Flags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Flag resolve(int value) {
            switch (value) {
            case 1: return Blending;
            case 2: return RequiresDeterminant;
            case 6: return RequiresFullMatrixExceptTranslate;
            case 14: return RequiresFullMatrix;
            case 16: return CustomCompileStep;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Flag}
     */
    public static final class Flags extends io.qt.QFlags<Flag> implements Comparable<Flags> {
        private static final long serialVersionUID = 0x92d9bce6c929c1c6L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Flags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Flags(Flag ... args){
            super(args);
        }

        /**
         * Creates a new Flags with given <code>value</code>.
         * @param value
         */
        public Flags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Flags
         */
        @Override
        public final Flags combined(Flag e){
            return new Flags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Flags setFlag(Flag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Flags setFlag(Flag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Flags.
         * @return array of enum entries
         */
        @Override
        public final Flag[] flags(){
            return super.flags(Flag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Flags clone(){
            return new Flags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Flags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    public QSGMaterial(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGMaterial instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#flags">QSGMaterial::flags()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGMaterial.Flags flags(){
        return new io.qt.quick.QSGMaterial.Flags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setFlag(io.qt.quick.QSGMaterial.Flags, boolean)}
     *  with <code>on = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QSGMaterial.Flags flags) {
        setFlag(flags, (boolean)true);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#setFlag">QSGMaterial::setFlag(QSGMaterial::Flags,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QSGMaterial.Flags flags, boolean on){
        setFlag_native_QFlags_QSGMaterial_Flag__bool(QtJambi_LibraryUtilities.internal.nativeId(this), flags.value(), on);
    }
    
    @io.qt.QtUninvokable
    private native void setFlag_native_QFlags_QSGMaterial_Flag__bool(long __this__nativeId, int flags, boolean on);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#compare">QSGMaterial::compare(const QSGMaterial*)const</a></p>
     */
    @io.qt.QtUninvokable
    public int compare(io.qt.quick.QSGMaterial other){
        return compare_native_const_QSGMaterial_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native int compare_native_const_QSGMaterial_ptr_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#createShader">QSGMaterial::createShader(QSGRendererInterface::RenderMode)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QSGMaterialShader createShader(io.qt.quick.QSGRendererInterface.RenderMode renderMode);
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterialShader createShader_native_QSGRendererInterface_RenderMode_constfct(long __this__nativeId, int renderMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#type">QSGMaterial::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QSGMaterialType type();
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterialType type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGMaterial(QPrivateConstructor p) { super(p); } 
    
}
