package io.qt.quick;


/**
 * <p>Provided for convenience to easily draw textured content using the QML scene graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgimagenode.html">QSGImageNode</a></p>
 */
public abstract class QSGImageNode extends io.qt.quick.QSGGeometryNode
{
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSGImageNode {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QSGTexture.AnisotropyLevel anisotropyLevel(){
            return io.qt.quick.QSGTexture.AnisotropyLevel.resolve(anisotropyLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int anisotropyLevel_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QSGTexture.Filtering filtering(){
            return io.qt.quick.QSGTexture.Filtering.resolve(filtering_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int filtering_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QSGTexture.Filtering mipmapFiltering(){
            return io.qt.quick.QSGTexture.Filtering.resolve(mipmapFiltering_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int mipmapFiltering_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean ownsTexture(){
            return ownsTexture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean ownsTexture_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QRectF rect(){
            return rect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QRectF rect_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setAnisotropyLevel(io.qt.quick.QSGTexture.AnisotropyLevel level){
            setAnisotropyLevel_native_QSGTexture_AnisotropyLevel(QtJambi_LibraryUtilities.internal.nativeId(this), level.value());
        }
        @io.qt.QtUninvokable
        private native void setAnisotropyLevel_native_QSGTexture_AnisotropyLevel(long __this__nativeId, int level);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setFiltering(io.qt.quick.QSGTexture.Filtering filtering){
            setFiltering_native_QSGTexture_Filtering(QtJambi_LibraryUtilities.internal.nativeId(this), filtering.value());
        }
        @io.qt.QtUninvokable
        private native void setFiltering_native_QSGTexture_Filtering(long __this__nativeId, int filtering);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setMipmapFiltering(io.qt.quick.QSGTexture.Filtering filtering){
            setMipmapFiltering_native_QSGTexture_Filtering(QtJambi_LibraryUtilities.internal.nativeId(this), filtering.value());
        }
        @io.qt.QtUninvokable
        private native void setMipmapFiltering_native_QSGTexture_Filtering(long __this__nativeId, int filtering);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setOwnsTexture(boolean owns){
            setOwnsTexture_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), owns);
        }
        @io.qt.QtUninvokable
        private native void setOwnsTexture_native_bool(long __this__nativeId, boolean owns);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setRect(io.qt.core.QRectF rect){
            setRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
        }
        @io.qt.QtUninvokable
        private native void setRect_native_cref_QRectF(long __this__nativeId, long rect);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setSourceRect(io.qt.core.QRectF r){
            setSourceRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(r));
        }
        @io.qt.QtUninvokable
        private native void setSourceRect_native_cref_QRectF(long __this__nativeId, long r);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setTexture(io.qt.quick.QSGTexture texture){
            setTexture_native_QSGTexture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
        }
        @io.qt.QtUninvokable
        private native void setTexture_native_QSGTexture_ptr(long __this__nativeId, long texture);
        
        
        @Override
        @io.qt.QtUninvokable
        public void setTextureCoordinatesTransform(io.qt.quick.QSGImageNode.TextureCoordinatesTransformMode mode){
            setTextureCoordinatesTransform_native_QFlags_QSGImageNode_TextureCoordinatesTransformFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
        }
        @io.qt.QtUninvokable
        private native void setTextureCoordinatesTransform_native_QFlags_QSGImageNode_TextureCoordinatesTransformFlag_(long __this__nativeId, int mode);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QRectF sourceRect(){
            return sourceRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QRectF sourceRect_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QSGTexture texture(){
            return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.quick.QSGTexture texture_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QSGImageNode.TextureCoordinatesTransformMode textureCoordinatesTransform(){
            return new io.qt.quick.QSGImageNode.TextureCoordinatesTransformMode(textureCoordinatesTransform_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int textureCoordinatesTransform_native_constfct(long __this__nativeId);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qsgimagenode.html#TextureCoordinatesTransformFlag-enum">QSGImageNode::TextureCoordinatesTransformFlag</a></p>
     * 
     * @see TextureCoordinatesTransformMode
     */
    public enum TextureCoordinatesTransformFlag implements io.qt.QtFlagEnumerator {
        NoTransform(0),
        MirrorHorizontally(1),
        MirrorVertically(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TextureCoordinatesTransformFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public TextureCoordinatesTransformMode asFlags() {
            return new TextureCoordinatesTransformMode(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public TextureCoordinatesTransformMode combined(TextureCoordinatesTransformFlag e) {
            return new TextureCoordinatesTransformMode(this, e);
        }

        /**
         * Creates a new {@link TextureCoordinatesTransformMode} from the entries.
         * @param values entries
         * @return new flag
         */
        public static TextureCoordinatesTransformMode flags(TextureCoordinatesTransformFlag ... values) {
            return new TextureCoordinatesTransformMode(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TextureCoordinatesTransformFlag resolve(int value) {
            switch (value) {
            case 0: return NoTransform;
            case 1: return MirrorHorizontally;
            case 2: return MirrorVertically;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link TextureCoordinatesTransformFlag}
     */
    public static final class TextureCoordinatesTransformMode extends io.qt.QFlags<TextureCoordinatesTransformFlag> implements Comparable<TextureCoordinatesTransformMode> {
        private static final long serialVersionUID = 0x3c2d18e789f64e04L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new TextureCoordinatesTransformMode where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public TextureCoordinatesTransformMode(TextureCoordinatesTransformFlag ... args){
            super(args);
        }

        /**
         * Creates a new TextureCoordinatesTransformMode with given <code>value</code>.
         * @param value
         */
        public TextureCoordinatesTransformMode(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new TextureCoordinatesTransformMode
         */
        @Override
        public final TextureCoordinatesTransformMode combined(TextureCoordinatesTransformFlag e){
            return new TextureCoordinatesTransformMode(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final TextureCoordinatesTransformMode setFlag(TextureCoordinatesTransformFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final TextureCoordinatesTransformMode setFlag(TextureCoordinatesTransformFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this TextureCoordinatesTransformMode.
         * @return array of enum entries
         */
        @Override
        public final TextureCoordinatesTransformFlag[] flags(){
            return super.flags(TextureCoordinatesTransformFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final TextureCoordinatesTransformMode clone(){
            return new TextureCoordinatesTransformMode(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(TextureCoordinatesTransformMode other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    public QSGImageNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGImageNode instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setRect-1">QSGImageNode::setRect(qreal,qreal,qreal,qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRect(double x, double y, double w, double h){
        setRect_native_qreal_qreal_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, w, h);
    }
    
    @io.qt.QtUninvokable
    private native void setRect_native_qreal_qreal_qreal_qreal(long __this__nativeId, double x, double y, double w, double h);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setSourceRect-1">QSGImageNode::setSourceRect(qreal,qreal,qreal,qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSourceRect(double x, double y, double w, double h){
        setSourceRect_native_qreal_qreal_qreal_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, w, h);
    }
    
    @io.qt.QtUninvokable
    private native void setSourceRect_native_qreal_qreal_qreal_qreal(long __this__nativeId, double x, double y, double w, double h);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#anisotropyLevel">QSGImageNode::anisotropyLevel()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QSGTexture.AnisotropyLevel anisotropyLevel();
    
    @io.qt.QtUninvokable
    private native int anisotropyLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#filtering">QSGImageNode::filtering()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QSGTexture.Filtering filtering();
    
    @io.qt.QtUninvokable
    private native int filtering_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#mipmapFiltering">QSGImageNode::mipmapFiltering()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QSGTexture.Filtering mipmapFiltering();
    
    @io.qt.QtUninvokable
    private native int mipmapFiltering_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#ownsTexture">QSGImageNode::ownsTexture()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean ownsTexture();
    
    @io.qt.QtUninvokable
    private native boolean ownsTexture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#rect">QSGImageNode::rect()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QRectF rect();
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF rect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setAnisotropyLevel">QSGImageNode::setAnisotropyLevel(QSGTexture::AnisotropyLevel)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setAnisotropyLevel(io.qt.quick.QSGTexture.AnisotropyLevel level);
    
    @io.qt.QtUninvokable
    private native void setAnisotropyLevel_native_QSGTexture_AnisotropyLevel(long __this__nativeId, int level);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setFiltering">QSGImageNode::setFiltering(QSGTexture::Filtering)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setFiltering(io.qt.quick.QSGTexture.Filtering filtering);
    
    @io.qt.QtUninvokable
    private native void setFiltering_native_QSGTexture_Filtering(long __this__nativeId, int filtering);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setMipmapFiltering">QSGImageNode::setMipmapFiltering(QSGTexture::Filtering)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setMipmapFiltering(io.qt.quick.QSGTexture.Filtering filtering);
    
    @io.qt.QtUninvokable
    private native void setMipmapFiltering_native_QSGTexture_Filtering(long __this__nativeId, int filtering);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setOwnsTexture">QSGImageNode::setOwnsTexture(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setOwnsTexture(boolean owns);
    
    @io.qt.QtUninvokable
    private native void setOwnsTexture_native_bool(long __this__nativeId, boolean owns);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setRect">QSGImageNode::setRect(QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setRect(io.qt.core.QRectF rect);
    
    @io.qt.QtUninvokable
    private native void setRect_native_cref_QRectF(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setSourceRect">QSGImageNode::setSourceRect(QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setSourceRect(io.qt.core.QRectF r);
    
    @io.qt.QtUninvokable
    private native void setSourceRect_native_cref_QRectF(long __this__nativeId, long r);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setTexture">QSGImageNode::setTexture(QSGTexture*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setTexture(io.qt.quick.QSGTexture texture);
    
    @io.qt.QtUninvokable
    private native void setTexture_native_QSGTexture_ptr(long __this__nativeId, long texture);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#setTextureCoordinatesTransform">QSGImageNode::setTextureCoordinatesTransform(QSGImageNode::TextureCoordinatesTransformMode)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void setTextureCoordinatesTransform(io.qt.quick.QSGImageNode.TextureCoordinatesTransformMode mode);
    
    @io.qt.QtUninvokable
    private native void setTextureCoordinatesTransform_native_QFlags_QSGImageNode_TextureCoordinatesTransformFlag_(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#sourceRect">QSGImageNode::sourceRect()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QRectF sourceRect();
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF sourceRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#texture">QSGImageNode::texture()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QSGTexture texture();
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTexture texture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#textureCoordinatesTransform">QSGImageNode::textureCoordinatesTransform()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QSGImageNode.TextureCoordinatesTransformMode textureCoordinatesTransform();
    
    @io.qt.QtUninvokable
    private native int textureCoordinatesTransform_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #rebuildGeometry(io.qt.quick.QSGGeometry, io.qt.quick.QSGTexture, io.qt.core.QRectF, io.qt.core.QRectF, io.qt.quick.QSGImageNode.TextureCoordinatesTransformMode)}.</p>
     */
    public static void rebuildGeometry(io.qt.quick.QSGGeometry g, io.qt.quick.QSGTexture texture, io.qt.core.QRectF rect, io.qt.core.QRectF sourceRect, io.qt.quick.QSGImageNode.TextureCoordinatesTransformFlag ... texCoordMode){
        rebuildGeometry(g, texture, rect, sourceRect, new io.qt.quick.QSGImageNode.TextureCoordinatesTransformMode(texCoordMode));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgimagenode.html#rebuildGeometry">QSGImageNode::rebuildGeometry(QSGGeometry*,QSGTexture*,QRectF,QRectF,QSGImageNode::TextureCoordinatesTransformMode)</a></p>
     */
    public static void rebuildGeometry(io.qt.quick.QSGGeometry g, io.qt.quick.QSGTexture texture, io.qt.core.QRectF rect, io.qt.core.QRectF sourceRect, io.qt.quick.QSGImageNode.TextureCoordinatesTransformMode texCoordMode){
        rebuildGeometry_native_QSGGeometry_ptr_QSGTexture_ptr_cref_QRectF_QRectF_QFlags_QSGImageNode_TextureCoordinatesTransformFlag_(QtJambi_LibraryUtilities.internal.checkedNativeId(g), QtJambi_LibraryUtilities.internal.checkedNativeId(texture), QtJambi_LibraryUtilities.internal.checkedNativeId(rect), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceRect), texCoordMode.value());
    }
    
    private native static void rebuildGeometry_native_QSGGeometry_ptr_QSGTexture_ptr_cref_QRectF_QRectF_QFlags_QSGImageNode_TextureCoordinatesTransformFlag_(long g, long texture, long rect, long sourceRect, int texCoordMode);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGImageNode(QPrivateConstructor p) { super(p); } 
    
}
