package io.qt.quick;


/**
 * <p>Used for all rendered content in the scene graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsggeometrynode.html">QSGGeometryNode</a></p>
 */
public class QSGGeometryNode extends io.qt.quick.QSGBasicGeometryNode
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcMaterial = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcOpaqueMaterial = null;
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsggeometrynode.html#QSGGeometryNode">QSGGeometryNode::QSGGeometryNode()</a></p>
     */
    public QSGGeometryNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGGeometryNode instance);
    
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGMaterial activeMaterial(){
        return activeMaterial_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterial activeMaterial_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final double inheritedOpacity(){
        return inheritedOpacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double inheritedOpacity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsggeometrynode.html#material">QSGGeometryNode::material()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGMaterial material(){
        return material_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterial material_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsggeometrynode.html#opaqueMaterial">QSGGeometryNode::opaqueMaterial()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGMaterial opaqueMaterial(){
        return opaqueMaterial_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterial opaqueMaterial_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final int renderOrder(){
        return renderOrder_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int renderOrder_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void setInheritedOpacity(double opacity){
        setInheritedOpacity_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), opacity);
    }
    
    @io.qt.QtUninvokable
    private native void setInheritedOpacity_native_qreal(long __this__nativeId, double opacity);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsggeometrynode.html#setMaterial">QSGGeometryNode::setMaterial(QSGMaterial*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMaterial(io.qt.quick.QSGMaterial material){
        setMaterial_native_QSGMaterial_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(material));
        if (flags().testFlag(QSGNode.Flag.OwnsMaterial)) {
            QtJambi_LibraryUtilities.internal.setCppOwnership(material);
        }
        if (!flags().testFlag(QSGNode.Flag.OwnsMaterial)) {
            __rcMaterial = material;
        }
    }
    
    @io.qt.QtUninvokable
    private native void setMaterial_native_QSGMaterial_ptr(long __this__nativeId, long material);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsggeometrynode.html#setOpaqueMaterial">QSGGeometryNode::setOpaqueMaterial(QSGMaterial*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setOpaqueMaterial(io.qt.quick.QSGMaterial material){
        setOpaqueMaterial_native_QSGMaterial_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(material));
        if (flags().testFlag(QSGNode.Flag.OwnsOpaqueMaterial)) {
            QtJambi_LibraryUtilities.internal.setCppOwnership(material);
        }
        if (!flags().testFlag(QSGNode.Flag.OwnsOpaqueMaterial)) {
            __rcOpaqueMaterial = material;
        }
    }
    
    @io.qt.QtUninvokable
    private native void setOpaqueMaterial_native_QSGMaterial_ptr(long __this__nativeId, long material);
    
    @io.qt.QtUninvokable
    public final void setRenderOrder(int order){
        setRenderOrder_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), order);
    }
    
    @io.qt.QtUninvokable
    private native void setRenderOrder_native_int(long __this__nativeId, int order);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGGeometryNode(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
}
