package io.qt.quick;


/**
 * <p>Convenient way of rendering solid colored geometry in the scene graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgflatcolormaterial.html">QSGFlatColorMaterial</a></p>
 */
public class QSGFlatColorMaterial extends io.qt.quick.QSGMaterial
{
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgflatcolormaterial.html#QSGFlatColorMaterial">QSGFlatColorMaterial::QSGFlatColorMaterial()</a></p>
     */
    public QSGFlatColorMaterial(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGFlatColorMaterial instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgflatcolormaterial.html#color">QSGFlatColorMaterial::color()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor color(){
        return color_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor color_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgflatcolormaterial.html#setColor">QSGFlatColorMaterial::setColor(QColor)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setColor(io.qt.gui.QColor color){
        setColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#compare">QSGMaterial::compare(const QSGMaterial*)const</a></p>
     */
    @io.qt.QtUninvokable
    public int compare(io.qt.quick.QSGMaterial other){
        return compare_native_const_QSGMaterial_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native int compare_native_const_QSGMaterial_ptr_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#createShader">QSGMaterial::createShader(QSGRendererInterface::RenderMode)const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGMaterialShader createShader(io.qt.quick.QSGRendererInterface.RenderMode renderMode){
        return createShader_native_QSGRendererInterface_RenderMode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), renderMode.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterialShader createShader_native_QSGRendererInterface_RenderMode_constfct(long __this__nativeId, int renderMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgmaterial.html#type">QSGMaterial::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGMaterialType type(){
        return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGMaterialType type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGFlatColorMaterial(QPrivateConstructor p) { super(p); } 
    
}
