package io.qt.quick;


/**
 * <p>Implements the clipping functionality in the scene graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qsgclipnode.html">QSGClipNode</a></p>
 */
public class QSGClipNode extends io.qt.quick.QSGBasicGeometryNode
{
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgclipnode.html#QSGClipNode">QSGClipNode::QSGClipNode()</a></p>
     */
    public QSGClipNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGClipNode instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgclipnode.html#clipRect">QSGClipNode::clipRect()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF clipRect(){
        return clipRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF clipRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgclipnode.html#isRectangular">QSGClipNode::isRectangular()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isRectangular(){
        return isRectangular_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isRectangular_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgclipnode.html#setClipRect">QSGClipNode::setClipRect(QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setClipRect(io.qt.core.QRectF arg__1){
        setClipRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setClipRect_native_cref_QRectF(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qsgclipnode.html#setIsRectangular">QSGClipNode::setIsRectangular(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setIsRectangular(boolean rectHint){
        setIsRectangular_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), rectHint);
    }
    
    @io.qt.QtUninvokable
    private native void setIsRectangular_native_bool(long __this__nativeId, boolean rectHint);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGClipNode(QPrivateConstructor p) { super(p); } 
    
}
