package io.qt.quick;


/**
 * <p>Opaque container for native graphics resources specifying a render target, and associated metadata</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qquickrendertarget.html">QQuickRenderTarget</a></p>
 */
public class QQuickRenderTarget extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendertarget.html#QQuickRenderTarget">QQuickRenderTarget::QQuickRenderTarget()</a></p>
     */
    public QQuickRenderTarget(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QQuickRenderTarget instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendertarget.html#QQuickRenderTarget">QQuickRenderTarget::QQuickRenderTarget(QQuickRenderTarget)</a></p>
     */
    public QQuickRenderTarget(io.qt.quick.QQuickRenderTarget other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QQuickRenderTarget instance, io.qt.quick.QQuickRenderTarget other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendertarget.html#isNull">QQuickRenderTarget::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendertarget.html#operator-eq-eq">operator==(QQuickRenderTarget,QQuickRenderTarget)</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.quick.QQuickRenderTarget rhs){
        return operator_equal_native_cref_QQuickRenderTarget(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QQuickRenderTarget(long __this__nativeId, long rhs);
    
    /**
     * <p>Overloaded function for {@link #fromD3D11Texture(io.qt.QNativePointer, io.qt.core.QSize, int)}
     *  with <code>sampleCount = 1</code>.</p>
     */
    public static io.qt.quick.QQuickRenderTarget fromD3D11Texture(io.qt.QNativePointer texture, io.qt.core.QSize pixelSize) {
        return fromD3D11Texture(texture, pixelSize, (int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendertarget.html#fromD3D11Texture">QQuickRenderTarget::fromD3D11Texture(void*,QSize,int)</a></p>
     */
    public static io.qt.quick.QQuickRenderTarget fromD3D11Texture(io.qt.QNativePointer texture, io.qt.core.QSize pixelSize, int sampleCount){
        return fromD3D11Texture_native_void_ptr_cref_QSize_int(texture, QtJambi_LibraryUtilities.internal.checkedNativeId(pixelSize), sampleCount);
    }
    
    private native static io.qt.quick.QQuickRenderTarget fromD3D11Texture_native_void_ptr_cref_QSize_int(io.qt.QNativePointer texture, long pixelSize, int sampleCount);
    
    /**
     * <p>Overloaded function for {@link #fromMetalTexture(io.qt.QNativePointer, io.qt.core.QSize, int)}
     *  with <code>sampleCount = 1</code>.</p>
     */
    public static io.qt.quick.QQuickRenderTarget fromMetalTexture(io.qt.QNativePointer texture, io.qt.core.QSize pixelSize) {
        return fromMetalTexture(texture, pixelSize, (int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendertarget.html#fromMetalTexture">QQuickRenderTarget::fromMetalTexture(MTLTexture*,QSize,int)</a></p>
     */
    public static io.qt.quick.QQuickRenderTarget fromMetalTexture(io.qt.QNativePointer texture, io.qt.core.QSize pixelSize, int sampleCount){
        return fromMetalTexture_native_MTLTexture_ptr_cref_QSize_int(texture, QtJambi_LibraryUtilities.internal.checkedNativeId(pixelSize), sampleCount);
    }
    
    private native static io.qt.quick.QQuickRenderTarget fromMetalTexture_native_MTLTexture_ptr_cref_QSize_int(io.qt.QNativePointer texture, long pixelSize, int sampleCount);
    
    /**
     * <p>Overloaded function for {@link #fromOpenGLRenderBuffer(int, io.qt.core.QSize, int)}
     *  with <code>sampleCount = 1</code>.</p>
     */
    public static io.qt.quick.QQuickRenderTarget fromOpenGLRenderBuffer(int renderbufferId, io.qt.core.QSize pixelSize) {
        return fromOpenGLRenderBuffer(renderbufferId, pixelSize, (int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendertarget.html#fromOpenGLRenderBuffer">QQuickRenderTarget::fromOpenGLRenderBuffer(uint,QSize,int)</a></p>
     */
    public static io.qt.quick.QQuickRenderTarget fromOpenGLRenderBuffer(int renderbufferId, io.qt.core.QSize pixelSize, int sampleCount){
        return fromOpenGLRenderBuffer_native_uint_cref_QSize_int(renderbufferId, QtJambi_LibraryUtilities.internal.checkedNativeId(pixelSize), sampleCount);
    }
    
    private native static io.qt.quick.QQuickRenderTarget fromOpenGLRenderBuffer_native_uint_cref_QSize_int(int renderbufferId, long pixelSize, int sampleCount);
    
    /**
     * <p>Overloaded function for {@link #fromOpenGLTexture(int, io.qt.core.QSize, int)}
     *  with <code>sampleCount = 1</code>.</p>
     */
    public static io.qt.quick.QQuickRenderTarget fromOpenGLTexture(int textureId, io.qt.core.QSize pixelSize) {
        return fromOpenGLTexture(textureId, pixelSize, (int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendertarget.html#fromOpenGLTexture">QQuickRenderTarget::fromOpenGLTexture(uint,QSize,int)</a></p>
     */
    public static io.qt.quick.QQuickRenderTarget fromOpenGLTexture(int textureId, io.qt.core.QSize pixelSize, int sampleCount){
        return fromOpenGLTexture_native_uint_cref_QSize_int(textureId, QtJambi_LibraryUtilities.internal.checkedNativeId(pixelSize), sampleCount);
    }
    
    private native static io.qt.quick.QQuickRenderTarget fromOpenGLTexture_native_uint_cref_QSize_int(int textureId, long pixelSize, int sampleCount);
    
    /**
     * <p>Overloaded function for {@link #fromVulkanImage(long, int, io.qt.core.QSize, int)}
     *  with <code>sampleCount = 1</code>.</p>
     */
    public static io.qt.quick.QQuickRenderTarget fromVulkanImage(long image, int layout, io.qt.core.QSize pixelSize) {
        return fromVulkanImage(image, layout, pixelSize, (int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendertarget.html#fromVulkanImage">QQuickRenderTarget::fromVulkanImage(VkImage,VkImageLayout,QSize,int)</a></p>
     */
    public static io.qt.quick.QQuickRenderTarget fromVulkanImage(long image, int layout, io.qt.core.QSize pixelSize, int sampleCount){
        return fromVulkanImage_native_VkImage_VkImageLayout_cref_QSize_int(image, layout, QtJambi_LibraryUtilities.internal.checkedNativeId(pixelSize), sampleCount);
    }
    
    private native static io.qt.quick.QQuickRenderTarget fromVulkanImage_native_VkImage_VkImageLayout_cref_QSize_int(long image, int layout, long pixelSize, int sampleCount);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickRenderTarget(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.quick.QQuickRenderTarget) {
            return operator_equal((io.qt.quick.QQuickRenderTarget) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QQuickRenderTarget clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QQuickRenderTarget clone_native(long __this_nativeId);
}
