package io.qt.quick;


/**
 * <p>Mechanism for rendering the Qt Quick scenegraph onto an offscreen render target in a fully application-controlled manner</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qquickrendercontrol.html">QQuickRenderControl</a></p>
 */
public class QQuickRenderControl extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickRenderControl.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#renderRequested">QQuickRenderControl::renderRequested()</a></p>
     */
    public final Signal0 renderRequested = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#sceneChanged">QQuickRenderControl::sceneChanged()</a></p>
     */
    public final Signal0 sceneChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QQuickRenderControl(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickRenderControl() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#QQuickRenderControl">QQuickRenderControl::QQuickRenderControl(QObject*)</a></p>
     */
    public QQuickRenderControl(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickRenderControl instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#beginFrame">QQuickRenderControl::beginFrame()</a></p>
     */
    @io.qt.QtUninvokable
    public final void beginFrame(){
        beginFrame_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void beginFrame_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#endFrame">QQuickRenderControl::endFrame()</a></p>
     */
    @io.qt.QtUninvokable
    public final void endFrame(){
        endFrame_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void endFrame_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#initialize">QQuickRenderControl::initialize()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean initialize(){
        return initialize_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean initialize_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#invalidate">QQuickRenderControl::invalidate()</a></p>
     */
    @io.qt.QtUninvokable
    public final void invalidate(){
        invalidate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void invalidate_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#polishItems">QQuickRenderControl::polishItems()</a></p>
     */
    @io.qt.QtUninvokable
    public final void polishItems(){
        polishItems_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void polishItems_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#prepareThread">QQuickRenderControl::prepareThread(QThread*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void prepareThread(io.qt.core.QThread targetThread){
        prepareThread_native_QThread_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(targetThread));
    }
    
    @io.qt.QtUninvokable
    private native void prepareThread_native_QThread_ptr(long __this__nativeId, long targetThread);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#render">QQuickRenderControl::render()</a></p>
     */
    @io.qt.QtUninvokable
    public final void render(){
        render_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void render_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#samples">QQuickRenderControl::samples()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int samples(){
        return samples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int samples_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#setSamples">QQuickRenderControl::setSamples(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSamples(int sampleCount){
        setSamples_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), sampleCount);
    }
    
    @io.qt.QtUninvokable
    private native void setSamples_native_int(long __this__nativeId, int sampleCount);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#sync">QQuickRenderControl::sync()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean sync(){
        return sync_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean sync_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#window">QQuickRenderControl::window()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickWindow window(){
        return window_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickWindow window_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#renderWindow">QQuickRenderControl::renderWindow(QPoint*)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QWindow renderWindow(io.qt.core.QPoint offset){
        return renderWindow_native_QPoint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QWindow renderWindow_native_QPoint_ptr(long __this__nativeId, io.qt.core.QPoint offset);
    
    /**
     * <p>Overloaded function for {@link #renderWindowFor(io.qt.quick.QQuickWindow, io.qt.core.QPoint)}
     *  with <code>offset = null</code>.</p>
     */
    public static io.qt.gui.QWindow renderWindowFor(io.qt.quick.QQuickWindow win) {
        return renderWindowFor(win, (io.qt.core.QPoint)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickrendercontrol.html#renderWindowFor">QQuickRenderControl::renderWindowFor(QQuickWindow*,QPoint*)</a></p>
     */
    public static io.qt.gui.QWindow renderWindowFor(io.qt.quick.QQuickWindow win, io.qt.core.QPoint offset){
        return renderWindowFor_native_QQuickWindow_ptr_QPoint_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(win), offset);
    }
    
    private native static io.qt.gui.QWindow renderWindowFor_native_QQuickWindow_ptr_QPoint_ptr(long win, io.qt.core.QPoint offset);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickRenderControl(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickRenderControl(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickRenderControl instance, QDeclarativeConstructor constructor);
    
}
