package io.qt.quick;


/**
 * <p>Way to use the QPainter API in the QML Scene Graph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qquickpainteditem.html">QQuickPaintedItem</a></p>
 */
public abstract class QQuickPaintedItem extends io.qt.quick.QQuickItem
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickPaintedItem.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QQuickPaintedItem {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public void paint(io.qt.gui.QPainter painter){
            paint_native_QPainter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter));
        }
        @io.qt.QtUninvokable
        private native void paint_native_QPainter_ptr(long __this__nativeId, long painter);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qquickpainteditem.html#PerformanceHint-enum">QQuickPaintedItem::PerformanceHint</a></p>
     * 
     * @see PerformanceHints
     */
    public enum PerformanceHint implements io.qt.QtFlagEnumerator {
        FastFBOResizing(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PerformanceHint(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public PerformanceHints asFlags() {
            return new PerformanceHints(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public PerformanceHints combined(PerformanceHint e) {
            return new PerformanceHints(this, e);
        }

        /**
         * Creates a new {@link PerformanceHints} from the entries.
         * @param values entries
         * @return new flag
         */
        public static PerformanceHints flags(PerformanceHint ... values) {
            return new PerformanceHints(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PerformanceHint resolve(int value) {
            switch (value) {
            case 1: return FastFBOResizing;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link PerformanceHint}
     */
    public static final class PerformanceHints extends io.qt.QFlags<PerformanceHint> implements Comparable<PerformanceHints> {
        private static final long serialVersionUID = 0xbaffb66d8763819eL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new PerformanceHints where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public PerformanceHints(PerformanceHint ... args){
            super(args);
        }

        /**
         * Creates a new PerformanceHints with given <code>value</code>.
         * @param value
         */
        public PerformanceHints(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new PerformanceHints
         */
        @Override
        public final PerformanceHints combined(PerformanceHint e){
            return new PerformanceHints(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final PerformanceHints setFlag(PerformanceHint e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final PerformanceHints setFlag(PerformanceHint e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this PerformanceHints.
         * @return array of enum entries
         */
        @Override
        public final PerformanceHint[] flags(){
            return super.flags(PerformanceHint.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final PerformanceHints clone(){
            return new PerformanceHints(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(PerformanceHints other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qquickpainteditem.html#RenderTarget-enum">QQuickPaintedItem::RenderTarget</a></p>
     */
    public enum RenderTarget implements io.qt.QtEnumerator {
        Image(0),
        FramebufferObject(1),
        InvertedYFramebufferObject(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RenderTarget(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RenderTarget resolve(int value) {
            switch (value) {
            case 0: return Image;
            case 1: return FramebufferObject;
            case 2: return InvertedYFramebufferObject;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem-obsolete.html#contentsScale-prop">QQuickPaintedItem::contentsScaleChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="contentsScale")
    public final Signal0 contentsScaleChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem-obsolete.html#contentsSize-prop">QQuickPaintedItem::contentsSizeChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="contentsSize")
    public final Signal0 contentsSizeChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#fillColor-prop">QQuickPaintedItem::fillColorChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="fillColor")
    public final Signal0 fillColorChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#renderTarget-prop">QQuickPaintedItem::renderTargetChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="renderTarget")
    public final Signal0 renderTargetChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#textureSize-prop">QQuickPaintedItem::textureSizeChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="textureSize")
    public final Signal0 textureSizeChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QQuickPaintedItem(io.qt.quick.QQuickItem)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickPaintedItem() {
        this((io.qt.quick.QQuickItem)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#QQuickPaintedItem">QQuickPaintedItem::QQuickPaintedItem(QQuickItem*)</a></p>
     */
    public QQuickPaintedItem(io.qt.quick.QQuickItem parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickPaintedItem instance, io.qt.quick.QQuickItem parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#antialiasing">QQuickPaintedItem::antialiasing()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean paintAntialiasing(){
        return paintAntialiasing_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean paintAntialiasing_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF contentsBoundingRect(){
        return contentsBoundingRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF contentsBoundingRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem-obsolete.html#contentsScale-prop">QQuickPaintedItem::contentsScale()const</a></p>
     */
    @io.qt.QtPropertyReader(name="contentsScale")
    @io.qt.QtUninvokable
    public final double contentsScale(){
        return contentsScale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double contentsScale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem-obsolete.html#contentsSize-prop">QQuickPaintedItem::contentsSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="contentsSize")
    @io.qt.QtUninvokable
    public final io.qt.core.QSize contentsSize(){
        return contentsSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize contentsSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#fillColor-prop">QQuickPaintedItem::fillColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="fillColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor fillColor(){
        return fillColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor fillColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#mipmap">QQuickPaintedItem::mipmap()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean mipmap(){
        return mipmap_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean mipmap_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#opaquePainting">QQuickPaintedItem::opaquePainting()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean opaquePainting(){
        return opaquePainting_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean opaquePainting_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#performanceHints">QQuickPaintedItem::performanceHints()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickPaintedItem.PerformanceHints performanceHints(){
        return new io.qt.quick.QQuickPaintedItem.PerformanceHints(performanceHints_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int performanceHints_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#renderTarget-prop">QQuickPaintedItem::renderTarget()const</a></p>
     */
    @io.qt.QtPropertyReader(name="renderTarget")
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickPaintedItem.RenderTarget renderTarget(){
        return io.qt.quick.QQuickPaintedItem.RenderTarget.resolve(renderTarget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int renderTarget_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void resetContentsSize(){
        resetContentsSize_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void resetContentsSize_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#setAntialiasing">QQuickPaintedItem::setAntialiasing(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPaintAntialiasing(boolean enable){
        setPaintAntialiasing_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setPaintAntialiasing_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem-obsolete.html#contentsScale-prop">QQuickPaintedItem::setContentsScale(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="contentsScale")
    @io.qt.QtUninvokable
    public final void setContentsScale(double arg__1){
        setContentsScale_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setContentsScale_native_qreal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem-obsolete.html#contentsSize-prop">QQuickPaintedItem::setContentsSize(QSize)</a></p>
     */
    @io.qt.QtPropertyWriter(name="contentsSize")
    @io.qt.QtUninvokable
    public final void setContentsSize(io.qt.core.QSize arg__1){
        setContentsSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setContentsSize_native_cref_QSize(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#fillColor-prop">QQuickPaintedItem::setFillColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="fillColor")
    @io.qt.QtUninvokable
    public final void setFillColor(io.qt.gui.QColor arg__1){
        setFillColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setFillColor_native_cref_QColor(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#setMipmap">QQuickPaintedItem::setMipmap(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMipmap(boolean enable){
        setMipmap_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setMipmap_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#setOpaquePainting">QQuickPaintedItem::setOpaquePainting(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setOpaquePainting(boolean opaque){
        setOpaquePainting_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), opaque);
    }
    
    @io.qt.QtUninvokable
    private native void setOpaquePainting_native_bool(long __this__nativeId, boolean opaque);
    
    /**
     * <p>Overloaded function for {@link #setPerformanceHint(io.qt.quick.QQuickPaintedItem.PerformanceHint, boolean)}
     *  with <code>enabled = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setPerformanceHint(io.qt.quick.QQuickPaintedItem.PerformanceHint hint) {
        setPerformanceHint(hint, (boolean)true);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#setPerformanceHint">QQuickPaintedItem::setPerformanceHint(QQuickPaintedItem::PerformanceHint,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPerformanceHint(io.qt.quick.QQuickPaintedItem.PerformanceHint hint, boolean enabled){
        setPerformanceHint_native_QQuickPaintedItem_PerformanceHint_bool(QtJambi_LibraryUtilities.internal.nativeId(this), hint.value(), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setPerformanceHint_native_QQuickPaintedItem_PerformanceHint_bool(long __this__nativeId, int hint, boolean enabled);
    
    /**
     * <p>Overloaded function for {@link #setPerformanceHints(io.qt.quick.QQuickPaintedItem.PerformanceHints)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setPerformanceHints(io.qt.quick.QQuickPaintedItem.PerformanceHint ... hints){
        setPerformanceHints(new io.qt.quick.QQuickPaintedItem.PerformanceHints(hints));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#setPerformanceHints">QQuickPaintedItem::setPerformanceHints(QQuickPaintedItem::PerformanceHints)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPerformanceHints(io.qt.quick.QQuickPaintedItem.PerformanceHints hints){
        setPerformanceHints_native_QFlags_QQuickPaintedItem_PerformanceHint_(QtJambi_LibraryUtilities.internal.nativeId(this), hints.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPerformanceHints_native_QFlags_QQuickPaintedItem_PerformanceHint_(long __this__nativeId, int hints);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#renderTarget-prop">QQuickPaintedItem::setRenderTarget(QQuickPaintedItem::RenderTarget)</a></p>
     */
    @io.qt.QtPropertyWriter(name="renderTarget")
    @io.qt.QtUninvokable
    public final void setRenderTarget(io.qt.quick.QQuickPaintedItem.RenderTarget target){
        setRenderTarget_native_QQuickPaintedItem_RenderTarget(QtJambi_LibraryUtilities.internal.nativeId(this), target.value());
    }
    
    @io.qt.QtUninvokable
    private native void setRenderTarget_native_QQuickPaintedItem_RenderTarget(long __this__nativeId, int target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#textureSize-prop">QQuickPaintedItem::setTextureSize(QSize)</a></p>
     */
    @io.qt.QtPropertyWriter(name="textureSize")
    @io.qt.QtUninvokable
    public final void setTextureSize(io.qt.core.QSize size){
        setTextureSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setTextureSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#textureSize-prop">QQuickPaintedItem::textureSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="textureSize")
    @io.qt.QtUninvokable
    public final io.qt.core.QSize textureSize(){
        return textureSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize textureSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#update">QQuickPaintedItem::update(QRect)</a></p>
     */
    @io.qt.QtUninvokable
    public final void update(io.qt.core.QRect rect){
        update_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native void update_native_cref_QRect(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickitem.html#isTextureProvider">QQuickItem::isTextureProvider()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isTextureProvider(){
        return isTextureProvider_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isTextureProvider_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickitem.html#itemChange">QQuickItem::itemChange(QQuickItem::ItemChange,QQuickItem::ItemChangeData)</a></p>
     */
    @io.qt.QtUninvokable
    protected void itemChange(io.qt.quick.QQuickItem.ItemChange arg__1, java.lang.Object arg__2){
        itemChange_native_QQuickItem_ItemChange_cref_QQuickItem_ItemChangeData(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value(), arg__2);
    }
    
    @io.qt.QtUninvokable
    private native void itemChange_native_QQuickItem_ItemChange_cref_QQuickItem_ItemChangeData(long __this__nativeId, int arg__1, java.lang.Object arg__2);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickpainteditem.html#paint">QQuickPaintedItem::paint(QPainter*)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void paint(io.qt.gui.QPainter painter);
    
    @io.qt.QtUninvokable
    private native void paint_native_QPainter_ptr(long __this__nativeId, long painter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickitem.html#releaseResources">QQuickItem::releaseResources()</a></p>
     */
    @io.qt.QtUninvokable
    protected void releaseResources(){
        releaseResources_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void releaseResources_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickitem.html#textureProvider">QQuickItem::textureProvider()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGTextureProvider textureProvider(){
        return textureProvider_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTextureProvider textureProvider_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickitem.html#updatePaintNode">QQuickItem::updatePaintNode(QSGNode*,QQuickItem::UpdatePaintNodeData*)</a></p>
     */
    @io.qt.QtUninvokable
    protected io.qt.quick.QSGNode updatePaintNode(io.qt.quick.QSGNode arg__1, io.qt.quick.QQuickItem.UpdatePaintNodeData arg__2){
        io.qt.quick.QSGNode __qt_return_value = updatePaintNode_native_QSGNode_ptr_QQuickItem_UpdatePaintNodeData_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
        QtJambi_LibraryUtilities.internal.invalidateObject(arg__1);
        return __qt_return_value;
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNode updatePaintNode_native_QSGNode_ptr_QQuickItem_UpdatePaintNodeData_ptr(long __this__nativeId, long arg__1, long arg__2);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickPaintedItem(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickPaintedItem(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickPaintedItem instance, QDeclarativeConstructor constructor);
    
}
