package io.qt.quick;


/**
 * <p>Interface for supporting pixmaps and threaded image requests in QML</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qquickimageprovider.html">QQuickImageProvider</a></p>
 */
public class QQuickImageProvider extends io.qt.qml.QQmlImageProviderBase
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickImageProvider.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType, io.qt.qml.QQmlImageProviderBase.Flags)}.</p>
     */
    @SuppressWarnings({"exports"})
    public QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType type, io.qt.qml.QQmlImageProviderBase.Flag ... flags){
        this(type, new io.qt.qml.QQmlImageProviderBase.Flags(flags));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType, io.qt.qml.QQmlImageProviderBase.Flags)}
     *  with <code>flags = new io.qt.qml.QQmlImageProviderBase.Flags(0)</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType type) {
        this(type, new io.qt.qml.QQmlImageProviderBase.Flags(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickimageprovider.html#QQuickImageProvider">QQuickImageProvider::QQuickImageProvider(QQmlImageProviderBase::ImageType,QQmlImageProviderBase::Flags)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType type, io.qt.qml.QQmlImageProviderBase.Flags flags){
        super((QPrivateConstructor)null);
        initialize_native(this, type, flags);
    }
    
    private native static void initialize_native(QQuickImageProvider instance, io.qt.qml.QQmlImageProviderBase.ImageType type, io.qt.qml.QQmlImageProviderBase.Flags flags);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlimageproviderbase.html#flags">QQmlImageProviderBase::flags()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public io.qt.qml.QQmlImageProviderBase.Flags flags(){
        return new io.qt.qml.QQmlImageProviderBase.Flags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qqmlimageproviderbase.html#imageType">QQmlImageProviderBase::imageType()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public io.qt.qml.QQmlImageProviderBase.ImageType imageType(){
        return io.qt.qml.QQmlImageProviderBase.ImageType.resolve(imageType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int imageType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickimageprovider.html#requestImage">QQuickImageProvider::requestImage(QString,QSize*,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QImage requestImage(java.lang.String id, io.qt.core.QSize size, io.qt.core.QSize requestedSize){
        return requestImage_native_cref_QString_QSize_ptr_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), id, size, QtJambi_LibraryUtilities.internal.checkedNativeId(requestedSize));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage requestImage_native_cref_QString_QSize_ptr_cref_QSize(long __this__nativeId, java.lang.String id, io.qt.core.QSize size, long requestedSize);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickimageprovider.html#requestPixmap">QQuickImageProvider::requestPixmap(QString,QSize*,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QPixmap requestPixmap(java.lang.String id, io.qt.core.QSize size, io.qt.core.QSize requestedSize){
        return requestPixmap_native_cref_QString_QSize_ptr_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), id, size, QtJambi_LibraryUtilities.internal.checkedNativeId(requestedSize));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QPixmap requestPixmap_native_cref_QString_QSize_ptr_cref_QSize(long __this__nativeId, java.lang.String id, io.qt.core.QSize size, long requestedSize);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickimageprovider.html#requestTexture">QQuickImageProvider::requestTexture(QString,QSize*,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QQuickTextureFactory requestTexture(java.lang.String id, io.qt.core.QSize size, io.qt.core.QSize requestedSize){
        return requestTexture_native_cref_QString_QSize_ptr_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), id, size, QtJambi_LibraryUtilities.internal.checkedNativeId(requestedSize));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickTextureFactory requestTexture_native_cref_QString_QSize_ptr_cref_QSize(long __this__nativeId, java.lang.String id, io.qt.core.QSize size, long requestedSize);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickImageProvider(QPrivateConstructor p) { super(p); } 
    
}
