package io.qt.quick;


/**
 * <p>Opaque container for native graphics objects representing graphics devices or contexts</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qquickgraphicsdevice.html">QQuickGraphicsDevice</a></p>
 */
public class QQuickGraphicsDevice extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsdevice.html#QQuickGraphicsDevice">QQuickGraphicsDevice::QQuickGraphicsDevice()</a></p>
     */
    public QQuickGraphicsDevice(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QQuickGraphicsDevice instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsdevice.html#QQuickGraphicsDevice">QQuickGraphicsDevice::QQuickGraphicsDevice(QQuickGraphicsDevice)</a></p>
     */
    public QQuickGraphicsDevice(io.qt.quick.QQuickGraphicsDevice other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QQuickGraphicsDevice instance, io.qt.quick.QQuickGraphicsDevice other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsdevice.html#isNull">QQuickGraphicsDevice::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.quick.QQuickGraphicsDevice value2){
        return operator_equal_native_cref_QQuickGraphicsDevice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value2));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QQuickGraphicsDevice(long __this__nativeId, long value2);
    
    /**
     * <p>Overloaded function for {@link #fromAdapter(int, int, int)}
     *  with <code>featureLevel = 0</code>.</p>
     */
    public static io.qt.quick.QQuickGraphicsDevice fromAdapter(int adapterLuidLow, int adapterLuidHigh) {
        return fromAdapter(adapterLuidLow, adapterLuidHigh, (int)0);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsdevice.html#fromAdapter">QQuickGraphicsDevice::fromAdapter(quint32,qint32,int)</a></p>
     */
    public native static io.qt.quick.QQuickGraphicsDevice fromAdapter(int adapterLuidLow, int adapterLuidHigh, int featureLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsdevice.html#fromOpenGLContext">QQuickGraphicsDevice::fromOpenGLContext(QOpenGLContext*)</a></p>
     */
    public static io.qt.quick.QQuickGraphicsDevice fromOpenGLContext(io.qt.gui.QOpenGLContext context){
        return fromOpenGLContext_native_QOpenGLContext_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    private native static io.qt.quick.QQuickGraphicsDevice fromOpenGLContext_native_QOpenGLContext_ptr(long context);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickGraphicsDevice(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.quick.QQuickGraphicsDevice) {
            return operator_equal((io.qt.quick.QQuickGraphicsDevice) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QQuickGraphicsDevice clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QQuickGraphicsDevice clone_native(long __this_nativeId);
}
