package io.qt.quick;


/**
 * <p>Container for low-level graphics settings that can affect how the underlying graphics API, such as Vulkan, is initialized by the Qt Quick scene graph. It can also control certain aspects of the scene graph renderer</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qquickgraphicsconfiguration.html">QQuickGraphicsConfiguration</a></p>
 */
public class QQuickGraphicsConfiguration extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsconfiguration.html#QQuickGraphicsConfiguration">QQuickGraphicsConfiguration::QQuickGraphicsConfiguration()</a></p>
     */
    public QQuickGraphicsConfiguration(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QQuickGraphicsConfiguration instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsconfiguration.html#QQuickGraphicsConfiguration">QQuickGraphicsConfiguration::QQuickGraphicsConfiguration(QQuickGraphicsConfiguration)</a></p>
     */
    public QQuickGraphicsConfiguration(io.qt.quick.QQuickGraphicsConfiguration other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QQuickGraphicsConfiguration instance, io.qt.quick.QQuickGraphicsConfiguration other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsconfiguration.html#deviceExtensions">QQuickGraphicsConfiguration::deviceExtensions()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.core.QByteArray> deviceExtensions(){
        return deviceExtensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.core.QByteArray> deviceExtensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsconfiguration.html#isDepthBufferEnabledFor2D">QQuickGraphicsConfiguration::isDepthBufferEnabledFor2D()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isDepthBufferEnabledFor2D(){
        return isDepthBufferEnabledFor2D_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDepthBufferEnabledFor2D_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.quick.QQuickGraphicsConfiguration value2){
        return operator_equal_native_cref_QQuickGraphicsConfiguration(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value2));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QQuickGraphicsConfiguration(long __this__nativeId, long value2);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsconfiguration.html#setDepthBufferFor2D">QQuickGraphicsConfiguration::setDepthBufferFor2D(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDepthBufferFor2D(boolean enable){
        setDepthBufferFor2D_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setDepthBufferFor2D_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsconfiguration.html#setDeviceExtensions">QQuickGraphicsConfiguration::setDeviceExtensions(QByteArrayList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDeviceExtensions(java.util.Collection<? extends io.qt.core.QByteArray> extensions){
        setDeviceExtensions_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), extensions);
    }
    
    @io.qt.QtUninvokable
    private native void setDeviceExtensions_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.core.QByteArray> extensions);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickgraphicsconfiguration.html#preferredInstanceExtensions">QQuickGraphicsConfiguration::preferredInstanceExtensions()</a></p>
     */
    public native static io.qt.core.QList<io.qt.core.QByteArray> preferredInstanceExtensions();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickGraphicsConfiguration(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.quick.QQuickGraphicsConfiguration) {
            return operator_equal((io.qt.quick.QQuickGraphicsConfiguration) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QQuickGraphicsConfiguration clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QQuickGraphicsConfiguration clone_native(long __this_nativeId);
}
