package io.qt.quick;


/**
 * <p>Interface for for asynchronous control of QML image requests</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qquickasyncimageprovider.html">QQuickAsyncImageProvider</a></p>
 */
public abstract class QQuickAsyncImageProvider extends io.qt.quick.QQuickImageProvider
{
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QQuickAsyncImageProvider {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QQuickImageResponse requestImageResponse(java.lang.String id, io.qt.core.QSize requestedSize){
            return requestImageResponse_native_cref_QString_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), id, QtJambi_LibraryUtilities.internal.checkedNativeId(requestedSize));
        }
        @io.qt.QtUninvokable
        private native io.qt.quick.QQuickImageResponse requestImageResponse_native_cref_QString_cref_QSize(long __this__nativeId, java.lang.String id, long requestedSize);
        
    }
    
    
    public QQuickAsyncImageProvider(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QQuickAsyncImageProvider instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qquickasyncimageprovider.html#requestImageResponse">QQuickAsyncImageProvider::requestImageResponse(QString,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QQuickImageResponse requestImageResponse(java.lang.String id, io.qt.core.QSize requestedSize);
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickImageResponse requestImageResponse_native_cref_QString_cref_QSize(long __this__nativeId, java.lang.String id, long requestedSize);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickAsyncImageProvider(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickAsyncImageProvider(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickAsyncImageProvider instance, QDeclarativeConstructor constructor);
    
}
