package io.qt.quick;


/**
 * <p>Baseclass for textures used in the scene graph</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgtexture.html">QSGTexture</a></p>
 */
public abstract class QSGTexture extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSGTexture.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSGTexture {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public void bind(){
            bind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void bind_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean hasAlphaChannel(){
            return hasAlphaChannel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean hasAlphaChannel_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean hasMipmaps(){
            return hasMipmaps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean hasMipmaps_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public int textureId(){
            return textureId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native int textureId_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QSize textureSize(){
            return textureSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QSize textureSize_native_constfct(long __this__nativeId);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgtexture.html#AnisotropyLevel-enum">QSGTexture::AnisotropyLevel</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum AnisotropyLevel implements io.qt.QtEnumerator {
        AnisotropyNone(0),
        Anisotropy2x(1),
        Anisotropy4x(2),
        Anisotropy8x(3),
        Anisotropy16x(4);

        private AnisotropyLevel(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AnisotropyLevel resolve(int value) {
            switch (value) {
            case 0: return AnisotropyNone;
            case 1: return Anisotropy2x;
            case 2: return Anisotropy4x;
            case 3: return Anisotropy8x;
            case 4: return Anisotropy16x;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgtexture.html#Filtering-enum">QSGTexture::Filtering</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum Filtering implements io.qt.QtEnumerator {
        None(0),
        Nearest(1),
        Linear(2);

        private Filtering(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Filtering resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Nearest;
            case 2: return Linear;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgtexture.html#WrapMode-enum">QSGTexture::WrapMode</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum WrapMode implements io.qt.QtEnumerator {
        Repeat(0),
        ClampToEdge(1),
        MirroredRepeat(2);

        private WrapMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static WrapMode resolve(int value) {
            switch (value) {
            case 0: return Repeat;
            case 1: return ClampToEdge;
            case 2: return MirroredRepeat;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#QSGTexture">QSGTexture::QSGTexture()</a></p>
     */
    public QSGTexture(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGTexture instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#anisotropyLevel">QSGTexture::anisotropyLevel()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.AnisotropyLevel anisotropyLevel(){
        return io.qt.quick.QSGTexture.AnisotropyLevel.resolve(anisotropyLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int anisotropyLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#comparisonKey">QSGTexture::comparisonKey()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int comparisonKey(){
        return comparisonKey_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int comparisonKey_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#convertToNormalizedSourceRect">QSGTexture::convertToNormalizedSourceRect(QRectF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF convertToNormalizedSourceRect(io.qt.core.QRectF rect){
        return convertToNormalizedSourceRect_native_cref_QRectF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF convertToNormalizedSourceRect_native_cref_QRectF_constfct(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#filtering">QSGTexture::filtering()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.Filtering filtering(){
        return io.qt.quick.QSGTexture.Filtering.resolve(filtering_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int filtering_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#horizontalWrapMode">QSGTexture::horizontalWrapMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.WrapMode horizontalWrapMode(){
        return io.qt.quick.QSGTexture.WrapMode.resolve(horizontalWrapMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int horizontalWrapMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#mipmapFiltering">QSGTexture::mipmapFiltering()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.Filtering mipmapFiltering(){
        return io.qt.quick.QSGTexture.Filtering.resolve(mipmapFiltering_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int mipmapFiltering_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#setAnisotropyLevel">QSGTexture::setAnisotropyLevel(QSGTexture::AnisotropyLevel)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAnisotropyLevel(io.qt.quick.QSGTexture.AnisotropyLevel level){
        setAnisotropyLevel_native_QSGTexture_AnisotropyLevel(QtJambi_LibraryUtilities.internal.nativeId(this), level.value());
    }
    
    @io.qt.QtUninvokable
    private native void setAnisotropyLevel_native_QSGTexture_AnisotropyLevel(long __this__nativeId, int level);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#setFiltering">QSGTexture::setFiltering(QSGTexture::Filtering)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFiltering(io.qt.quick.QSGTexture.Filtering filter){
        setFiltering_native_QSGTexture_Filtering(QtJambi_LibraryUtilities.internal.nativeId(this), filter.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFiltering_native_QSGTexture_Filtering(long __this__nativeId, int filter);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#setHorizontalWrapMode">QSGTexture::setHorizontalWrapMode(QSGTexture::WrapMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHorizontalWrapMode(io.qt.quick.QSGTexture.WrapMode hwrap){
        setHorizontalWrapMode_native_QSGTexture_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), hwrap.value());
    }
    
    @io.qt.QtUninvokable
    private native void setHorizontalWrapMode_native_QSGTexture_WrapMode(long __this__nativeId, int hwrap);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#setMipmapFiltering">QSGTexture::setMipmapFiltering(QSGTexture::Filtering)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMipmapFiltering(io.qt.quick.QSGTexture.Filtering filter){
        setMipmapFiltering_native_QSGTexture_Filtering(QtJambi_LibraryUtilities.internal.nativeId(this), filter.value());
    }
    
    @io.qt.QtUninvokable
    private native void setMipmapFiltering_native_QSGTexture_Filtering(long __this__nativeId, int filter);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#setVerticalWrapMode">QSGTexture::setVerticalWrapMode(QSGTexture::WrapMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setVerticalWrapMode(io.qt.quick.QSGTexture.WrapMode vwrap){
        setVerticalWrapMode_native_QSGTexture_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), vwrap.value());
    }
    
    @io.qt.QtUninvokable
    private native void setVerticalWrapMode_native_QSGTexture_WrapMode(long __this__nativeId, int vwrap);
    
    /**
     * <p>Overloaded function for {@link #updateBindOptions(boolean)}
     *  with <code>force = false</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void updateBindOptions() {
        updateBindOptions((boolean)false);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#updateBindOptions">QSGTexture::updateBindOptions(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void updateBindOptions(boolean force){
        updateBindOptions_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), force);
    }
    
    @io.qt.QtUninvokable
    private native void updateBindOptions_native_bool(long __this__nativeId, boolean force);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#verticalWrapMode">QSGTexture::verticalWrapMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.WrapMode verticalWrapMode(){
        return io.qt.quick.QSGTexture.WrapMode.resolve(verticalWrapMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int verticalWrapMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#bind">QSGTexture::bind()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void bind();
    
    @io.qt.QtUninvokable
    private native void bind_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#hasAlphaChannel">QSGTexture::hasAlphaChannel()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean hasAlphaChannel();
    
    @io.qt.QtUninvokable
    private native boolean hasAlphaChannel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#hasMipmaps">QSGTexture::hasMipmaps()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean hasMipmaps();
    
    @io.qt.QtUninvokable
    private native boolean hasMipmaps_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#isAtlasTexture">QSGTexture::isAtlasTexture()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isAtlasTexture(){
        return isAtlasTexture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAtlasTexture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#normalizedTextureSubRect">QSGTexture::normalizedTextureSubRect()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QRectF normalizedTextureSubRect(){
        return normalizedTextureSubRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF normalizedTextureSubRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#textureId">QSGTexture::textureId()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract int textureId();
    
    @io.qt.QtUninvokable
    private native int textureId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgtexture.html#textureSize">QSGTexture::textureSize()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QSize textureSize();
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize textureSize_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGTexture(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSGTexture(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSGTexture instance, QDeclarativeConstructor constructor);
    
}
