package io.qt.quick;


/**
 * <p>Provided for convenience to easily draw textured content using the QML scene graph</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html">QSGSimpleTextureNode</a></p>
 */
public class QSGSimpleTextureNode extends io.qt.quick.QSGGeometryNode
{
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#TextureCoordinatesTransformFlag-enum">QSGSimpleTextureNode::TextureCoordinatesTransformFlag</a></p>
     * 
     * @see TextureCoordinatesTransformMode
     */
    public enum TextureCoordinatesTransformFlag implements io.qt.QtFlagEnumerator {
        NoTransform(0),
        MirrorHorizontally(1),
        MirrorVertically(2);

        private TextureCoordinatesTransformFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public TextureCoordinatesTransformMode asFlags() {
            return new TextureCoordinatesTransformMode(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public TextureCoordinatesTransformMode combined(TextureCoordinatesTransformFlag e) {
            return new TextureCoordinatesTransformMode(this, e);
        }

        /**
         * Creates a new {@link TextureCoordinatesTransformMode} from the entries.
         * @param values entries
         * @return new flag
         */
        public static TextureCoordinatesTransformMode flags(TextureCoordinatesTransformFlag ... values) {
            return new TextureCoordinatesTransformMode(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TextureCoordinatesTransformFlag resolve(int value) {
            switch (value) {
            case 0: return NoTransform;
            case 1: return MirrorHorizontally;
            case 2: return MirrorVertically;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link TextureCoordinatesTransformFlag}
     */
    public static final class TextureCoordinatesTransformMode extends io.qt.QFlags<TextureCoordinatesTransformFlag> implements Comparable<TextureCoordinatesTransformMode> {
        private static final long serialVersionUID = 0x3c2d18e789f64e04L;

        /**
         * Creates a new TextureCoordinatesTransformMode where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public TextureCoordinatesTransformMode(TextureCoordinatesTransformFlag ... args){
            super(args);
        }

        /**
         * Creates a new TextureCoordinatesTransformMode with given <code>value</code>.
         * @param value
         */
        public TextureCoordinatesTransformMode(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new TextureCoordinatesTransformMode
         */
        @Override
        public final TextureCoordinatesTransformMode combined(TextureCoordinatesTransformFlag e){
            return new TextureCoordinatesTransformMode(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final TextureCoordinatesTransformMode setFlag(TextureCoordinatesTransformFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final TextureCoordinatesTransformMode setFlag(TextureCoordinatesTransformFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this TextureCoordinatesTransformMode.
         * @return array of enum entries
         */
        @Override
        public final TextureCoordinatesTransformFlag[] flags(){
            return super.flags(TextureCoordinatesTransformFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final TextureCoordinatesTransformMode clone(){
            return new TextureCoordinatesTransformMode(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(TextureCoordinatesTransformMode other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#QSGSimpleTextureNode">QSGSimpleTextureNode::QSGSimpleTextureNode()</a></p>
     */
    public QSGSimpleTextureNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGSimpleTextureNode instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#filtering">QSGSimpleTextureNode::filtering()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture.Filtering filtering(){
        return io.qt.quick.QSGTexture.Filtering.resolve(filtering_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int filtering_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#ownsTexture">QSGSimpleTextureNode::ownsTexture()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean ownsTexture(){
        return ownsTexture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean ownsTexture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#rect">QSGSimpleTextureNode::rect()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF rect(){
        return rect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF rect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#setFiltering">QSGSimpleTextureNode::setFiltering(QSGTexture::Filtering)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFiltering(io.qt.quick.QSGTexture.Filtering filtering){
        setFiltering_native_QSGTexture_Filtering(QtJambi_LibraryUtilities.internal.nativeId(this), filtering.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFiltering_native_QSGTexture_Filtering(long __this__nativeId, int filtering);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#setOwnsTexture">QSGSimpleTextureNode::setOwnsTexture(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setOwnsTexture(boolean owns){
        setOwnsTexture_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), owns);
        if (texture() != null) {
            if(owns){
                QtJambi_LibraryUtilities.internal.setCppOwnership(texture());
            }else{
                QtJambi_LibraryUtilities.internal.setJavaOwnership(texture());
            }
        }
    }
    
    @io.qt.QtUninvokable
    private native void setOwnsTexture_native_bool(long __this__nativeId, boolean owns);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#setRect">QSGSimpleTextureNode::setRect(QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRect(io.qt.core.QRectF rect){
        setRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native void setRect_native_cref_QRectF(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#setRect-1">QSGSimpleTextureNode::setRect(qreal,qreal,qreal,qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRect(double x, double y, double w, double h){
        setRect_native_qtjambireal_qtjambireal_qtjambireal_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, w, h);
    }
    
    @io.qt.QtUninvokable
    private native void setRect_native_qtjambireal_qtjambireal_qtjambireal_qtjambireal(long __this__nativeId, double x, double y, double w, double h);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#setSourceRect">QSGSimpleTextureNode::setSourceRect(QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSourceRect(io.qt.core.QRectF r){
        setSourceRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(r));
    }
    
    @io.qt.QtUninvokable
    private native void setSourceRect_native_cref_QRectF(long __this__nativeId, long r);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#setSourceRect-1">QSGSimpleTextureNode::setSourceRect(qreal,qreal,qreal,qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSourceRect(double x, double y, double w, double h){
        setSourceRect_native_qtjambireal_qtjambireal_qtjambireal_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, w, h);
    }
    
    @io.qt.QtUninvokable
    private native void setSourceRect_native_qtjambireal_qtjambireal_qtjambireal_qtjambireal(long __this__nativeId, double x, double y, double w, double h);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#setTexture">QSGSimpleTextureNode::setTexture(QSGTexture*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTexture(io.qt.quick.QSGTexture texture){
        setTexture_native_QSGTexture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
        if (texture != null && ownsTexture()) {
            QtJambi_LibraryUtilities.internal.setCppOwnership(texture);
        }
    }
    
    @io.qt.QtUninvokable
    private native void setTexture_native_QSGTexture_ptr(long __this__nativeId, long texture);
    
    /**
     * <p>Overloaded function for {@link #setTextureCoordinatesTransform(io.qt.quick.QSGSimpleTextureNode.TextureCoordinatesTransformMode)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setTextureCoordinatesTransform(io.qt.quick.QSGSimpleTextureNode.TextureCoordinatesTransformFlag ... mode){
        setTextureCoordinatesTransform(new io.qt.quick.QSGSimpleTextureNode.TextureCoordinatesTransformMode(mode));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#setTextureCoordinatesTransform">QSGSimpleTextureNode::setTextureCoordinatesTransform(TextureCoordinatesTransformMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTextureCoordinatesTransform(io.qt.quick.QSGSimpleTextureNode.TextureCoordinatesTransformMode mode){
        setTextureCoordinatesTransform_native_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setTextureCoordinatesTransform_native_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#sourceRect">QSGSimpleTextureNode::sourceRect()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF sourceRect(){
        return sourceRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF sourceRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#texture">QSGSimpleTextureNode::texture()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTexture texture_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimpletexturenode.html#textureCoordinatesTransform">QSGSimpleTextureNode::textureCoordinatesTransform()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGSimpleTextureNode.TextureCoordinatesTransformMode textureCoordinatesTransform(){
        return new io.qt.quick.QSGSimpleTextureNode.TextureCoordinatesTransformMode(textureCoordinatesTransform_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int textureCoordinatesTransform_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGSimpleTextureNode(QPrivateConstructor p) { super(p); } 
    
}
