package io.qt.quick;


/**
 * <p>Convenience class for drawing solid filled rectangles using scenegraph</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgsimplerectnode.html">QSGSimpleRectNode</a></p>
 */
public class QSGSimpleRectNode extends io.qt.quick.QSGGeometryNode
{
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimplerectnode.html#QSGSimpleRectNode-1">QSGSimpleRectNode::QSGSimpleRectNode()</a></p>
     */
    public QSGSimpleRectNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGSimpleRectNode instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimplerectnode.html#QSGSimpleRectNode">QSGSimpleRectNode::QSGSimpleRectNode(QRectF,QColor)</a></p>
     */
    public QSGSimpleRectNode(io.qt.core.QRectF rect, io.qt.gui.QColor color){
        super((QPrivateConstructor)null);
        initialize_native(this, rect, color);
    }
    
    private native static void initialize_native(QSGSimpleRectNode instance, io.qt.core.QRectF rect, io.qt.gui.QColor color);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimplerectnode.html#color">QSGSimpleRectNode::color()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor color(){
        return color_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor color_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimplerectnode.html#rect">QSGSimpleRectNode::rect()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF rect(){
        return rect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF rect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimplerectnode.html#setColor">QSGSimpleRectNode::setColor(QColor)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setColor(io.qt.gui.QColor color){
        setColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimplerectnode.html#setRect">QSGSimpleRectNode::setRect(QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRect(io.qt.core.QRectF rect){
        setRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native void setRect_native_cref_QRectF(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgsimplerectnode.html#setRect-1">QSGSimpleRectNode::setRect(qreal,qreal,qreal,qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRect(double x, double y, double w, double h){
        setRect_native_qtjambireal_qtjambireal_qtjambireal_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, w, h);
    }
    
    @io.qt.QtUninvokable
    private native void setRect_native_qtjambireal_qtjambireal_qtjambireal_qtjambireal(long __this__nativeId, double x, double y, double w, double h);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGSimpleRectNode(QPrivateConstructor p) { super(p); } 
    
}
