package io.qt.quick;


/**
 * <p>Used to change opacity of nodes</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgopacitynode.html">QSGOpacityNode</a></p>
 */
public class QSGOpacityNode extends io.qt.quick.QSGNode
{
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgopacitynode.html#QSGOpacityNode">QSGOpacityNode::QSGOpacityNode()</a></p>
     */
    public QSGOpacityNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGOpacityNode instance);
    
    @io.qt.QtUninvokable
    public final double combinedOpacity(){
        return combinedOpacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double combinedOpacity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgopacitynode.html#opacity">QSGOpacityNode::opacity()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double opacity(){
        return opacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double opacity_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void setCombinedOpacity(double opacity){
        setCombinedOpacity_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), opacity);
    }
    
    @io.qt.QtUninvokable
    private native void setCombinedOpacity_native_qtjambireal(long __this__nativeId, double opacity);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgopacitynode.html#setOpacity">QSGOpacityNode::setOpacity(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setOpacity(double opacity){
        setOpacity_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), opacity);
    }
    
    @io.qt.QtUninvokable
    private native void setOpacity_native_qtjambireal(long __this__nativeId, double opacity);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#isSubtreeBlocked">QSGNode::isSubtreeBlocked()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isSubtreeBlocked(){
        return isSubtreeBlocked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSubtreeBlocked_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGOpacityNode(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
}
