package io.qt.quick;


/**
 * <p>The base class for all nodes in the scene graph</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgnode.html">QSGNode</a></p>
 */
public class QSGNode extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcChildren;
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgnode.html#DirtyStateBit-enum">QSGNode::DirtyStateBit</a></p>
     * 
     * @see DirtyState
     */
    public enum DirtyStateBit implements io.qt.QtFlagEnumerator {
        DirtySubtreeBlocked(128),
        DirtyMatrix(256),
        DirtyNodeAdded(1024),
        DirtyNodeRemoved(2048),
        DirtyGeometry(4096),
        DirtyMaterial(8192),
        DirtyOpacity(16384),
        DirtyForceUpdate(32768),
        DirtyUsePreprocess(2),
        DirtyPropagationMask(50432);

        private DirtyStateBit(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public DirtyState asFlags() {
            return new DirtyState(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public DirtyState combined(DirtyStateBit e) {
            return new DirtyState(this, e);
        }

        /**
         * Creates a new {@link DirtyState} from the entries.
         * @param values entries
         * @return new flag
         */
        public static DirtyState flags(DirtyStateBit ... values) {
            return new DirtyState(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DirtyStateBit resolve(int value) {
            switch (value) {
            case 128: return DirtySubtreeBlocked;
            case 256: return DirtyMatrix;
            case 1024: return DirtyNodeAdded;
            case 2048: return DirtyNodeRemoved;
            case 4096: return DirtyGeometry;
            case 8192: return DirtyMaterial;
            case 16384: return DirtyOpacity;
            case 32768: return DirtyForceUpdate;
            case 2: return DirtyUsePreprocess;
            case 50432: return DirtyPropagationMask;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link DirtyStateBit}
     */
    public static final class DirtyState extends io.qt.QFlags<DirtyStateBit> implements Comparable<DirtyState> {
        private static final long serialVersionUID = 0xf955c57a2a9651ecL;

        /**
         * Creates a new DirtyState where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public DirtyState(DirtyStateBit ... args){
            super(args);
        }

        /**
         * Creates a new DirtyState with given <code>value</code>.
         * @param value
         */
        public DirtyState(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new DirtyState
         */
        @Override
        public final DirtyState combined(DirtyStateBit e){
            return new DirtyState(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final DirtyState setFlag(DirtyStateBit e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final DirtyState setFlag(DirtyStateBit e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this DirtyState.
         * @return array of enum entries
         */
        @Override
        public final DirtyStateBit[] flags(){
            return super.flags(DirtyStateBit.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final DirtyState clone(){
            return new DirtyState(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(DirtyState other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgnode.html#Flag-enum">QSGNode::Flag</a></p>
     * 
     * @see Flags
     */
    public enum Flag implements io.qt.QtFlagEnumerator {
        OwnedByParent(1),
        UsePreprocess(2),
        OwnsGeometry(65536),
        OwnsMaterial(131072),
        OwnsOpaqueMaterial(262144),
        IsVisitableNode(16777216);

        private Flag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Flags asFlags() {
            return new Flags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Flags combined(Flag e) {
            return new Flags(this, e);
        }

        /**
         * Creates a new {@link Flags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Flags flags(Flag ... values) {
            return new Flags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Flag resolve(int value) {
            switch (value) {
            case 1: return OwnedByParent;
            case 2: return UsePreprocess;
            case 65536: return OwnsGeometry;
            case 131072: return OwnsMaterial;
            case 262144: return OwnsOpaqueMaterial;
            case 16777216: return IsVisitableNode;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Flag}
     */
    public static final class Flags extends io.qt.QFlags<Flag> implements Comparable<Flags> {
        private static final long serialVersionUID = 0x92d9bce6c929c1c6L;

        /**
         * Creates a new Flags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Flags(Flag ... args){
            super(args);
        }

        /**
         * Creates a new Flags with given <code>value</code>.
         * @param value
         */
        public Flags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Flags
         */
        @Override
        public final Flags combined(Flag e){
            return new Flags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Flags setFlag(Flag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Flags setFlag(Flag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Flags.
         * @return array of enum entries
         */
        @Override
        public final Flag[] flags(){
            return super.flags(Flag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Flags clone(){
            return new Flags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Flags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#QSGNode">QSGNode::QSGNode()</a></p>
     */
    public QSGNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGNode instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#appendChildNode">QSGNode::appendChildNode(QSGNode*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void appendChildNode(io.qt.quick.QSGNode node){
        java.util.Objects.requireNonNull(node, "Argument 'node': null not expected.");
        if(node.parent()!=null)
                                throw new IllegalArgumentException("QSGNode is already a child!");
        appendChildNode_native_QSGNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node));
        if (flags().isSet(QSGNode.Flag.OwnedByParent)) {
            QtJambi_LibraryUtilities.internal.setCppOwnership(node);
        }
        if (!flags().isSet(QSGNode.Flag.OwnedByParent)) {
            if(__rcChildren==null)
                __rcChildren = QtJambi_LibraryUtilities.internal.newRCList();
            __rcChildren.add(node);
        }
    }
    
    @io.qt.QtUninvokable
    private native void appendChildNode_native_QSGNode_ptr(long __this__nativeId, long node);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#childAtIndex">QSGNode::childAtIndex(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNode childAtIndex(int i){
        return childAtIndex_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNode childAtIndex_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#childCount">QSGNode::childCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int childCount(){
        return childCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int childCount_native_constfct(long __this__nativeId);
    
    @Deprecated
    @io.qt.QtUninvokable
    public final void clearDirty(){
        clearDirty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void clearDirty_native(long __this__nativeId);
    
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNode.DirtyState dirtyState(){
        return new io.qt.quick.QSGNode.DirtyState(dirtyState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int dirtyState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#firstChild">QSGNode::firstChild()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNode firstChild(){
        return firstChild_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNode firstChild_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#flags">QSGNode::flags()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNode.Flags flags(){
        return new io.qt.quick.QSGNode.Flags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#insertChildNodeAfter">QSGNode::insertChildNodeAfter(QSGNode*,QSGNode*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insertChildNodeAfter(io.qt.quick.QSGNode node, io.qt.quick.QSGNode after){
        java.util.Objects.requireNonNull(node, "Argument 'node': null not expected.");
        java.util.Objects.requireNonNull(after, "Argument 'after': null not expected.");
        if(node.parent()!=null)
                                throw new IllegalArgumentException("QSGNode is already a child!");
        insertChildNodeAfter_native_QSGNode_ptr_QSGNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node), QtJambi_LibraryUtilities.internal.checkedNativeId(after));
        if (flags().isSet(QSGNode.Flag.OwnedByParent)) {
            QtJambi_LibraryUtilities.internal.setCppOwnership(node);
        }
        if (!flags().isSet(QSGNode.Flag.OwnedByParent)) {
            if(__rcChildren==null)
                __rcChildren = QtJambi_LibraryUtilities.internal.newRCList();
            __rcChildren.add(node);
        }
    }
    
    @io.qt.QtUninvokable
    private native void insertChildNodeAfter_native_QSGNode_ptr_QSGNode_ptr(long __this__nativeId, long node, long after);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#insertChildNodeBefore">QSGNode::insertChildNodeBefore(QSGNode*,QSGNode*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void insertChildNodeBefore(io.qt.quick.QSGNode node, io.qt.quick.QSGNode before){
        java.util.Objects.requireNonNull(node, "Argument 'node': null not expected.");
        java.util.Objects.requireNonNull(before, "Argument 'before': null not expected.");
        if(node.parent()!=null)
                            throw new IllegalArgumentException("QSGNode is already a child!");
        insertChildNodeBefore_native_QSGNode_ptr_QSGNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node), QtJambi_LibraryUtilities.internal.checkedNativeId(before));
        if (flags().isSet(QSGNode.Flag.OwnedByParent)) {
            QtJambi_LibraryUtilities.internal.setCppOwnership(node);
        }
        if (!flags().isSet(QSGNode.Flag.OwnedByParent)) {
            if(__rcChildren==null)
                __rcChildren = QtJambi_LibraryUtilities.internal.newRCList();
            __rcChildren.add(node);
        }
    }
    
    @io.qt.QtUninvokable
    private native void insertChildNodeBefore_native_QSGNode_ptr_QSGNode_ptr(long __this__nativeId, long node, long before);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#lastChild">QSGNode::lastChild()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNode lastChild(){
        return lastChild_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNode lastChild_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #markDirty(io.qt.quick.QSGNode.DirtyState)}.</p>
     */
    @io.qt.QtUninvokable
    public final void markDirty(io.qt.quick.QSGNode.DirtyStateBit ... bits){
        markDirty(new io.qt.quick.QSGNode.DirtyState(bits));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#markDirty">QSGNode::markDirty(DirtyState)</a></p>
     */
    @io.qt.QtUninvokable
    public final void markDirty(io.qt.quick.QSGNode.DirtyState bits){
        markDirty_native_QFlags_QSGNode_DirtyStateBit_(QtJambi_LibraryUtilities.internal.nativeId(this), bits.value());
    }
    
    @io.qt.QtUninvokable
    private native void markDirty_native_QFlags_QSGNode_DirtyStateBit_(long __this__nativeId, int bits);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#nextSibling">QSGNode::nextSibling()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNode nextSibling(){
        return nextSibling_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNode nextSibling_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#parent">QSGNode::parent()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNode parent(){
        return parent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNode parent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#prependChildNode">QSGNode::prependChildNode(QSGNode*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void prependChildNode(io.qt.quick.QSGNode node){
        java.util.Objects.requireNonNull(node, "Argument 'node': null not expected.");
        if(node.parent()!=null)
                                throw new IllegalArgumentException("QSGNode is already a child!");
        prependChildNode_native_QSGNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node));
        if (flags().isSet(QSGNode.Flag.OwnedByParent)) {
            QtJambi_LibraryUtilities.internal.setCppOwnership(node);
        }
        if (!flags().isSet(QSGNode.Flag.OwnedByParent)) {
            if(__rcChildren==null)
                __rcChildren = QtJambi_LibraryUtilities.internal.newRCList();
            __rcChildren.add(node);
        }
    }
    
    @io.qt.QtUninvokable
    private native void prependChildNode_native_QSGNode_ptr(long __this__nativeId, long node);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#previousSibling">QSGNode::previousSibling()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNode previousSibling(){
        return previousSibling_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNode previousSibling_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#removeAllChildNodes">QSGNode::removeAllChildNodes()</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeAllChildNodes(){
        int size = childCount();
        java.util.List<QSGNode> nodes = new java.util.ArrayList<>(size);
        for (int i = 0; i < size; i++) {
            nodes.add(childAtIndex(i));
        }
        removeAllChildNodes_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        for (QSGNode node : nodes) {
            if (node!=null && node.flags().isSet(QSGNode.Flag.OwnedByParent)) {
                QtJambi_LibraryUtilities.internal.setDefaultOwnership(node);
            }
        }
        if(__rcChildren!=null)__rcChildren.clear();
    }
    
    @io.qt.QtUninvokable
    private native void removeAllChildNodes_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#removeChildNode">QSGNode::removeChildNode(QSGNode*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeChildNode(io.qt.quick.QSGNode node){
        java.util.Objects.requireNonNull(node, "Argument 'node': null not expected.");
        removeChildNode_native_QSGNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node));
        if (flags().isSet(QSGNode.Flag.OwnedByParent)) {
            QtJambi_LibraryUtilities.internal.setDefaultOwnership(node);
        }
        while (__rcChildren != null && __rcChildren.remove(node)) ;
    }
    
    @io.qt.QtUninvokable
    private native void removeChildNode_native_QSGNode_ptr(long __this__nativeId, long node);
    
    @io.qt.QtUninvokable
    public final void reparentChildNodesTo(io.qt.quick.QSGNode newParent){
        reparentChildNodesTo_native_QSGNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newParent));
    }
    
    @io.qt.QtUninvokable
    private native void reparentChildNodesTo_native_QSGNode_ptr(long __this__nativeId, long newParent);
    
    /**
     * <p>Overloaded function for {@link #setFlag(io.qt.quick.QSGNode.Flag, boolean)}
     *  with <code>arg__2 = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QSGNode.Flag arg__1) {
        setFlag(arg__1, (boolean)true);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#setFlag">QSGNode::setFlag(QSGNode::Flag,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QSGNode.Flag arg__1, boolean arg__2){
        setFlag_native_QSGNode_Flag_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value(), arg__2);
    }
    
    @io.qt.QtUninvokable
    private native void setFlag_native_QSGNode_Flag_bool(long __this__nativeId, int arg__1, boolean arg__2);
    
    /**
     * <p>Overloaded function for {@link #setFlags(io.qt.quick.QSGNode.Flags, boolean)}
     *  with <code>arg__2 = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setFlags(io.qt.quick.QSGNode.Flags arg__1) {
        setFlags(arg__1, (boolean)true);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#setFlags">QSGNode::setFlags(Flags,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFlags(io.qt.quick.QSGNode.Flags arg__1, boolean arg__2){
        setFlags_native_QFlags_QSGNode_Flag__bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value(), arg__2);
    }
    
    @io.qt.QtUninvokable
    private native void setFlags_native_QFlags_QSGNode_Flag__bool(long __this__nativeId, int arg__1, boolean arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#isSubtreeBlocked">QSGNode::isSubtreeBlocked()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isSubtreeBlocked(){
        return isSubtreeBlocked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSubtreeBlocked_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgnode.html#preprocess">QSGNode::preprocess()</a></p>
     */
    @io.qt.QtUninvokable
    public void preprocess(){
        preprocess_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void preprocess_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGNode(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
}
