package io.qt.quick;


/**
 * <p>Represents an OpenGL shader program in the renderer</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html">QSGMaterialShader</a></p>
 */
public abstract class QSGMaterialShader extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSGMaterialShader {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public java.lang.String[] attributeNames(){
            return attributeNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.lang.String[] attributeNames_native_constfct(long __this__nativeId);
        
    }
    
    /**
     * <p>QSGMaterialShader::RenderState encapsulates the current rendering state during a call to QSGMaterialShader::updateState()</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html">QSGMaterialShader::RenderState</a></p>
     */
    public static class RenderState extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        /**
         * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#DirtyState-enum">QSGMaterialShader::RenderState::DirtyState</a></p>
         * 
         * @see DirtyStates
         */
        public enum DirtyState implements io.qt.QtFlagEnumerator {
            DirtyMatrix(1),
            DirtyOpacity(2),
            DirtyCachedMaterialData(4),
            DirtyAll(65535);

            private DirtyState(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Create a QFlags of the enum entry.
             * @return QFlags
             */
            public DirtyStates asFlags() {
                return new DirtyStates(value);
            }

            /**
             * Combines this entry with other enum entry.
             * @param e enum entry
             * @return new flag
             */
            public DirtyStates combined(DirtyState e) {
                return new DirtyStates(this, e);
            }

            /**
             * Creates a new {@link DirtyStates} from the entries.
             * @param values entries
             * @return new flag
             */
            public static DirtyStates flags(DirtyState ... values) {
                return new DirtyStates(values);
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static DirtyState resolve(int value) {
                switch (value) {
                case 1: return DirtyMatrix;
                case 2: return DirtyOpacity;
                case 4: return DirtyCachedMaterialData;
                case 65535: return DirtyAll;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        /**
         * QFlags type for enum {@link DirtyState}
         */
        public static final class DirtyStates extends io.qt.QFlags<DirtyState> implements Comparable<DirtyStates> {
            private static final long serialVersionUID = 0x8dc3e7d21adb861cL;

            /**
             * Creates a new DirtyStates where the flags in <code>args</code> are set.
             * @param args enum entries
             */
            public DirtyStates(DirtyState ... args){
                super(args);
            }

            /**
             * Creates a new DirtyStates with given <code>value</code>.
             * @param value
             */
            public DirtyStates(int value) {
                super(value);
            }

            /**
             * Combines this flags with enum entry.
             * @param e enum entry
             * @return new DirtyStates
             */
            @Override
            public final DirtyStates combined(DirtyState e){
                return new DirtyStates(value() | e.value());
            }

            /**
             * Sets the flag <code>e</code>
             * @param e enum entry
             * @return this
             */
            public final DirtyStates setFlag(DirtyState e){
                super.setFlag(e);
                return this;
            }

            /**
             * Sets or clears the flag <code>flag</code>
             * @param e enum entry
             * @param on set (true) or clear (false)
             * @return this
             */
            public final DirtyStates setFlag(DirtyState e, boolean on){
                super.setFlag(e, on);
                return this;
            }

            /**
             * Returns an array of flag objects represented by this DirtyStates.
             * @return array of enum entries
             */
            @Override
            public final DirtyState[] flags(){
                return super.flags(DirtyState.values());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final DirtyStates clone(){
                return new DirtyStates(value());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final int compareTo(DirtyStates other){
                return Integer.compare(value(), other.value());
            }
        }
        
        
        public RenderState(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(RenderState instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#combinedMatrix">QSGMaterialShader::RenderState::combinedMatrix()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QMatrix4x4 combinedMatrix(){
            return combinedMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 combinedMatrix_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#context">QSGMaterialShader::RenderState::context()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QOpenGLContext context(){
            return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QOpenGLContext context_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#determinant">QSGMaterialShader::RenderState::determinant()const</a></p>
         */
        @io.qt.QtUninvokable
        public final float determinant(){
            return determinant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float determinant_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#devicePixelRatio">QSGMaterialShader::RenderState::devicePixelRatio()const</a></p>
         */
        @io.qt.QtUninvokable
        public final float devicePixelRatio(){
            return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float devicePixelRatio_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#deviceRect">QSGMaterialShader::RenderState::deviceRect()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QRect deviceRect(){
            return deviceRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QRect deviceRect_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#dirtyStates">QSGMaterialShader::RenderState::dirtyStates()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialShader.RenderState.DirtyStates dirtyStates(){
            return new io.qt.quick.QSGMaterialShader.RenderState.DirtyStates(dirtyStates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int dirtyStates_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#isCachedMaterialDataDirty">QSGMaterialShader::RenderState::isCachedMaterialDataDirty()const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isCachedMaterialDataDirty(){
            return isCachedMaterialDataDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isCachedMaterialDataDirty_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#isMatrixDirty">QSGMaterialShader::RenderState::isMatrixDirty()const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isMatrixDirty(){
            return isMatrixDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isMatrixDirty_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#isOpacityDirty">QSGMaterialShader::RenderState::isOpacityDirty()const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isOpacityDirty(){
            return isOpacityDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isOpacityDirty_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#modelViewMatrix">QSGMaterialShader::RenderState::modelViewMatrix()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QMatrix4x4 modelViewMatrix(){
            return modelViewMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 modelViewMatrix_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#opacity">QSGMaterialShader::RenderState::opacity()const</a></p>
         */
        @io.qt.QtUninvokable
        public final float opacity(){
            return opacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float opacity_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#projectionMatrix">QSGMaterialShader::RenderState::projectionMatrix()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QMatrix4x4 projectionMatrix(){
            return projectionMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 projectionMatrix_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader-renderstate.html#viewportRect">QSGMaterialShader::RenderState::viewportRect()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QRect viewportRect(){
            return viewportRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QRect viewportRect_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected RenderState(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public RenderState clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native RenderState clone_native(long __this_nativeId);
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#QSGMaterialShader">QSGMaterialShader::QSGMaterialShader()</a></p>
     */
    public QSGMaterialShader(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGMaterialShader instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#program">QSGMaterialShader::program()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLShaderProgram program(){
        return program_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QOpenGLShaderProgram program_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#setShaderSourceFile">QSGMaterialShader::setShaderSourceFile(QOpenGLShader::ShaderType,QString)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setShaderSourceFile(io.qt.gui.QOpenGLShader.ShaderType type, java.lang.String sourceFile){
        setShaderSourceFile_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), sourceFile);
    }
    
    @io.qt.QtUninvokable
    private native void setShaderSourceFile_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(long __this__nativeId, int type, java.lang.String sourceFile);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#setShaderSourceFiles">QSGMaterialShader::setShaderSourceFiles(QOpenGLShader::ShaderType,QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setShaderSourceFiles(io.qt.gui.QOpenGLShader.ShaderType type, java.util.Collection<java.lang.String> sourceFiles){
        setShaderSourceFiles_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), sourceFiles);
    }
    
    @io.qt.QtUninvokable
    private native void setShaderSourceFiles_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QStringList(long __this__nativeId, int type, java.util.Collection<java.lang.String> sourceFiles);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#activate">QSGMaterialShader::activate()</a></p>
     */
    @io.qt.QtUninvokable
    public void activate(){
        activate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void activate_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#attributeNames">QSGMaterialShader::attributeNames()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.lang.String[] attributeNames();
    
    @io.qt.QtUninvokable
    private native java.lang.String[] attributeNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#compile">QSGMaterialShader::compile()</a></p>
     */
    @io.qt.QtUninvokable
    protected void compile(){
        compile_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void compile_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#deactivate">QSGMaterialShader::deactivate()</a></p>
     */
    @io.qt.QtUninvokable
    public void deactivate(){
        deactivate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void deactivate_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#fragmentShader">QSGMaterialShader::fragmentShader()const</a></p>
     */
    @io.qt.QtUninvokable
    protected java.lang.String fragmentShader(){
        return fragmentShader_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String fragmentShader_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#initialize">QSGMaterialShader::initialize()</a></p>
     */
    @io.qt.QtUninvokable
    protected void initialize(){
        initialize_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void initialize_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#updateState">QSGMaterialShader::updateState(QSGMaterialShader::RenderState,QSGMaterial*,QSGMaterial*)</a></p>
     */
    @io.qt.QtUninvokable
    public void updateState(io.qt.quick.QSGMaterialShader.RenderState state, io.qt.quick.QSGMaterial newMaterial, io.qt.quick.QSGMaterial oldMaterial){
        updateState_native_cref_QSGMaterialShader_RenderState_QSGMaterial_ptr_QSGMaterial_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state), QtJambi_LibraryUtilities.internal.checkedNativeId(newMaterial), QtJambi_LibraryUtilities.internal.checkedNativeId(oldMaterial));
    }
    
    @io.qt.QtUninvokable
    private native void updateState_native_cref_QSGMaterialShader_RenderState_QSGMaterial_ptr_QSGMaterial_ptr(long __this__nativeId, long state, long newMaterial, long oldMaterial);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#vertexShader">QSGMaterialShader::vertexShader()const</a></p>
     */
    @io.qt.QtUninvokable
    protected java.lang.String vertexShader(){
        return vertexShader_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String vertexShader_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGMaterialShader(QPrivateConstructor p) { super(p); } 
    
}
