package io.qt.quick;


/**
 * <p>Represents a graphics API independent shader program</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader.html">QSGMaterialRhiShader</a></p>
 */
public class QSGMaterialRhiShader extends io.qt.quick.QSGMaterialShader
{
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader.html#Flag-enum">QSGMaterialRhiShader::Flag</a></p>
     * 
     * @see Flags
     */
    public enum Flag implements io.qt.QtFlagEnumerator {
        UpdatesGraphicsPipelineState(1);

        private Flag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Flags asFlags() {
            return new Flags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Flags combined(Flag e) {
            return new Flags(this, e);
        }

        /**
         * Creates a new {@link Flags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Flags flags(Flag ... values) {
            return new Flags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Flag resolve(int value) {
            switch (value) {
            case 1: return UpdatesGraphicsPipelineState;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Flag}
     */
    public static final class Flags extends io.qt.QFlags<Flag> implements Comparable<Flags> {
        private static final long serialVersionUID = 0x92d9bce6c929c1c6L;

        /**
         * Creates a new Flags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Flags(Flag ... args){
            super(args);
        }

        /**
         * Creates a new Flags with given <code>value</code>.
         * @param value
         */
        public Flags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Flags
         */
        @Override
        public final Flags combined(Flag e){
            return new Flags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Flags setFlag(Flag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Flags setFlag(Flag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Flags.
         * @return array of enum entries
         */
        @Override
        public final Flag[] flags(){
            return super.flags(Flag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Flags clone(){
            return new Flags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Flags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum QSGMaterialRhiShader::Stage</p>
     */
    public enum Stage implements io.qt.QtEnumerator {
        VertexStage(0),
        FragmentStage(1);

        private Stage(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Stage resolve(int value) {
            switch (value) {
            case 0: return VertexStage;
            case 1: return FragmentStage;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Encapsulates the current rendering state during a call to QSGMaterialRhiShader::updateUniformData() and the other update type of functions</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html">QSGMaterialRhiShader::RenderState</a></p>
     */
    public static class RenderState extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public RenderState(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(RenderState instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#combinedMatrix">QSGMaterialRhiShader::RenderState::combinedMatrix()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QMatrix4x4 combinedMatrix(){
            return combinedMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 combinedMatrix_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#determinant">QSGMaterialRhiShader::RenderState::determinant()const</a></p>
         */
        @io.qt.QtUninvokable
        public final float determinant(){
            return determinant_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float determinant_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#devicePixelRatio">QSGMaterialRhiShader::RenderState::devicePixelRatio()const</a></p>
         */
        @io.qt.QtUninvokable
        public final float devicePixelRatio(){
            return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float devicePixelRatio_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#deviceRect">QSGMaterialRhiShader::RenderState::deviceRect()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QRect deviceRect(){
            return deviceRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QRect deviceRect_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#dirtyStates">QSGMaterialRhiShader::RenderState::dirtyStates()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialShader.RenderState.DirtyStates dirtyStates(){
            return new io.qt.quick.QSGMaterialShader.RenderState.DirtyStates(dirtyStates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int dirtyStates_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#isMatrixDirty">QSGMaterialRhiShader::RenderState::isMatrixDirty()const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isMatrixDirty(){
            return isMatrixDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isMatrixDirty_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#isOpacityDirty">QSGMaterialRhiShader::RenderState::isOpacityDirty()const</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean isOpacityDirty(){
            return isOpacityDirty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isOpacityDirty_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#modelViewMatrix">QSGMaterialRhiShader::RenderState::modelViewMatrix()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QMatrix4x4 modelViewMatrix(){
            return modelViewMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 modelViewMatrix_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#opacity">QSGMaterialRhiShader::RenderState::opacity()const</a></p>
         */
        @io.qt.QtUninvokable
        public final float opacity(){
            return opacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float opacity_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#projectionMatrix">QSGMaterialRhiShader::RenderState::projectionMatrix()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.gui.QMatrix4x4 projectionMatrix(){
            return projectionMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QMatrix4x4 projectionMatrix_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-renderstate.html#viewportRect">QSGMaterialRhiShader::RenderState::viewportRect()const</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QRect viewportRect(){
            return viewportRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QRect viewportRect_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected RenderState(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public RenderState clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native RenderState clone_native(long __this_nativeId);
    }
    /**
     * <p>Describes state changes that the material wants to apply to the currently active graphics pipeline state</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-graphicspipelinestate.html">QSGMaterialRhiShader::GraphicsPipelineState</a></p>
     */
    public static class GraphicsPipelineState extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        /**
         * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-graphicspipelinestate.html#BlendFactor-enum">QSGMaterialRhiShader::GraphicsPipelineState::BlendFactor</a></p>
         */
        public enum BlendFactor implements io.qt.QtEnumerator {
            Zero(0),
            One(1),
            SrcColor(2),
            OneMinusSrcColor(3),
            DstColor(4),
            OneMinusDstColor(5),
            SrcAlpha(6),
            OneMinusSrcAlpha(7),
            DstAlpha(8),
            OneMinusDstAlpha(9),
            ConstantColor(10),
            OneMinusConstantColor(11),
            ConstantAlpha(12),
            OneMinusConstantAlpha(13),
            SrcAlphaSaturate(14),
            Src1Color(15),
            OneMinusSrc1Color(16),
            Src1Alpha(17),
            OneMinusSrc1Alpha(18);

            private BlendFactor(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static BlendFactor resolve(int value) {
                switch (value) {
                case 0: return Zero;
                case 1: return One;
                case 2: return SrcColor;
                case 3: return OneMinusSrcColor;
                case 4: return DstColor;
                case 5: return OneMinusDstColor;
                case 6: return SrcAlpha;
                case 7: return OneMinusSrcAlpha;
                case 8: return DstAlpha;
                case 9: return OneMinusDstAlpha;
                case 10: return ConstantColor;
                case 11: return OneMinusConstantColor;
                case 12: return ConstantAlpha;
                case 13: return OneMinusConstantAlpha;
                case 14: return SrcAlphaSaturate;
                case 15: return Src1Color;
                case 16: return OneMinusSrc1Color;
                case 17: return Src1Alpha;
                case 18: return OneMinusSrc1Alpha;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        /**
         * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-graphicspipelinestate.html#ColorMaskComponent-enum">QSGMaterialRhiShader::GraphicsPipelineState::ColorMaskComponent</a></p>
         * 
         * @see ColorMask
         */
        public enum ColorMaskComponent implements io.qt.QtFlagEnumerator {
            R(1),
            G(2),
            B(4),
            A(8);

            private ColorMaskComponent(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Create a QFlags of the enum entry.
             * @return QFlags
             */
            public ColorMask asFlags() {
                return new ColorMask(value);
            }

            /**
             * Combines this entry with other enum entry.
             * @param e enum entry
             * @return new flag
             */
            public ColorMask combined(ColorMaskComponent e) {
                return new ColorMask(this, e);
            }

            /**
             * Creates a new {@link ColorMask} from the entries.
             * @param values entries
             * @return new flag
             */
            public static ColorMask flags(ColorMaskComponent ... values) {
                return new ColorMask(values);
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static ColorMaskComponent resolve(int value) {
                switch (value) {
                case 1: return R;
                case 2: return G;
                case 4: return B;
                case 8: return A;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        /**
         * QFlags type for enum {@link ColorMaskComponent}
         */
        public static final class ColorMask extends io.qt.QFlags<ColorMaskComponent> implements Comparable<ColorMask> {
            private static final long serialVersionUID = 0xb6e9f22153371f6aL;

            /**
             * Creates a new ColorMask where the flags in <code>args</code> are set.
             * @param args enum entries
             */
            public ColorMask(ColorMaskComponent ... args){
                super(args);
            }

            /**
             * Creates a new ColorMask with given <code>value</code>.
             * @param value
             */
            public ColorMask(int value) {
                super(value);
            }

            /**
             * Combines this flags with enum entry.
             * @param e enum entry
             * @return new ColorMask
             */
            @Override
            public final ColorMask combined(ColorMaskComponent e){
                return new ColorMask(value() | e.value());
            }

            /**
             * Sets the flag <code>e</code>
             * @param e enum entry
             * @return this
             */
            public final ColorMask setFlag(ColorMaskComponent e){
                super.setFlag(e);
                return this;
            }

            /**
             * Sets or clears the flag <code>flag</code>
             * @param e enum entry
             * @param on set (true) or clear (false)
             * @return this
             */
            public final ColorMask setFlag(ColorMaskComponent e, boolean on){
                super.setFlag(e, on);
                return this;
            }

            /**
             * Returns an array of flag objects represented by this ColorMask.
             * @return array of enum entries
             */
            @Override
            public final ColorMaskComponent[] flags(){
                return super.flags(ColorMaskComponent.values());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final ColorMask clone(){
                return new ColorMask(value());
            }

            /**
             * {@inheritDoc}
             */
            @Override
            public final int compareTo(ColorMask other){
                return Integer.compare(value(), other.value());
            }
        }
        
        /**
         * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader-graphicspipelinestate.html#CullMode-enum">QSGMaterialRhiShader::GraphicsPipelineState::CullMode</a></p>
         */
        public enum CullMode implements io.qt.QtEnumerator {
            CullNone(0),
            CullFront(1),
            CullBack(2);

            private CullMode(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static CullMode resolve(int value) {
                switch (value) {
                case 0: return CullNone;
                case 1: return CullFront;
                case 2: return CullBack;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        
        public GraphicsPipelineState(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(GraphicsPipelineState instance);
        
        @io.qt.QtUninvokable
        public final void setBlendConstant(io.qt.gui.QColor blendConstant){
            setBlendConstant_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(blendConstant));
        }
        
        @io.qt.QtUninvokable
        private native void setBlendConstant_native_cref_QColor(long __this__nativeId, long blendConstant);
        
        @io.qt.QtUninvokable
        public final io.qt.gui.QColor blendConstant(){
            return blendConstant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QColor blendConstant_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setBlendEnable(boolean blendEnable){
            setBlendEnable_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), blendEnable);
        }
        
        @io.qt.QtUninvokable
        private native void setBlendEnable_native_bool(long __this__nativeId, boolean blendEnable);
        
        @io.qt.QtUninvokable
        public final boolean blendEnable(){
            return blendEnable_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean blendEnable_native(long __this__nativeId);
        
        /**
         * <p>Overloaded function for {@link #setColorWrite(io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.ColorMask)}.</p>
         */
        @io.qt.QtUninvokable
        public final void setColorWrite(io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.ColorMaskComponent ... colorWrite){
            setColorWrite(new io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.ColorMask(colorWrite));
        }
        
        @io.qt.QtUninvokable
        public final void setColorWrite(io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.ColorMask colorWrite){
            setColorWrite_native_cref_QFlags_QSGMaterialRhiShader_GraphicsPipelineState_ColorMaskComponent_(QtJambi_LibraryUtilities.internal.nativeId(this), colorWrite.value());
        }
        
        @io.qt.QtUninvokable
        private native void setColorWrite_native_cref_QFlags_QSGMaterialRhiShader_GraphicsPipelineState_ColorMaskComponent_(long __this__nativeId, int colorWrite);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.ColorMask colorWrite(){
            return new io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.ColorMask(colorWrite_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int colorWrite_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setCullMode(io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.CullMode cullMode){
            setCullMode_native_cref_QSGMaterialRhiShader_GraphicsPipelineState_CullMode(QtJambi_LibraryUtilities.internal.nativeId(this), cullMode.value());
        }
        
        @io.qt.QtUninvokable
        private native void setCullMode_native_cref_QSGMaterialRhiShader_GraphicsPipelineState_CullMode(long __this__nativeId, int cullMode);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.CullMode cullMode(){
            return io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.CullMode.resolve(cullMode_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int cullMode_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setDstColor(io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.BlendFactor dstColor){
            setDstColor_native_cref_QSGMaterialRhiShader_GraphicsPipelineState_BlendFactor(QtJambi_LibraryUtilities.internal.nativeId(this), dstColor.value());
        }
        
        @io.qt.QtUninvokable
        private native void setDstColor_native_cref_QSGMaterialRhiShader_GraphicsPipelineState_BlendFactor(long __this__nativeId, int dstColor);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.BlendFactor dstColor(){
            return io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.BlendFactor.resolve(dstColor_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int dstColor_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setSrcColor(io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.BlendFactor srcColor){
            setSrcColor_native_cref_QSGMaterialRhiShader_GraphicsPipelineState_BlendFactor(QtJambi_LibraryUtilities.internal.nativeId(this), srcColor.value());
        }
        
        @io.qt.QtUninvokable
        private native void setSrcColor_native_cref_QSGMaterialRhiShader_GraphicsPipelineState_BlendFactor(long __this__nativeId, int srcColor);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.BlendFactor srcColor(){
            return io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState.BlendFactor.resolve(srcColor_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int srcColor_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected GraphicsPipelineState(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public GraphicsPipelineState clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native GraphicsPipelineState clone_native(long __this_nativeId);
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader.html#QSGMaterialRhiShader">QSGMaterialRhiShader::QSGMaterialRhiShader()</a></p>
     */
    public QSGMaterialRhiShader(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSGMaterialRhiShader instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader.html#flags">QSGMaterialRhiShader::flags()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGMaterialRhiShader.Flags flags(){
        return new io.qt.quick.QSGMaterialRhiShader.Flags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setFlag(io.qt.quick.QSGMaterialRhiShader.Flags, boolean)}
     *  with <code>on = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QSGMaterialRhiShader.Flags flags) {
        setFlag(flags, (boolean)true);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader.html#setFlag">QSGMaterialRhiShader::setFlag(Flags,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QSGMaterialRhiShader.Flags flags, boolean on){
        setFlag_native_QFlags_QSGMaterialRhiShader_Flag__bool(QtJambi_LibraryUtilities.internal.nativeId(this), flags.value(), on);
    }
    
    @io.qt.QtUninvokable
    private native void setFlag_native_QFlags_QSGMaterialRhiShader_Flag__bool(long __this__nativeId, int flags, boolean on);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader.html#setShaderFileName">QSGMaterialRhiShader::setShaderFileName(QSGMaterialRhiShader::Stage,QString)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setShaderFileName(io.qt.quick.QSGMaterialRhiShader.Stage stage, java.lang.String filename){
        setShaderFileName_native_QSGMaterialRhiShader_Stage_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), stage.value(), filename);
    }
    
    @io.qt.QtUninvokable
    private native void setShaderFileName_native_QSGMaterialRhiShader_Stage_cref_QString(long __this__nativeId, int stage, java.lang.String filename);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialshader.html#attributeNames">QSGMaterialShader::attributeNames()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.String[] attributeNames(){
        return attributeNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String[] attributeNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader.html#updateGraphicsPipelineState">QSGMaterialRhiShader::updateGraphicsPipelineState(QSGMaterialRhiShader::RenderState&amp;,QSGMaterialRhiShader::GraphicsPipelineState*,QSGMaterial*,QSGMaterial*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean updateGraphicsPipelineState(io.qt.quick.QSGMaterialRhiShader.RenderState state, io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState ps, io.qt.quick.QSGMaterial newMaterial, io.qt.quick.QSGMaterial oldMaterial){
        java.util.Objects.requireNonNull(state, "Argument 'state': null not expected.");
        return updateGraphicsPipelineState_native_ref_QSGMaterialRhiShader_RenderState_QSGMaterialRhiShader_GraphicsPipelineState_ptr_QSGMaterial_ptr_QSGMaterial_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), state, ps, QtJambi_LibraryUtilities.internal.checkedNativeId(newMaterial), QtJambi_LibraryUtilities.internal.checkedNativeId(oldMaterial));
    }
    
    @io.qt.QtUninvokable
    private native boolean updateGraphicsPipelineState_native_ref_QSGMaterialRhiShader_RenderState_QSGMaterialRhiShader_GraphicsPipelineState_ptr_QSGMaterial_ptr_QSGMaterial_ptr(long __this__nativeId, io.qt.quick.QSGMaterialRhiShader.RenderState state, io.qt.quick.QSGMaterialRhiShader.GraphicsPipelineState ps, long newMaterial, long oldMaterial);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader.html#updateSampledImage">QSGMaterialRhiShader::updateSampledImage(QSGMaterialRhiShader::RenderState&amp;,int,QSGTexture**,QSGMaterial*,QSGMaterial*)</a></p>
     */
    @io.qt.QtUninvokable
    public void updateSampledImage(io.qt.quick.QSGMaterialRhiShader.RenderState state, int binding, io.qt.quick.QSGTexture[] texture, io.qt.quick.QSGMaterial newMaterial, io.qt.quick.QSGMaterial oldMaterial){
        java.util.Objects.requireNonNull(state, "Argument 'state': null not expected.");
        java.util.Objects.requireNonNull(texture, "Argument 'texture': null not expected.");
        if(texture.length < 1)
            throw new IllegalArgumentException("Argument 'texture': Wrong number of elements in array. Found: " + texture.length + ", expected: 1");
        updateSampledImage_native_ref_QSGMaterialRhiShader_RenderState_int_QSGTexture_ptr_ptr_QSGMaterial_ptr_QSGMaterial_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), state, binding, texture, QtJambi_LibraryUtilities.internal.checkedNativeId(newMaterial), QtJambi_LibraryUtilities.internal.checkedNativeId(oldMaterial));
    }
    
    @io.qt.QtUninvokable
    private native void updateSampledImage_native_ref_QSGMaterialRhiShader_RenderState_int_QSGTexture_ptr_ptr_QSGMaterial_ptr_QSGMaterial_ptr(long __this__nativeId, io.qt.quick.QSGMaterialRhiShader.RenderState state, int binding, io.qt.quick.QSGTexture[] texture, long newMaterial, long oldMaterial);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgmaterialrhishader.html#updateUniformData">QSGMaterialRhiShader::updateUniformData(QSGMaterialRhiShader::RenderState&amp;,QSGMaterial*,QSGMaterial*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean updateUniformData(io.qt.quick.QSGMaterialRhiShader.RenderState state, io.qt.quick.QSGMaterial newMaterial, io.qt.quick.QSGMaterial oldMaterial){
        java.util.Objects.requireNonNull(state, "Argument 'state': null not expected.");
        return updateUniformData_native_ref_QSGMaterialRhiShader_RenderState_QSGMaterial_ptr_QSGMaterial_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), state, QtJambi_LibraryUtilities.internal.checkedNativeId(newMaterial), QtJambi_LibraryUtilities.internal.checkedNativeId(oldMaterial));
    }
    
    @io.qt.QtUninvokable
    private native boolean updateUniformData_native_ref_QSGMaterialRhiShader_RenderState_QSGMaterial_ptr_QSGMaterial_ptr(long __this__nativeId, io.qt.quick.QSGMaterialRhiShader.RenderState state, long newMaterial, long oldMaterial);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGMaterialRhiShader(QPrivateConstructor p) { super(p); } 
    
}
